/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.hibernate.cache.v60.functional.cluster;

import java.util.Map;
import java.util.Properties;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.cfg.spi.DomainDataRegionBuildingContext;
import org.hibernate.cache.cfg.spi.DomainDataRegionConfig;
import org.hibernate.cache.spi.CacheTransactionSynchronization;
import org.hibernate.cache.spi.DomainDataRegion;
import org.hibernate.cache.spi.QueryResultsRegion;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.TimestampsRegion;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.infinispan.hibernate.cache.v60.InfinispanRegionFactory;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.hibernate.cache.commons.functional.cluster.ClusterAware;
import org.infinispan.test.hibernate.cache.commons.util.CacheTestUtil;

public class ClusterAwareRegionFactory
implements RegionFactory {
    private InfinispanRegionFactory delegate;
    private String cacheManagerName;
    private boolean locallyAdded;

    public ClusterAwareRegionFactory(Properties props) {
        Class regionFactoryClass = (Class)props.get("hibernate.cache.region.factory_delegate");
        this.delegate = (InfinispanRegionFactory)CacheTestUtil.createRegionFactory((Class)regionFactoryClass, (Properties)props);
    }

    public void start(SessionFactoryOptions settings, Map configValues) throws CacheException {
        this.cacheManagerName = (String)configValues.get("hibernate.test.cluster.node.id");
        EmbeddedCacheManager existing = ClusterAware.getCacheManager((String)this.cacheManagerName);
        boolean bl = this.locallyAdded = existing == null;
        if (this.locallyAdded) {
            this.delegate.start(settings, configValues);
            ClusterAware.addCacheManager((String)this.cacheManagerName, (EmbeddedCacheManager)this.delegate.getCacheManager());
        } else {
            this.delegate.setCacheManager(existing);
        }
    }

    public void stop() {
        if (this.locallyAdded) {
            ClusterAware.removeCacheManager((String)this.cacheManagerName);
        }
        this.delegate.stop();
    }

    public DomainDataRegion buildDomainDataRegion(DomainDataRegionConfig regionConfig, DomainDataRegionBuildingContext buildingContext) {
        return this.delegate.buildDomainDataRegion(regionConfig, buildingContext);
    }

    public QueryResultsRegion buildQueryResultsRegion(String regionName, SessionFactoryImplementor sessionFactory) throws CacheException {
        return this.delegate.buildQueryResultsRegion(regionName, sessionFactory);
    }

    public TimestampsRegion buildTimestampsRegion(String regionName, SessionFactoryImplementor sessionFactory) throws CacheException {
        return this.delegate.buildTimestampsRegion(regionName, sessionFactory);
    }

    public boolean isMinimalPutsEnabledByDefault() {
        return this.delegate.isMinimalPutsEnabledByDefault();
    }

    public AccessType getDefaultAccessType() {
        return AccessType.TRANSACTIONAL;
    }

    public String qualify(String regionName) {
        return this.delegate.qualify(regionName);
    }

    public long nextTimestamp() {
        return this.delegate.nextTimestamp();
    }

    public CacheTransactionSynchronization createTransactionContext(SharedSessionContractImplementor session) {
        return this.delegate.createTransactionContext(session);
    }

    public long getTimeout() {
        return this.delegate.getTimeout();
    }
}

