/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.hibernate.cache;

import java.io.InputStream;
import java.util.Properties;
import java.util.function.BiConsumer;
import javax.transaction.TransactionManager;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.internal.CacheDataDescriptionImpl;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cfg.Environment;
import org.hibernate.engine.transaction.jta.platform.internal.JBossStandAloneJtaPlatform;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.testing.ServiceRegistryBuilder;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.util.FileLookupFactory;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ClusteringConfigurationBuilder;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.hibernate.cache.InfinispanRegionFactory;
import org.infinispan.hibernate.cache.collection.CollectionRegionImpl;
import org.infinispan.hibernate.cache.entity.EntityRegionImpl;
import org.infinispan.hibernate.cache.query.QueryResultsRegionImpl;
import org.infinispan.hibernate.cache.timestamp.TimestampsRegionImpl;
import org.infinispan.hibernate.cache.tm.HibernateTransactionManagerLookup;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.hibernate.cache.util.CacheTestUtil;
import org.infinispan.test.hibernate.cache.util.InfinispanTestingSetup;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class InfinispanRegionFactoryTestCase {
    private static final CacheDataDescription MUTABLE_NON_VERSIONED = new CacheDataDescriptionImpl(true, false, null, null);
    private static final CacheDataDescription IMMUTABLE_NON_VERSIONED = new CacheDataDescriptionImpl(false, false, null, null);
    @Rule
    public InfinispanTestingSetup infinispanTestIdentifier = new InfinispanTestingSetup();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConfigurationProcessing() {
        String person = "com.acme.Person";
        String addresses = "com.acme.Person.addresses";
        Properties p = InfinispanRegionFactoryTestCase.createProperties();
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.cfg", "person-cache");
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.eviction.strategy", "LRU");
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.eviction.max_entries", "5000");
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.expiration.wake_up_interval", "2000");
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.expiration.lifespan", "60000");
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.expiration.max_idle", "30000");
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.addresses.cfg", "person-addresses-cache");
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.addresses.expiration.lifespan", "120000");
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.addresses.expiration.max_idle", "60000");
        p.setProperty("hibernate.cache.infinispan.query.cfg", "my-query-cache");
        p.setProperty("hibernate.cache.infinispan.query.eviction.strategy", "LIRS");
        p.setProperty("hibernate.cache.infinispan.query.expiration.wake_up_interval", "3000");
        p.setProperty("hibernate.cache.infinispan.query.eviction.max_entries", "10000");
        TestInfinispanRegionFactory factory = this.createRegionFactory(p);
        try {
            Assert.assertEquals((Object)"person-cache", (Object)factory.getBaseConfiguration("com.acme.Person"));
            Configuration personOverride = factory.getConfigurationOverride("com.acme.Person");
            Assert.assertEquals((Object)EvictionStrategy.LRU, (Object)personOverride.eviction().strategy());
            Assert.assertEquals((long)5000L, (long)personOverride.eviction().maxEntries());
            Assert.assertEquals((long)2000L, (long)personOverride.expiration().wakeUpInterval());
            Assert.assertEquals((long)60000L, (long)personOverride.expiration().lifespan());
            Assert.assertEquals((long)30000L, (long)personOverride.expiration().maxIdle());
            Assert.assertEquals((Object)"person-addresses-cache", (Object)factory.getBaseConfiguration("com.acme.Person.addresses"));
            Configuration addressesOverride = factory.getConfigurationOverride("com.acme.Person.addresses");
            Assert.assertEquals((long)120000L, (long)addressesOverride.expiration().lifespan());
            Assert.assertEquals((long)60000L, (long)addressesOverride.expiration().maxIdle());
            Assert.assertEquals((Object)"my-query-cache", (Object)factory.getBaseConfiguration(InfinispanRegionFactory.DataType.QUERY));
            Configuration queryOverride = factory.getConfigurationOverride(InfinispanRegionFactory.DataType.QUERY);
            Assert.assertEquals((Object)EvictionStrategy.LIRS, (Object)queryOverride.eviction().strategy());
            Assert.assertEquals((long)10000L, (long)queryOverride.eviction().maxEntries());
            Assert.assertEquals((long)3000L, (long)queryOverride.expiration().wakeUpInterval());
        }
        finally {
            factory.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBuildEntityCollectionRegionsPersonPlusEntityCollectionOverrides() {
        String person = "com.acme.Person";
        String address = "com.acme.Address";
        String car = "com.acme.Car";
        String addresses = "com.acme.Person.addresses";
        String parts = "com.acme.Car.parts";
        Properties p = InfinispanRegionFactoryTestCase.createProperties();
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.cfg", "person-cache");
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.eviction.strategy", "LRU");
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.eviction.max_entries", "5000");
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.expiration.wake_up_interval", "2000");
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.expiration.lifespan", "60000");
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.expiration.max_idle", "30000");
        p.setProperty("hibernate.cache.infinispan.entity.cfg", "myentity-cache");
        p.setProperty("hibernate.cache.infinispan.entity.eviction.strategy", "LIRS");
        p.setProperty("hibernate.cache.infinispan.entity.expiration.wake_up_interval", "3000");
        p.setProperty("hibernate.cache.infinispan.entity.eviction.max_entries", "20000");
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.addresses.cfg", "addresses-cache");
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.addresses.eviction.strategy", "LIRS");
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.addresses.eviction.max_entries", "5500");
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.addresses.expiration.wake_up_interval", "2500");
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.addresses.expiration.lifespan", "65000");
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.addresses.expiration.max_idle", "35000");
        p.setProperty("hibernate.cache.infinispan.collection.cfg", "mycollection-cache");
        p.setProperty("hibernate.cache.infinispan.collection.eviction.strategy", "LRU");
        p.setProperty("hibernate.cache.infinispan.collection.expiration.wake_up_interval", "3500");
        p.setProperty("hibernate.cache.infinispan.collection.eviction.max_entries", "25000");
        TestInfinispanRegionFactory factory = this.createRegionFactory(p);
        try {
            EmbeddedCacheManager manager = factory.getCacheManager();
            Assert.assertFalse((boolean)manager.getCacheManagerConfiguration().globalJmxStatistics().enabled());
            Assert.assertNotNull((Object)factory.getBaseConfiguration("com.acme.Person"));
            Assert.assertFalse((boolean)this.isDefinedCache(factory, "com.acme.Person"));
            Assert.assertNotNull((Object)factory.getBaseConfiguration("com.acme.Person.addresses"));
            Assert.assertFalse((boolean)this.isDefinedCache(factory, "com.acme.Person.addresses"));
            Assert.assertNull((Object)factory.getBaseConfiguration("com.acme.Address"));
            Assert.assertNull((Object)factory.getBaseConfiguration("com.acme.Car.parts"));
            EntityRegionImpl region = (EntityRegionImpl)factory.buildEntityRegion("com.acme.Person", p, MUTABLE_NON_VERSIONED);
            Assert.assertTrue((boolean)this.isDefinedCache(factory, "com.acme.Person"));
            AdvancedCache cache = region.getCache();
            Configuration cacheCfg = cache.getCacheConfiguration();
            Assert.assertEquals((Object)EvictionStrategy.LRU, (Object)cacheCfg.eviction().strategy());
            Assert.assertEquals((long)2000L, (long)cacheCfg.expiration().wakeUpInterval());
            Assert.assertEquals((long)5000L, (long)cacheCfg.eviction().maxEntries());
            Assert.assertEquals((long)60000L, (long)cacheCfg.expiration().lifespan());
            Assert.assertEquals((long)30000L, (long)cacheCfg.expiration().maxIdle());
            Assert.assertFalse((boolean)cacheCfg.jmxStatistics().enabled());
            region = (EntityRegionImpl)factory.buildEntityRegion("com.acme.Address", p, MUTABLE_NON_VERSIONED);
            Assert.assertTrue((boolean)this.isDefinedCache(factory, "com.acme.Person"));
            cache = region.getCache();
            cacheCfg = cache.getCacheConfiguration();
            Assert.assertEquals((Object)EvictionStrategy.LIRS, (Object)cacheCfg.eviction().strategy());
            Assert.assertEquals((long)3000L, (long)cacheCfg.expiration().wakeUpInterval());
            Assert.assertEquals((long)20000L, (long)cacheCfg.eviction().maxEntries());
            Assert.assertFalse((boolean)cacheCfg.jmxStatistics().enabled());
            region = (EntityRegionImpl)factory.buildEntityRegion("com.acme.Car", p, MUTABLE_NON_VERSIONED);
            Assert.assertTrue((boolean)this.isDefinedCache(factory, "com.acme.Person"));
            cache = region.getCache();
            cacheCfg = cache.getCacheConfiguration();
            Assert.assertEquals((Object)EvictionStrategy.LIRS, (Object)cacheCfg.eviction().strategy());
            Assert.assertEquals((long)3000L, (long)cacheCfg.expiration().wakeUpInterval());
            Assert.assertEquals((long)20000L, (long)cacheCfg.eviction().maxEntries());
            Assert.assertFalse((boolean)cacheCfg.jmxStatistics().enabled());
            CollectionRegionImpl collectionRegion = (CollectionRegionImpl)factory.buildCollectionRegion("com.acme.Person.addresses", p, MUTABLE_NON_VERSIONED);
            Assert.assertTrue((boolean)this.isDefinedCache(factory, "com.acme.Person"));
            cache = collectionRegion.getCache();
            cacheCfg = cache.getCacheConfiguration();
            Assert.assertEquals((Object)EvictionStrategy.LIRS, (Object)cacheCfg.eviction().strategy());
            Assert.assertEquals((long)2500L, (long)cacheCfg.expiration().wakeUpInterval());
            Assert.assertEquals((long)5500L, (long)cacheCfg.eviction().maxEntries());
            Assert.assertEquals((long)65000L, (long)cacheCfg.expiration().lifespan());
            Assert.assertEquals((long)35000L, (long)cacheCfg.expiration().maxIdle());
            Assert.assertFalse((boolean)cacheCfg.jmxStatistics().enabled());
            collectionRegion = (CollectionRegionImpl)factory.buildCollectionRegion("com.acme.Car.parts", p, MUTABLE_NON_VERSIONED);
            Assert.assertTrue((boolean)this.isDefinedCache(factory, "com.acme.Person.addresses"));
            cache = collectionRegion.getCache();
            cacheCfg = cache.getCacheConfiguration();
            Assert.assertEquals((Object)EvictionStrategy.LRU, (Object)cacheCfg.eviction().strategy());
            Assert.assertEquals((long)3500L, (long)cacheCfg.expiration().wakeUpInterval());
            Assert.assertEquals((long)25000L, (long)cacheCfg.eviction().maxEntries());
            Assert.assertFalse((boolean)cacheCfg.jmxStatistics().enabled());
            collectionRegion = (CollectionRegionImpl)factory.buildCollectionRegion("com.acme.Car.parts", p, MUTABLE_NON_VERSIONED);
            Assert.assertTrue((boolean)this.isDefinedCache(factory, "com.acme.Person.addresses"));
            cache = collectionRegion.getCache();
            cacheCfg = cache.getCacheConfiguration();
            Assert.assertEquals((Object)EvictionStrategy.LRU, (Object)cacheCfg.eviction().strategy());
            Assert.assertEquals((long)3500L, (long)cacheCfg.expiration().wakeUpInterval());
            Assert.assertEquals((long)25000L, (long)cacheCfg.eviction().maxEntries());
            Assert.assertFalse((boolean)cacheCfg.jmxStatistics().enabled());
        }
        finally {
            factory.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBuildEntityCollectionRegionOverridesOnly() {
        String address = "com.acme.Address";
        String personAddressses = "com.acme.Person.addresses";
        Properties p = InfinispanRegionFactoryTestCase.createProperties();
        p.setProperty("hibernate.cache.infinispan.entity.eviction.strategy", "LIRS");
        p.setProperty("hibernate.cache.infinispan.entity.eviction.max_entries", "30000");
        p.setProperty("hibernate.cache.infinispan.entity.expiration.wake_up_interval", "3000");
        p.setProperty("hibernate.cache.infinispan.collection.eviction.strategy", "LRU");
        p.setProperty("hibernate.cache.infinispan.collection.eviction.max_entries", "35000");
        p.setProperty("hibernate.cache.infinispan.collection.expiration.wake_up_interval", "3500");
        TestInfinispanRegionFactory factory = this.createRegionFactory(p);
        try {
            factory.getCacheManager();
            EntityRegionImpl region = (EntityRegionImpl)factory.buildEntityRegion("com.acme.Address", p, MUTABLE_NON_VERSIONED);
            Assert.assertNull((Object)factory.getBaseConfiguration("com.acme.Address"));
            AdvancedCache cache = region.getCache();
            Configuration cacheCfg = cache.getCacheConfiguration();
            Assert.assertEquals((Object)EvictionStrategy.LIRS, (Object)cacheCfg.eviction().strategy());
            Assert.assertEquals((long)3000L, (long)cacheCfg.expiration().wakeUpInterval());
            Assert.assertEquals((long)30000L, (long)cacheCfg.eviction().maxEntries());
            Assert.assertEquals((long)100000L, (long)cacheCfg.expiration().maxIdle());
            CollectionRegionImpl collectionRegion = (CollectionRegionImpl)factory.buildCollectionRegion("com.acme.Person.addresses", p, MUTABLE_NON_VERSIONED);
            Assert.assertNull((Object)factory.getBaseConfiguration("com.acme.Person.addresses"));
            cache = collectionRegion.getCache();
            cacheCfg = cache.getCacheConfiguration();
            Assert.assertEquals((Object)EvictionStrategy.LRU, (Object)cacheCfg.eviction().strategy());
            Assert.assertEquals((long)3500L, (long)cacheCfg.expiration().wakeUpInterval());
            Assert.assertEquals((long)35000L, (long)cacheCfg.eviction().maxEntries());
            Assert.assertEquals((long)100000L, (long)cacheCfg.expiration().maxIdle());
        }
        finally {
            factory.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBuildEntityRegionPersonPlusEntityOverridesWithoutCfg() {
        String person = "com.acme.Person";
        Properties p = InfinispanRegionFactoryTestCase.createProperties();
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.eviction.strategy", "LRU");
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.expiration.lifespan", "60000");
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.expiration.max_idle", "30000");
        p.setProperty("hibernate.cache.infinispan.entity.cfg", "myentity-cache");
        p.setProperty("hibernate.cache.infinispan.entity.eviction.strategy", "FIFO");
        p.setProperty("hibernate.cache.infinispan.entity.eviction.max_entries", "10000");
        p.setProperty("hibernate.cache.infinispan.entity.expiration.wake_up_interval", "3000");
        TestInfinispanRegionFactory factory = this.createRegionFactory(p);
        try {
            factory.getCacheManager();
            Assert.assertFalse((boolean)this.isDefinedCache(factory, "com.acme.Person"));
            EntityRegionImpl region = (EntityRegionImpl)factory.buildEntityRegion("com.acme.Person", p, MUTABLE_NON_VERSIONED);
            Assert.assertTrue((boolean)this.isDefinedCache(factory, "com.acme.Person"));
            AdvancedCache cache = region.getCache();
            Configuration cacheCfg = cache.getCacheConfiguration();
            Assert.assertEquals((Object)EvictionStrategy.LRU, (Object)cacheCfg.eviction().strategy());
            Assert.assertEquals((long)3000L, (long)cacheCfg.expiration().wakeUpInterval());
            Assert.assertEquals((long)10000L, (long)cacheCfg.eviction().maxEntries());
            Assert.assertEquals((long)60000L, (long)cacheCfg.expiration().lifespan());
            Assert.assertEquals((long)30000L, (long)cacheCfg.expiration().maxIdle());
        }
        finally {
            factory.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBuildImmutableEntityRegion() {
        Properties p = new Properties();
        TestInfinispanRegionFactory factory = this.createRegionFactory(p);
        try {
            factory.getCacheManager();
            EntityRegionImpl region = (EntityRegionImpl)factory.buildEntityRegion("com.acme.Address", p, IMMUTABLE_NON_VERSIONED);
            Assert.assertNull((Object)factory.getBaseConfiguration("com.acme.Address"));
            AdvancedCache cache = region.getCache();
            Configuration cacheCfg = cache.getCacheConfiguration();
            Assert.assertEquals((String)"Immutable entity should get non-transactional cache", (Object)TransactionMode.NON_TRANSACTIONAL, (Object)cacheCfg.transaction().transactionMode());
        }
        finally {
            factory.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=CacheException.class)
    public void testTimestampValidation() {
        String timestamps = "org.hibernate.cache.spi.UpdateTimestampsCache";
        Properties p = InfinispanRegionFactoryTestCase.createProperties();
        InputStream configStream = FileLookupFactory.newInstance().lookupFile("org/infinispan/hibernate/cache/builder/infinispan-configs.xml", this.getClass().getClassLoader());
        ConfigurationBuilderHolder cbh = new ParserRegistry().parse(configStream);
        ConfigurationBuilder builder = (ConfigurationBuilder)cbh.getNamedConfigurationBuilders().get("timestamps");
        builder.clustering().cacheMode(CacheMode.INVALIDATION_SYNC);
        DefaultCacheManager manager = new DefaultCacheManager(cbh, true);
        try {
            TestInfinispanRegionFactory factory = this.createRegionFactory((EmbeddedCacheManager)manager, p, null);
            factory.start(CacheTestUtil.sfOptionsForStart(), p);
            TimestampsRegionImpl region = (TimestampsRegionImpl)factory.buildTimestampsRegion("org.hibernate.cache.spi.UpdateTimestampsCache", p);
            Assert.fail((String)"Should have failed saying that invalidation is not allowed for timestamp caches.");
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{manager});
            throw throwable;
        }
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{manager});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBuildDefaultTimestampsRegion() {
        String timestamps = "org.hibernate.cache.spi.UpdateTimestampsCache";
        Properties p = InfinispanRegionFactoryTestCase.createProperties();
        TestInfinispanRegionFactory factory = this.createRegionFactory(p);
        try {
            Assert.assertTrue((boolean)this.isDefinedCache(factory, "timestamps"));
            TimestampsRegionImpl region = (TimestampsRegionImpl)factory.buildTimestampsRegion("org.hibernate.cache.spi.UpdateTimestampsCache", p);
            AdvancedCache cache = region.getCache();
            Assert.assertEquals((Object)"org.hibernate.cache.spi.UpdateTimestampsCache", (Object)cache.getName());
            Configuration cacheCfg = cache.getCacheConfiguration();
            Assert.assertEquals((Object)EvictionStrategy.NONE, (Object)cacheCfg.eviction().strategy());
            Assert.assertEquals((Object)CacheMode.REPL_ASYNC, (Object)cacheCfg.clustering().cacheMode());
            Assert.assertFalse((boolean)cacheCfg.jmxStatistics().enabled());
        }
        finally {
            factory.stop();
        }
    }

    protected boolean isDefinedCache(InfinispanRegionFactory factory, String cacheName) {
        return factory.getCacheManager().getCacheConfiguration(cacheName) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBuildDiffCacheNameTimestampsRegion() {
        String timestamps = "org.hibernate.cache.spi.UpdateTimestampsCache";
        String unrecommendedTimestamps = "unrecommended-timestamps";
        Properties p = InfinispanRegionFactoryTestCase.createProperties();
        p.setProperty(InfinispanRegionFactory.TIMESTAMPS_CACHE_RESOURCE_PROP, "unrecommended-timestamps");
        TestInfinispanRegionFactory factory = this.createRegionFactory(p, (f, m) -> {
            ConfigurationBuilder builder = new ConfigurationBuilder();
            builder.clustering().stateTransfer().fetchInMemoryState(true);
            builder.clustering().cacheMode(CacheMode.REPL_SYNC);
            m.defineConfiguration("unrecommended-timestamps", builder.build());
        });
        try {
            Assert.assertEquals((Object)"unrecommended-timestamps", (Object)factory.getBaseConfiguration(InfinispanRegionFactory.DataType.TIMESTAMPS));
            TimestampsRegionImpl region = (TimestampsRegionImpl)factory.buildTimestampsRegion("org.hibernate.cache.spi.UpdateTimestampsCache", p);
            AdvancedCache cache = region.getCache();
            Configuration cacheCfg = cache.getCacheConfiguration();
            Assert.assertEquals((Object)EvictionStrategy.NONE, (Object)cacheCfg.eviction().strategy());
            Assert.assertEquals((Object)CacheMode.REPL_SYNC, (Object)cacheCfg.clustering().cacheMode());
            Assert.assertFalse((boolean)cacheCfg.storeAsBinary().enabled());
            Assert.assertFalse((boolean)cacheCfg.jmxStatistics().enabled());
        }
        finally {
            factory.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBuildTimestampsRegionWithCacheNameOverride() {
        String timestamps = "org.hibernate.cache.spi.UpdateTimestampsCache";
        String myTimestampsCache = "mytimestamps-cache";
        Properties p = InfinispanRegionFactoryTestCase.createProperties();
        p.setProperty(InfinispanRegionFactory.TIMESTAMPS_CACHE_RESOURCE_PROP, "mytimestamps-cache");
        TestInfinispanRegionFactory factory = this.createRegionFactory(p, (f, m) -> {
            ClusteringConfigurationBuilder builder = new ConfigurationBuilder().clustering().cacheMode(CacheMode.LOCAL);
            m.defineConfiguration("mytimestamps-cache", builder.build());
        });
        try {
            TimestampsRegionImpl region = (TimestampsRegionImpl)factory.buildTimestampsRegion("org.hibernate.cache.spi.UpdateTimestampsCache", p);
            Assert.assertTrue((boolean)this.isDefinedCache(factory, "org.hibernate.cache.spi.UpdateTimestampsCache"));
            Assert.assertEquals((Object)CacheMode.LOCAL, (Object)region.getCache().getCacheConfiguration().clustering().cacheMode());
        }
        finally {
            factory.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=CacheException.class)
    public void testBuildTimestampsRegionWithFifoEvictionOverride() {
        String timestamps = "org.hibernate.cache.spi.UpdateTimestampsCache";
        String myTimestampsCache = "mytimestamps-cache";
        Properties p = InfinispanRegionFactoryTestCase.createProperties();
        p.setProperty(InfinispanRegionFactory.TIMESTAMPS_CACHE_RESOURCE_PROP, "mytimestamps-cache");
        p.setProperty("hibernate.cache.infinispan.timestamps.eviction.strategy", "FIFO");
        p.setProperty("hibernate.cache.infinispan.timestamps.eviction.max_entries", "10000");
        p.setProperty("hibernate.cache.infinispan.timestamps.expiration.wake_up_interval", "3000");
        TestInfinispanRegionFactory factory = null;
        try {
            factory = this.createRegionFactory(p);
            factory.buildTimestampsRegion("org.hibernate.cache.spi.UpdateTimestampsCache", p);
        }
        finally {
            if (factory != null) {
                factory.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBuildTimestampsRegionWithNoneEvictionOverride() {
        String timestamps = "org.hibernate.cache.spi.UpdateTimestampsCache";
        String timestampsNoEviction = "timestamps-no-eviction";
        Properties p = InfinispanRegionFactoryTestCase.createProperties();
        p.setProperty("hibernate.cache.infinispan.timestamps.cfg", "timestamps-no-eviction");
        p.setProperty("hibernate.cache.infinispan.timestamps.eviction.strategy", "NONE");
        p.setProperty("hibernate.cache.infinispan.timestamps.eviction.max_entries", "0");
        p.setProperty("hibernate.cache.infinispan.timestamps.expiration.wake_up_interval", "3000");
        TestInfinispanRegionFactory factory = this.createRegionFactory(p);
        try {
            TimestampsRegionImpl region = (TimestampsRegionImpl)factory.buildTimestampsRegion("org.hibernate.cache.spi.UpdateTimestampsCache", p);
            Assert.assertTrue((boolean)this.isDefinedCache(factory, "org.hibernate.cache.spi.UpdateTimestampsCache"));
            Assert.assertEquals((long)3000L, (long)region.getCache().getCacheConfiguration().expiration().wakeUpInterval());
        }
        finally {
            factory.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBuildQueryRegion() {
        String query = "org.hibernate.cache.internal.StandardQueryCache";
        Properties p = InfinispanRegionFactoryTestCase.createProperties();
        TestInfinispanRegionFactory factory = this.createRegionFactory(p);
        try {
            Assert.assertTrue((boolean)this.isDefinedCache(factory, "local-query"));
            QueryResultsRegionImpl region = (QueryResultsRegionImpl)factory.buildQueryResultsRegion("org.hibernate.cache.internal.StandardQueryCache", p);
            AdvancedCache cache = region.getCache();
            Configuration cacheCfg = cache.getCacheConfiguration();
            Assert.assertEquals((Object)CacheMode.LOCAL, (Object)cacheCfg.clustering().cacheMode());
            Assert.assertFalse((boolean)cacheCfg.jmxStatistics().enabled());
        }
        finally {
            factory.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBuildQueryRegionWithCustomRegionName() {
        String queryRegionName = "myquery";
        Properties p = InfinispanRegionFactoryTestCase.createProperties();
        p.setProperty("hibernate.cache.infinispan.myquery.cfg", "timestamps-none-eviction");
        p.setProperty("hibernate.cache.infinispan.myquery.eviction.strategy", "LIRS");
        p.setProperty("hibernate.cache.infinispan.myquery.expiration.wake_up_interval", "2222");
        p.setProperty("hibernate.cache.infinispan.myquery.eviction.max_entries", "11111");
        TestInfinispanRegionFactory factory = this.createRegionFactory(p);
        try {
            Assert.assertTrue((boolean)this.isDefinedCache(factory, "local-query"));
            QueryResultsRegionImpl region = (QueryResultsRegionImpl)factory.buildQueryResultsRegion("myquery", p);
            Assert.assertNotNull((Object)factory.getBaseConfiguration("myquery"));
            Assert.assertTrue((boolean)this.isDefinedCache(factory, "myquery"));
            AdvancedCache cache = region.getCache();
            Configuration cacheCfg = cache.getCacheConfiguration();
            Assert.assertEquals((Object)EvictionStrategy.LIRS, (Object)cacheCfg.eviction().strategy());
            Assert.assertEquals((long)2222L, (long)cacheCfg.expiration().wakeUpInterval());
            Assert.assertEquals((long)11111L, (long)cacheCfg.eviction().maxEntries());
        }
        finally {
            factory.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEnableStatistics() {
        Properties p = InfinispanRegionFactoryTestCase.createProperties();
        p.setProperty("hibernate.cache.infinispan.statistics", "true");
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.expiration.lifespan", "60000");
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.expiration.max_idle", "30000");
        p.setProperty("hibernate.cache.infinispan.entity.cfg", "myentity-cache");
        p.setProperty("hibernate.cache.infinispan.entity.eviction.strategy", "FIFO");
        p.setProperty("hibernate.cache.infinispan.entity.expiration.wake_up_interval", "3000");
        p.setProperty("hibernate.cache.infinispan.entity.eviction.max_entries", "10000");
        TestInfinispanRegionFactory factory = this.createRegionFactory(p);
        try {
            EmbeddedCacheManager manager = factory.getCacheManager();
            Assert.assertTrue((boolean)manager.getCacheManagerConfiguration().globalJmxStatistics().enabled());
            EntityRegionImpl region = (EntityRegionImpl)factory.buildEntityRegion("com.acme.Address", p, MUTABLE_NON_VERSIONED);
            AdvancedCache cache = region.getCache();
            Assert.assertTrue((boolean)cache.getCacheConfiguration().jmxStatistics().enabled());
            region = (EntityRegionImpl)factory.buildEntityRegion("com.acme.Person", p, MUTABLE_NON_VERSIONED);
            cache = region.getCache();
            Assert.assertTrue((boolean)cache.getCacheConfiguration().jmxStatistics().enabled());
            String query = "org.hibernate.cache.internal.StandardQueryCache";
            QueryResultsRegionImpl queryRegion = (QueryResultsRegionImpl)factory.buildQueryResultsRegion("org.hibernate.cache.internal.StandardQueryCache", p);
            cache = queryRegion.getCache();
            Assert.assertTrue((boolean)cache.getCacheConfiguration().jmxStatistics().enabled());
            String timestamps = "org.hibernate.cache.spi.UpdateTimestampsCache";
            TimestampsRegionImpl timestampsRegion = (TimestampsRegionImpl)factory.buildTimestampsRegion("org.hibernate.cache.spi.UpdateTimestampsCache", p);
            cache = timestampsRegion.getCache();
            Assert.assertTrue((boolean)cache.getCacheConfiguration().jmxStatistics().enabled());
            CollectionRegionImpl collectionRegion = (CollectionRegionImpl)factory.buildCollectionRegion("com.acme.Person.addresses", p, MUTABLE_NON_VERSIONED);
            cache = collectionRegion.getCache();
            Assert.assertTrue((boolean)cache.getCacheConfiguration().jmxStatistics().enabled());
        }
        finally {
            factory.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDisableStatistics() {
        Properties p = InfinispanRegionFactoryTestCase.createProperties();
        p.setProperty("hibernate.cache.infinispan.statistics", "false");
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.expiration.lifespan", "60000");
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.expiration.max_idle", "30000");
        p.setProperty("hibernate.cache.infinispan.entity.cfg", "myentity-cache");
        p.setProperty("hibernate.cache.infinispan.entity.eviction.strategy", "FIFO");
        p.setProperty("hibernate.cache.infinispan.entity.expiration.wake_up_interval", "3000");
        p.setProperty("hibernate.cache.infinispan.entity.eviction.max_entries", "10000");
        TestInfinispanRegionFactory factory = this.createRegionFactory(p);
        try {
            EntityRegionImpl region = (EntityRegionImpl)factory.buildEntityRegion("com.acme.Address", p, MUTABLE_NON_VERSIONED);
            AdvancedCache cache = region.getCache();
            Assert.assertFalse((boolean)cache.getCacheConfiguration().jmxStatistics().enabled());
            region = (EntityRegionImpl)factory.buildEntityRegion("com.acme.Person", p, MUTABLE_NON_VERSIONED);
            cache = region.getCache();
            Assert.assertFalse((boolean)cache.getCacheConfiguration().jmxStatistics().enabled());
            String query = "org.hibernate.cache.internal.StandardQueryCache";
            QueryResultsRegionImpl queryRegion = (QueryResultsRegionImpl)factory.buildQueryResultsRegion("org.hibernate.cache.internal.StandardQueryCache", p);
            cache = queryRegion.getCache();
            Assert.assertFalse((boolean)cache.getCacheConfiguration().jmxStatistics().enabled());
            String timestamps = "org.hibernate.cache.spi.UpdateTimestampsCache";
            TimestampsRegionImpl timestampsRegion = (TimestampsRegionImpl)factory.buildTimestampsRegion("org.hibernate.cache.spi.UpdateTimestampsCache", p);
            cache = timestampsRegion.getCache();
            Assert.assertFalse((boolean)cache.getCacheConfiguration().jmxStatistics().enabled());
            CollectionRegionImpl collectionRegion = (CollectionRegionImpl)factory.buildCollectionRegion("com.acme.Person.addresses", p, MUTABLE_NON_VERSIONED);
            cache = collectionRegion.getCache();
            Assert.assertFalse((boolean)cache.getCacheConfiguration().jmxStatistics().enabled());
        }
        finally {
            factory.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDefaultPendingPutsCache() {
        Properties p = InfinispanRegionFactoryTestCase.createProperties();
        TestInfinispanRegionFactory factory = this.createRegionFactory(p);
        try {
            Configuration ppConfig = factory.getCacheManager().getCacheConfiguration("pending-puts");
            Assert.assertTrue((boolean)ppConfig.isTemplate());
            Assert.assertFalse((boolean)ppConfig.clustering().cacheMode().isClustered());
            Assert.assertTrue((boolean)ppConfig.simpleCache());
            Assert.assertEquals((Object)TransactionMode.NON_TRANSACTIONAL, (Object)ppConfig.transaction().transactionMode());
            Assert.assertEquals((long)60000L, (long)ppConfig.expiration().maxIdle());
            Assert.assertFalse((boolean)ppConfig.jmxStatistics().enabled());
            Assert.assertFalse((boolean)ppConfig.jmxStatistics().available());
        }
        finally {
            factory.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCustomPendingPutsCache() {
        Properties p = InfinispanRegionFactoryTestCase.createProperties();
        p.setProperty("hibernate.cache.infinispan.cfg", "alternative-infinispan-configs.xml");
        TestInfinispanRegionFactory factory = this.createRegionFactory(p);
        try {
            Configuration ppConfig = factory.getCacheManager().getCacheConfiguration("pending-puts");
            Assert.assertEquals((long)120000L, (long)ppConfig.expiration().maxIdle());
        }
        finally {
            factory.stop();
        }
    }

    private TestInfinispanRegionFactory createRegionFactory(Properties p) {
        return this.createRegionFactory(null, p, null);
    }

    private TestInfinispanRegionFactory createRegionFactory(Properties p, BiConsumer<TestInfinispanRegionFactory, EmbeddedCacheManager> hook) {
        return this.createRegionFactory(null, p, hook);
    }

    private TestInfinispanRegionFactory createRegionFactory(EmbeddedCacheManager manager, Properties p, BiConsumer<TestInfinispanRegionFactory, EmbeddedCacheManager> hook) {
        TestInfinispanRegionFactory factory = new TestInfinispanRegionFactory(manager, hook);
        factory.start(CacheTestUtil.sfOptionsForStart(), p);
        return factory;
    }

    private static Properties createProperties() {
        Properties properties = new Properties();
        String cfgFileName = (String)Environment.getProperties().get("hibernate.cache.infinispan.cfg");
        if (cfgFileName != null) {
            properties.put("hibernate.cache.infinispan.cfg", cfgFileName);
        }
        return properties;
    }

    private static class TestInfinispanRegionFactory
    extends org.infinispan.test.hibernate.cache.util.TestInfinispanRegionFactory {
        private final EmbeddedCacheManager providedManager;
        private final BiConsumer<TestInfinispanRegionFactory, EmbeddedCacheManager> afterCacheManagerCreated;

        public TestInfinispanRegionFactory(EmbeddedCacheManager providedManager, BiConsumer<TestInfinispanRegionFactory, EmbeddedCacheManager> afterCacheManagerCreated) {
            super(new Properties());
            this.providedManager = providedManager;
            this.afterCacheManagerCreated = afterCacheManagerCreated;
        }

        protected TransactionManagerLookup createTransactionManagerLookup(SessionFactoryOptions settings, Properties properties) {
            return new HibernateTransactionManagerLookup(null, null){

                public TransactionManager getTransactionManager() throws Exception {
                    JBossStandAloneJtaPlatform jta = new JBossStandAloneJtaPlatform();
                    jta.injectServices((ServiceRegistryImplementor)ServiceRegistryBuilder.buildServiceRegistry());
                    return jta.getTransactionManager();
                }
            };
        }

        protected EmbeddedCacheManager createCacheManager(Properties properties, ServiceRegistry serviceRegistry) throws CacheException {
            EmbeddedCacheManager m = this.providedManager != null ? this.providedManager : super.createCacheManager(properties, serviceRegistry);
            if (this.afterCacheManagerCreated != null) {
                this.afterCacheManagerCreated.accept(this, m);
            }
            return m;
        }

        public String getBaseConfiguration(String regionName) {
            return (String)this.baseConfigurations.get(regionName);
        }

        public String getBaseConfiguration(InfinispanRegionFactory.DataType dataType) {
            return (String)this.baseConfigurations.get(dataType.key);
        }

        public Configuration getConfigurationOverride(String regionName) {
            return ((ConfigurationBuilder)this.configOverrides.get(regionName)).build(false);
        }

        public Configuration getConfigurationOverride(InfinispanRegionFactory.DataType dataType) {
            return ((ConfigurationBuilder)this.configOverrides.get(dataType.key)).build(false);
        }
    }
}

