/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.hibernate.cache.access;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.transaction.TransactionManager;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.testing.AfterClassOnce;
import org.hibernate.testing.BeforeClassOnce;
import org.hibernate.testing.TestForIssue;
import org.hibernate.testing.junit4.CustomRunner;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.hibernate.cache.InfinispanRegionFactory;
import org.infinispan.hibernate.cache.access.PutFromLoadValidator;
import org.infinispan.hibernate.cache.util.InfinispanMessageLogger;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.Exceptions;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.TestResourceTracker;
import org.infinispan.test.hibernate.cache.functional.cluster.DualNodeJtaTransactionManagerImpl;
import org.infinispan.test.hibernate.cache.util.CacheTestUtil;
import org.infinispan.test.hibernate.cache.util.TestInfinispanRegionFactory;
import org.infinispan.test.hibernate.cache.util.TestTimeService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;

@RunWith(value=CustomRunner.class)
public class PutFromLoadValidatorUnitTest {
    private static final InfinispanMessageLogger log = InfinispanMessageLogger.Provider.getLog(PutFromLoadValidatorUnitTest.class);
    private static final TestTimeService TIME_SERVICE = new TestTimeService();
    private Object KEY1 = "KEY1";
    private TransactionManager tm;
    private EmbeddedCacheManager cm;
    private AdvancedCache<Object, Object> cache;
    private List<Runnable> cleanup = new ArrayList<Runnable>();
    private PutFromLoadValidator testee;

    @BeforeClassOnce
    public void setUp() throws Exception {
        TestResourceTracker.testStarted((String)this.getClass().getSimpleName());
        this.tm = DualNodeJtaTransactionManagerImpl.getInstance("test");
        this.cm = TestCacheManagerFactory.createCacheManager((boolean)true);
        this.cache = this.cm.getCache().getAdvancedCache();
    }

    @AfterClassOnce
    public void stop() {
        this.tm = null;
        this.cm.stop();
        TestResourceTracker.testFinished((String)this.getClass().getSimpleName());
    }

    @After
    public void tearDown() throws Exception {
        this.cleanup.forEach(Runnable::run);
        this.cleanup.clear();
        try {
            DualNodeJtaTransactionManagerImpl.cleanupTransactions();
        }
        finally {
            DualNodeJtaTransactionManagerImpl.cleanupTransactionManagers();
        }
        this.cache.clear();
        this.cm.getCache(this.cache.getName() + "-" + "pending-puts").clear();
        this.testee.removePendingPutsCache();
    }

    private static InfinispanRegionFactory regionFactory(EmbeddedCacheManager cm) {
        Properties properties = new Properties();
        properties.put(TestInfinispanRegionFactory.TIME_SERVICE, (Object)TIME_SERVICE);
        TestInfinispanRegionFactory regionFactory = new TestInfinispanRegionFactory(properties);
        regionFactory.setCacheManager(cm);
        regionFactory.start(CacheTestUtil.sfOptionsForStart(), properties);
        return regionFactory;
    }

    @Test
    public void testNakedPut() throws Exception {
        this.nakedPutTest(false);
    }

    @Test
    public void testNakedPutTransactional() throws Exception {
        this.nakedPutTest(true);
    }

    private void nakedPutTest(boolean transactional) throws Exception {
        this.testee = new PutFromLoadValidator(this.cache, PutFromLoadValidatorUnitTest.regionFactory(this.cm));
        this.exec(transactional, new NakedPut(this.testee, true));
    }

    @Test
    public void testRegisteredPut() throws Exception {
        this.registeredPutTest(false);
    }

    @Test
    public void testRegisteredPutTransactional() throws Exception {
        this.registeredPutTest(true);
    }

    private void registeredPutTest(boolean transactional) throws Exception {
        this.testee = new PutFromLoadValidator(this.cache, PutFromLoadValidatorUnitTest.regionFactory(this.cm));
        this.exec(transactional, new RegularPut(this.testee));
    }

    @Test
    public void testNakedPutAfterKeyRemoval() throws Exception {
        this.nakedPutAfterRemovalTest(false, false);
    }

    @Test
    public void testNakedPutAfterKeyRemovalTransactional() throws Exception {
        this.nakedPutAfterRemovalTest(true, false);
    }

    @Test
    public void testNakedPutAfterRegionRemoval() throws Exception {
        this.nakedPutAfterRemovalTest(false, true);
    }

    @Test
    public void testNakedPutAfterRegionRemovalTransactional() throws Exception {
        this.nakedPutAfterRemovalTest(true, true);
    }

    private void nakedPutAfterRemovalTest(boolean transactional, boolean removeRegion) throws Exception {
        this.testee = new PutFromLoadValidator(this.cache, PutFromLoadValidatorUnitTest.regionFactory(this.cm));
        Invalidation invalidation = new Invalidation(this.testee, removeRegion);
        NakedPut nakedPut = new NakedPut(this.testee, true);
        this.exec(transactional, invalidation, nakedPut);
    }

    @Test
    public void testRegisteredPutAfterKeyRemoval() throws Exception {
        this.registeredPutAfterRemovalTest(false, false);
    }

    @Test
    public void testRegisteredPutAfterKeyRemovalTransactional() throws Exception {
        this.registeredPutAfterRemovalTest(true, false);
    }

    @Test
    public void testRegisteredPutAfterRegionRemoval() throws Exception {
        this.registeredPutAfterRemovalTest(false, true);
    }

    @Test
    public void testRegisteredPutAfterRegionRemovalTransactional() throws Exception {
        this.registeredPutAfterRemovalTest(true, true);
    }

    private void registeredPutAfterRemovalTest(boolean transactional, boolean removeRegion) throws Exception {
        this.testee = new PutFromLoadValidator(this.cache, PutFromLoadValidatorUnitTest.regionFactory(this.cm));
        Invalidation invalidation = new Invalidation(this.testee, removeRegion);
        RegularPut regularPut = new RegularPut(this.testee);
        this.exec(transactional, invalidation, regularPut);
    }

    @Test
    public void testRegisteredPutWithInterveningKeyRemoval() throws Exception {
        this.registeredPutWithInterveningRemovalTest(false, false);
    }

    @Test
    public void testRegisteredPutWithInterveningKeyRemovalTransactional() throws Exception {
        this.registeredPutWithInterveningRemovalTest(true, false);
    }

    @Test
    public void testRegisteredPutWithInterveningRegionRemoval() throws Exception {
        this.registeredPutWithInterveningRemovalTest(false, true);
    }

    @Test
    public void testRegisteredPutWithInterveningRegionRemovalTransactional() throws Exception {
        this.registeredPutWithInterveningRemovalTest(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registeredPutWithInterveningRemovalTest(boolean transactional, boolean removeRegion) throws Exception {
        this.testee = new PutFromLoadValidator(this.cache, PutFromLoadValidatorUnitTest.regionFactory(this.cm));
        try {
            long txTimestamp = TIME_SERVICE.wallClockTime();
            if (transactional) {
                this.tm.begin();
            }
            SharedSessionContractImplementor session1 = (SharedSessionContractImplementor)Mockito.mock(SharedSessionContractImplementor.class);
            SharedSessionContractImplementor session2 = (SharedSessionContractImplementor)Mockito.mock(SharedSessionContractImplementor.class);
            this.testee.registerPendingPut(session1, this.KEY1, txTimestamp);
            if (removeRegion) {
                this.testee.beginInvalidatingRegion();
            } else {
                this.testee.beginInvalidatingKey((Object)session2, this.KEY1);
            }
            PutFromLoadValidator.Lock lock = this.testee.acquirePutFromLoadLock(session1, this.KEY1, txTimestamp);
            try {
                Assert.assertNull((Object)lock);
            }
            finally {
                if (lock != null) {
                    this.testee.releasePutFromLoadLock(this.KEY1, lock);
                }
                if (removeRegion) {
                    this.testee.endInvalidatingRegion();
                } else {
                    this.testee.endInvalidatingKey((Object)session2, this.KEY1);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testMultipleRegistrations() throws Exception {
        this.multipleRegistrationtest(false);
    }

    @Test
    public void testMultipleRegistrationsTransactional() throws Exception {
        this.multipleRegistrationtest(true);
    }

    private void multipleRegistrationtest(boolean transactional) throws Exception {
        this.testee = new PutFromLoadValidator(this.cache, PutFromLoadValidatorUnitTest.regionFactory(this.cm));
        CountDownLatch registeredLatch = new CountDownLatch(3);
        CountDownLatch finishedLatch = new CountDownLatch(3);
        AtomicInteger success = new AtomicInteger();
        Runnable r = () -> {
            try {
                long txTimestamp = TIME_SERVICE.wallClockTime();
                if (transactional) {
                    this.tm.begin();
                }
                SharedSessionContractImplementor session = (SharedSessionContractImplementor)Mockito.mock(SharedSessionContractImplementor.class);
                this.testee.registerPendingPut(session, this.KEY1, txTimestamp);
                registeredLatch.countDown();
                registeredLatch.await(5L, TimeUnit.SECONDS);
                PutFromLoadValidator.Lock lock = this.testee.acquirePutFromLoadLock(session, this.KEY1, txTimestamp);
                if (lock != null) {
                    try {
                        log.trace((Object)("Put from load lock acquired for key = " + this.KEY1));
                        success.incrementAndGet();
                    }
                    finally {
                        this.testee.releasePutFromLoadLock(this.KEY1, lock);
                    }
                } else {
                    log.trace((Object)("Unable to acquired putFromLoad lock for key = " + this.KEY1));
                }
                finishedLatch.countDown();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        };
        ExecutorService executor = Executors.newFixedThreadPool(3);
        this.cleanup.add(() -> executor.shutdownNow());
        this.testee.beginInvalidatingRegion();
        this.testee.endInvalidatingRegion();
        TIME_SERVICE.advance(1L);
        executor.execute(r);
        executor.execute(r);
        executor.execute(r);
        Assert.assertTrue((boolean)finishedLatch.await(5L, TimeUnit.SECONDS));
        Assert.assertEquals((String)"All threads succeeded", (long)3L, (long)success.get());
    }

    @Test
    public void testInvalidateKeyBlocksForInProgressPut() throws Exception {
        this.invalidationBlocksForInProgressPutTest(true);
    }

    @Test
    public void testInvalidateRegionBlocksForInProgressPut() throws Exception {
        this.invalidationBlocksForInProgressPutTest(false);
    }

    private void invalidationBlocksForInProgressPutTest(boolean keyOnly) throws Exception {
        this.testee = new PutFromLoadValidator(this.cache, PutFromLoadValidatorUnitTest.regionFactory(this.cm));
        CountDownLatch removeLatch = new CountDownLatch(1);
        CountDownLatch pferLatch = new CountDownLatch(1);
        AtomicReference<String> cache = new AtomicReference<String>("INITIAL");
        Callable<Boolean> pferCallable = () -> {
            long txTimestamp = TIME_SERVICE.wallClockTime();
            SharedSessionContractImplementor session = (SharedSessionContractImplementor)Mockito.mock(SharedSessionContractImplementor.class);
            this.testee.registerPendingPut(session, this.KEY1, txTimestamp);
            PutFromLoadValidator.Lock lock = this.testee.acquirePutFromLoadLock(session, this.KEY1, txTimestamp);
            if (lock != null) {
                try {
                    removeLatch.countDown();
                    pferLatch.await();
                    cache.set("PFER");
                    Boolean bl = Boolean.TRUE;
                    return bl;
                }
                finally {
                    this.testee.releasePutFromLoadLock(this.KEY1, lock);
                }
            }
            return Boolean.FALSE;
        };
        Callable<Void> invalidateCallable = () -> {
            removeLatch.await();
            if (keyOnly) {
                SharedSessionContractImplementor session = (SharedSessionContractImplementor)Mockito.mock(SharedSessionContractImplementor.class);
                this.testee.beginInvalidatingKey((Object)session, this.KEY1);
            } else {
                this.testee.beginInvalidatingRegion();
            }
            cache.set(null);
            return null;
        };
        ExecutorService executor = Executors.newCachedThreadPool();
        this.cleanup.add(() -> executor.shutdownNow());
        Future<Boolean> pferFuture = executor.submit(pferCallable);
        Future<Void> invalidateFuture = executor.submit(invalidateCallable);
        Exceptions.expectException(TimeoutException.class, () -> {
            Void cfr_ignored_0 = (Void)invalidateFuture.get(1L, TimeUnit.SECONDS);
        });
        pferLatch.countDown();
        Assert.assertTrue((boolean)pferFuture.get(5L, TimeUnit.SECONDS));
        invalidateFuture.get(5L, TimeUnit.SECONDS);
        Assert.assertNull((Object)cache.get());
    }

    protected void exec(boolean transactional, Callable<?> ... callables) {
        try {
            if (transactional) {
                for (Callable<?> c : callables) {
                    TestingUtil.withTx((TransactionManager)this.tm, c);
                }
            } else {
                for (Callable<?> c : callables) {
                    c.call();
                }
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    @TestForIssue(jiraKey="HHH-9928")
    public void testGetForNullReleasePuts() {
        int size;
        ConfigurationBuilder cb = new ConfigurationBuilder();
        cb.simpleCache(true).expiration().maxIdle(500L);
        Configuration ppCfg = cb.build();
        InfinispanRegionFactory regionFactory = (InfinispanRegionFactory)Mockito.mock(InfinispanRegionFactory.class);
        ((InfinispanRegionFactory)Mockito.doReturn((Object)ppCfg).when((Object)regionFactory)).getPendingPutsCacheConfiguration();
        ((InfinispanRegionFactory)Mockito.doAnswer(invocation -> TIME_SERVICE.wallClockTime()).when((Object)regionFactory)).nextTimestamp();
        this.testee = new PutFromLoadValidator(this.cache, regionFactory, this.cm);
        for (int i = 0; i < 100; ++i) {
            try {
                TestingUtil.withTx((TransactionManager)this.tm, () -> {
                    SharedSessionContractImplementor session = (SharedSessionContractImplementor)Mockito.mock(SharedSessionContractImplementor.class);
                    this.testee.registerPendingPut(session, this.KEY1, 0L);
                    return null;
                });
                TIME_SERVICE.advance(10L);
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        String ppName = this.cm.getCache().getName() + "-" + "pending-puts";
        Cache ppCache = this.cm.getCache(ppName, false);
        Assert.assertNotNull((Object)ppCache);
        Object pendingPutMap = ppCache.get(this.KEY1);
        Assert.assertNotNull(pendingPutMap);
        try {
            Method sizeMethod = pendingPutMap.getClass().getMethod("size", new Class[0]);
            sizeMethod.setAccessible(true);
            size = (Integer)sizeMethod.invoke(pendingPutMap, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Assert.assertTrue((size < 100 ? 1 : 0) != 0);
        Assert.assertTrue((size > 0 ? 1 : 0) != 0);
    }

    private class NakedPut
    implements Callable<Void> {
        private final PutFromLoadValidator testee;
        private final boolean expectSuccess;

        public NakedPut(PutFromLoadValidator testee, boolean expectSuccess) {
            this.testee = testee;
            this.expectSuccess = expectSuccess;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            try {
                long txTimestamp = TIME_SERVICE.wallClockTime();
                SharedSessionContractImplementor session = (SharedSessionContractImplementor)Mockito.mock(SharedSessionContractImplementor.class);
                PutFromLoadValidator.Lock lock = this.testee.acquirePutFromLoadLock(session, PutFromLoadValidatorUnitTest.this.KEY1, txTimestamp);
                try {
                    if (this.expectSuccess) {
                        Assert.assertNotNull((Object)lock);
                    } else {
                        Assert.assertNull((Object)lock);
                    }
                }
                finally {
                    if (lock != null) {
                        this.testee.releasePutFromLoadLock(PutFromLoadValidatorUnitTest.this.KEY1, lock);
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return null;
        }
    }

    private class RegularPut
    implements Callable<Void> {
        private PutFromLoadValidator putFromLoadValidator;

        public RegularPut(PutFromLoadValidator putFromLoadValidator) {
            this.putFromLoadValidator = putFromLoadValidator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            try {
                long txTimestamp = TIME_SERVICE.wallClockTime();
                SharedSessionContractImplementor session = (SharedSessionContractImplementor)Mockito.mock(SharedSessionContractImplementor.class);
                this.putFromLoadValidator.registerPendingPut(session, PutFromLoadValidatorUnitTest.this.KEY1, txTimestamp);
                PutFromLoadValidator.Lock lock = this.putFromLoadValidator.acquirePutFromLoadLock(session, PutFromLoadValidatorUnitTest.this.KEY1, txTimestamp);
                try {
                    Assert.assertNotNull((Object)lock);
                }
                finally {
                    if (lock != null) {
                        this.putFromLoadValidator.releasePutFromLoadLock(PutFromLoadValidatorUnitTest.this.KEY1, lock);
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return null;
        }
    }

    private class Invalidation
    implements Callable<Void> {
        private PutFromLoadValidator putFromLoadValidator;
        private boolean removeRegion;

        public Invalidation(PutFromLoadValidator putFromLoadValidator, boolean removeRegion) {
            this.putFromLoadValidator = putFromLoadValidator;
            this.removeRegion = removeRegion;
        }

        @Override
        public Void call() throws Exception {
            if (this.removeRegion) {
                boolean success = this.putFromLoadValidator.beginInvalidatingRegion();
                Assert.assertTrue((boolean)success);
                this.putFromLoadValidator.endInvalidatingRegion();
            } else {
                SharedSessionContractImplementor session = (SharedSessionContractImplementor)Mockito.mock(SharedSessionContractImplementor.class);
                boolean success = this.putFromLoadValidator.beginInvalidatingKey((Object)session, PutFromLoadValidatorUnitTest.this.KEY1);
                Assert.assertTrue((boolean)success);
                success = this.putFromLoadValidator.endInvalidatingKey((Object)session, PutFromLoadValidatorUnitTest.this.KEY1);
                Assert.assertTrue((boolean)success);
            }
            TIME_SERVICE.advance(1L);
            return null;
        }
    }
}

