/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.hibernate.cache.entity;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import junit.framework.AssertionFailedError;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cache.spi.access.EntityRegionAccessStrategy;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.infinispan.hibernate.cache.entity.EntityRegionImpl;
import org.infinispan.test.hibernate.cache.AbstractRegionAccessStrategyTest;
import org.infinispan.test.hibernate.cache.NodeEnvironment;
import org.infinispan.test.hibernate.cache.util.TestSynchronization;
import org.infinispan.test.hibernate.cache.util.TestingKeyFactory;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class EntityRegionAccessStrategyTest
extends AbstractRegionAccessStrategyTest<EntityRegionImpl, EntityRegionAccessStrategy> {
    protected static int testCount;

    @Override
    protected Object generateNextKey() {
        return TestingKeyFactory.generateEntityCacheKey("KEY" + testCount++);
    }

    @Override
    protected EntityRegionImpl getRegion(NodeEnvironment environment) {
        return environment.getEntityRegion("test/com.foo.test", CACHE_DATA_DESCRIPTION);
    }

    @Override
    protected EntityRegionAccessStrategy getAccessStrategy(EntityRegionImpl region) {
        return region.buildAccessStrategy(this.accessType);
    }

    @Test
    public void testGetRegion() {
        Assert.assertEquals((String)"Correct region", (Object)this.localRegion, (Object)((EntityRegionAccessStrategy)this.localAccessStrategy).getRegion());
    }

    @Test
    public void testPutFromLoad() throws Exception {
        if (this.accessType == AccessType.READ_ONLY) {
            this.putFromLoadTestReadOnly(false);
        } else {
            this.putFromLoadTest(false, false);
        }
    }

    @Test
    public void testPutFromLoadMinimal() throws Exception {
        if (this.accessType == AccessType.READ_ONLY) {
            this.putFromLoadTestReadOnly(true);
        } else {
            this.putFromLoadTest(true, false);
        }
    }

    @Test
    public void testInsert() throws Exception {
        Object KEY = this.generateNextKey();
        CountDownLatch readLatch = new CountDownLatch(1);
        CountDownLatch commitLatch = new CountDownLatch(1);
        CountDownLatch completionLatch = new CountDownLatch(2);
        CountDownLatch asyncInsertLatch = this.expectAfterUpdate();
        Thread inserter = new Thread(() -> {
            try {
                SharedSessionContractImplementor session = this.mockedSession();
                this.withTx(this.localEnvironment, session, () -> {
                    Assert.assertNull((String)"Correct initial value", (Object)((EntityRegionAccessStrategy)this.localAccessStrategy).get(session, KEY, session.getTimestamp()));
                    this.doInsert((EntityRegionAccessStrategy)this.localAccessStrategy, session, KEY, "VALUE1", 1);
                    readLatch.countDown();
                    commitLatch.await();
                    return null;
                });
            }
            catch (Exception e) {
                this.log.error((Object)"node1 caught exception", (Throwable)e);
                this.node1Exception = e;
            }
            catch (AssertionFailedError e) {
                this.node1Failure = e;
            }
            finally {
                completionLatch.countDown();
            }
        }, "testInsert-inserter");
        Thread reader = new Thread(() -> {
            try {
                SharedSessionContractImplementor session = this.mockedSession();
                this.withTx(this.localEnvironment, session, () -> {
                    readLatch.await();
                    Assert.assertNull((String)"Correct initial value", (Object)((EntityRegionAccessStrategy)this.localAccessStrategy).get(session, KEY, session.getTimestamp()));
                    return null;
                });
            }
            catch (Exception e) {
                this.log.error((Object)"node1 caught exception", (Throwable)e);
                this.node1Exception = e;
            }
            catch (AssertionFailedError e) {
                this.node1Failure = e;
            }
            finally {
                commitLatch.countDown();
                completionLatch.countDown();
            }
        }, "testInsert-reader");
        inserter.setDaemon(true);
        reader.setDaemon(true);
        inserter.start();
        reader.start();
        Assert.assertTrue((String)"Threads completed", (boolean)completionLatch.await(10L, TimeUnit.SECONDS));
        this.assertThreadsRanCleanly();
        SharedSessionContractImplementor s1 = this.mockedSession();
        Assert.assertEquals((String)"Correct node1 value", (Object)"VALUE1", (Object)((EntityRegionAccessStrategy)this.localAccessStrategy).get(s1, KEY, s1.getTimestamp()));
        Assert.assertTrue((boolean)asyncInsertLatch.await(10L, TimeUnit.SECONDS));
        String expected = this.isUsingInvalidation() ? null : "VALUE1";
        SharedSessionContractImplementor s2 = this.mockedSession();
        Assert.assertEquals((String)"Correct node2 value", (Object)expected, (Object)((EntityRegionAccessStrategy)this.remoteAccessStrategy).get(s2, KEY, s2.getTimestamp()));
    }

    protected void doInsert(EntityRegionAccessStrategy strategy, SharedSessionContractImplementor session, Object key, String value, Object version) {
        strategy.insert(session, key, (Object)value, null);
        session.getTransactionCoordinator().getLocalSynchronizations().registerSynchronization((Synchronization)new TestSynchronization.AfterInsert(strategy, session, key, value, version));
    }

    protected void putFromLoadTestReadOnly(boolean minimal) throws Exception {
        String expected;
        Object KEY = TestingKeyFactory.generateEntityCacheKey("KEY" + testCount++);
        CountDownLatch remotePutFromLoadLatch = this.expectPutFromLoad();
        SharedSessionContractImplementor session = this.mockedSession();
        this.withTx(this.localEnvironment, session, () -> {
            Assert.assertNull((Object)((EntityRegionAccessStrategy)this.localAccessStrategy).get(session, KEY, session.getTimestamp()));
            if (minimal) {
                ((EntityRegionAccessStrategy)this.localAccessStrategy).putFromLoad(session, KEY, (Object)"VALUE1", session.getTimestamp(), (Object)1, true);
            } else {
                ((EntityRegionAccessStrategy)this.localAccessStrategy).putFromLoad(session, KEY, (Object)"VALUE1", session.getTimestamp(), (Object)1);
            }
            return null;
        });
        SharedSessionContractImplementor s2 = this.mockedSession();
        Assert.assertEquals((Object)"VALUE1", (Object)((EntityRegionAccessStrategy)this.localAccessStrategy).get(s2, KEY, s2.getTimestamp()));
        SharedSessionContractImplementor s3 = this.mockedSession();
        if (this.isUsingInvalidation()) {
            expected = null;
        } else {
            if (this.accessType != AccessType.NONSTRICT_READ_WRITE) {
                Assert.assertTrue((boolean)remotePutFromLoadLatch.await(2L, TimeUnit.SECONDS));
            }
            expected = "VALUE1";
        }
        Assert.assertEquals((Object)expected, (Object)((EntityRegionAccessStrategy)this.remoteAccessStrategy).get(s3, KEY, s3.getTimestamp()));
    }

    @Test
    public void testUpdate() throws Exception {
        if (this.accessType == AccessType.READ_ONLY) {
            return;
        }
        Object KEY = this.generateNextKey();
        SharedSessionContractImplementor s1 = this.mockedSession();
        ((EntityRegionAccessStrategy)this.localAccessStrategy).putFromLoad(s1, KEY, (Object)"VALUE1", s1.getTimestamp(), (Object)1);
        SharedSessionContractImplementor s2 = this.mockedSession();
        ((EntityRegionAccessStrategy)this.remoteAccessStrategy).putFromLoad(s2, KEY, (Object)"VALUE1", s2.getTimestamp(), (Object)1);
        CountDownLatch asyncUpdateLatch = this.expectAfterUpdate();
        CountDownLatch readLatch = new CountDownLatch(1);
        CountDownLatch commitLatch = new CountDownLatch(1);
        CountDownLatch completionLatch = new CountDownLatch(2);
        Thread updater = new Thread(() -> {
            try {
                SharedSessionContractImplementor session = this.mockedSession();
                this.withTx(this.localEnvironment, session, () -> {
                    this.log.debug((Object)"Transaction began, get initial value");
                    Assert.assertEquals((String)"Correct initial value", (Object)"VALUE1", (Object)((EntityRegionAccessStrategy)this.localAccessStrategy).get(session, KEY, session.getTimestamp()));
                    this.log.debug((Object)"Now update value");
                    this.doUpdate((EntityRegionAccessStrategy)this.localAccessStrategy, session, KEY, (Object)"VALUE2", (Object)2);
                    this.log.debug((Object)"Notify the read latch");
                    readLatch.countDown();
                    this.log.debug((Object)"Await commit");
                    commitLatch.await();
                    return null;
                });
            }
            catch (Exception e) {
                this.log.error((Object)"node1 caught exception", (Throwable)e);
                this.node1Exception = e;
            }
            catch (AssertionFailedError e) {
                this.node1Failure = e;
            }
            finally {
                if (readLatch.getCount() > 0L) {
                    readLatch.countDown();
                }
                this.log.debug((Object)"Completion latch countdown");
                completionLatch.countDown();
            }
        }, "testUpdate-updater");
        Thread reader = new Thread(() -> {
            try {
                SharedSessionContractImplementor session = this.mockedSession();
                this.withTx(this.localEnvironment, session, () -> {
                    this.log.debug((Object)"Transaction began, await read latch");
                    readLatch.await();
                    this.log.debug((Object)"Read latch acquired, verify local access strategy");
                    String expected = this.isTransactional() || this.accessType == AccessType.NONSTRICT_READ_WRITE ? "VALUE1" : null;
                    Assert.assertEquals((String)"Correct value", (Object)expected, (Object)((EntityRegionAccessStrategy)this.localAccessStrategy).get(session, KEY, session.getTimestamp()));
                    return null;
                });
            }
            catch (Exception e) {
                this.log.error((Object)"node1 caught exception", (Throwable)e);
                this.node1Exception = e;
            }
            catch (AssertionFailedError e) {
                this.node1Failure = e;
            }
            finally {
                commitLatch.countDown();
                this.log.debug((Object)"Completion latch countdown");
                completionLatch.countDown();
            }
        }, "testUpdate-reader");
        updater.setDaemon(true);
        reader.setDaemon(true);
        updater.start();
        reader.start();
        Assert.assertTrue((boolean)completionLatch.await(2L, TimeUnit.SECONDS));
        this.assertThreadsRanCleanly();
        SharedSessionContractImplementor s3 = this.mockedSession();
        Assert.assertEquals((String)"Correct node1 value", (Object)"VALUE2", (Object)((EntityRegionAccessStrategy)this.localAccessStrategy).get(s3, KEY, s3.getTimestamp()));
        Assert.assertTrue((boolean)asyncUpdateLatch.await(10L, TimeUnit.SECONDS));
        String expected = this.isUsingInvalidation() ? null : "VALUE2";
        SharedSessionContractImplementor s4 = this.mockedSession();
        Assert.assertEquals((String)"Correct node2 value", (Object)expected, (Object)((EntityRegionAccessStrategy)this.remoteAccessStrategy).get(s4, KEY, s4.getTimestamp()));
    }

    @Override
    protected void doUpdate(EntityRegionAccessStrategy strategy, SharedSessionContractImplementor session, Object key, Object value, Object version) throws RollbackException, SystemException {
        SoftLock softLock = strategy.lockItem(session, key, null);
        strategy.update(session, key, value, null, null);
        session.getTransactionCoordinator().getLocalSynchronizations().registerSynchronization((Synchronization)new TestSynchronization.AfterUpdate(strategy, session, key, value, version, softLock));
    }

    @Ignore
    @Test
    public void testContestedPutFromLoad() throws Exception {
        if (this.accessType == AccessType.READ_ONLY) {
            return;
        }
        final Object KEY = TestingKeyFactory.generateEntityCacheKey("KEY" + testCount++);
        SharedSessionContractImplementor s1 = this.mockedSession();
        ((EntityRegionAccessStrategy)this.localAccessStrategy).putFromLoad(s1, KEY, (Object)"VALUE1", s1.getTimestamp(), (Object)1);
        final CountDownLatch pferLatch = new CountDownLatch(1);
        final CountDownLatch pferCompletionLatch = new CountDownLatch(1);
        final CountDownLatch commitLatch = new CountDownLatch(1);
        final CountDownLatch completionLatch = new CountDownLatch(1);
        Thread blocker = new Thread("Blocker"){

            @Override
            public void run() {
                try {
                    SharedSessionContractImplementor session = EntityRegionAccessStrategyTest.this.mockedSession();
                    EntityRegionAccessStrategyTest.this.withTx(EntityRegionAccessStrategyTest.this.localEnvironment, session, () -> {
                        Assert.assertEquals((String)"Correct initial value", (Object)"VALUE1", (Object)((EntityRegionAccessStrategy)EntityRegionAccessStrategyTest.this.localAccessStrategy).get(session, KEY, session.getTimestamp()));
                        EntityRegionAccessStrategyTest.this.doUpdate((EntityRegionAccessStrategy)EntityRegionAccessStrategyTest.this.localAccessStrategy, session, KEY, (Object)"VALUE2", (Object)2);
                        pferLatch.countDown();
                        commitLatch.await();
                        return null;
                    });
                }
                catch (Exception e) {
                    EntityRegionAccessStrategyTest.this.log.error((Object)"node1 caught exception", (Throwable)e);
                    EntityRegionAccessStrategyTest.this.node1Exception = e;
                }
                catch (AssertionFailedError e) {
                    EntityRegionAccessStrategyTest.this.node1Failure = e;
                }
                finally {
                    completionLatch.countDown();
                }
            }
        };
        Thread putter = new Thread("Putter"){

            @Override
            public void run() {
                try {
                    SharedSessionContractImplementor session = EntityRegionAccessStrategyTest.this.mockedSession();
                    EntityRegionAccessStrategyTest.this.withTx(EntityRegionAccessStrategyTest.this.localEnvironment, session, () -> {
                        ((EntityRegionAccessStrategy)EntityRegionAccessStrategyTest.this.localAccessStrategy).putFromLoad(session, KEY, (Object)"VALUE1", session.getTimestamp(), (Object)1);
                        return null;
                    });
                }
                catch (Exception e) {
                    EntityRegionAccessStrategyTest.this.log.error((Object)"node1 caught exception", (Throwable)e);
                    EntityRegionAccessStrategyTest.this.node1Exception = e;
                }
                catch (AssertionFailedError e) {
                    EntityRegionAccessStrategyTest.this.node1Failure = e;
                }
                finally {
                    pferCompletionLatch.countDown();
                }
            }
        };
        blocker.start();
        Assert.assertTrue((String)"Active tx has done an update", (boolean)pferLatch.await(1L, TimeUnit.SECONDS));
        putter.start();
        Assert.assertTrue((String)"putFromLoad returns promptly", (boolean)pferCompletionLatch.await(10L, TimeUnit.MILLISECONDS));
        commitLatch.countDown();
        Assert.assertTrue((String)"Threads completed", (boolean)completionLatch.await(1L, TimeUnit.SECONDS));
        this.assertThreadsRanCleanly();
        SharedSessionContractImplementor session = this.mockedSession();
        Assert.assertEquals((String)"Correct node1 value", (Object)"VALUE2", (Object)((EntityRegionAccessStrategy)this.localAccessStrategy).get(session, KEY, session.getTimestamp()));
    }
}

