/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.hibernate.cache.functional;

import java.io.Serializable;
import java.util.List;
import org.hibernate.stat.spi.StatisticsImplementor;
import org.infinispan.test.hibernate.cache.functional.SingleNodeTest;
import org.infinispan.test.hibernate.cache.functional.entities.Name;
import org.infinispan.test.hibernate.cache.functional.entities.Person;
import org.junit.Assert;
import org.junit.Test;

public class EqualityTest
extends SingleNodeTest {
    @Override
    public List<Object[]> getParameters() {
        return this.getParameters(true, true, true, true);
    }

    protected Class[] getAnnotatedClasses() {
        return new Class[]{Person.class};
    }

    @Test
    public void testEqualityFromType() throws Exception {
        Person john = new Person("John", "Black", 26);
        Person peter = new Person("Peter", "White", 32);
        this.withTxSession(s -> {
            s.persist((Object)john);
            s.persist((Object)peter);
        });
        StatisticsImplementor statistics = this.sessionFactory().getStatistics();
        statistics.clear();
        for (int i = 0; i < 5; ++i) {
            this.withTxSession(s -> {
                Person p1 = (Person)s.get(Person.class, (Serializable)john.getName());
                EqualityTest.assertPersonEquals(john, p1);
                Person p2 = (Person)s.get(Person.class, (Serializable)peter.getName());
                EqualityTest.assertPersonEquals(peter, p2);
                Person p3 = (Person)s.get(Person.class, (Serializable)new Name("Foo", "Bar"));
                Assert.assertNull((Object)p3);
            });
        }
        Assert.assertTrue((statistics.getSecondLevelCacheHitCount() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((statistics.getSecondLevelCacheMissCount() > 0L ? 1 : 0) != 0);
    }

    private static void assertPersonEquals(Person expected, Person person) {
        Assert.assertNotNull((Object)person);
        Assert.assertNotNull((Object)person.getName());
        Assert.assertEquals((Object)expected.getName().getFirstName(), (Object)person.getName().getFirstName());
        Assert.assertEquals((Object)expected.getName().getLastName(), (Object)person.getName().getLastName());
        Assert.assertEquals((long)expected.getAge(), (long)person.getAge());
    }
}

