/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.hibernate.cache.functional.cluster;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;
import org.infinispan.hibernate.cache.util.InfinispanMessageLogger;
import org.infinispan.test.hibernate.cache.functional.entities.Account;
import org.infinispan.test.hibernate.cache.functional.entities.AccountHolder;
import org.infinispan.test.hibernate.cache.util.TxUtil;

public class AccountDAO {
    private static final InfinispanMessageLogger log = InfinispanMessageLogger.Provider.getLog(AccountDAO.class);
    private final boolean useJta;
    private final SessionFactory sessionFactory;
    private AccountHolder smith = new AccountHolder("Smith", "1000");
    private AccountHolder jones = new AccountHolder("Jones", "2000");
    private AccountHolder barney = new AccountHolder("Barney", "3000");

    public AccountDAO(boolean useJta, SessionFactory sessionFactory) throws Exception {
        this.useJta = useJta;
        this.sessionFactory = sessionFactory;
    }

    public AccountHolder getSmith() {
        return this.smith;
    }

    public AccountHolder getJones() {
        return this.jones;
    }

    public AccountHolder getBarney() {
        return this.barney;
    }

    public void updateAccountBranch(Integer id, String branch) throws Exception {
        TxUtil.withTxSession(this.useJta, this.sessionFactory, session -> {
            log.debug((Object)("Updating account " + id + " to branch " + branch));
            Account account = (Account)session.get(Account.class, (Serializable)id);
            log.debug((Object)("Set branch " + branch));
            account.setBranch(branch);
            session.update((Object)account);
            log.debug((Object)("Updated account " + id + " to branch " + branch));
        });
    }

    public int getCountForBranch(String branch, boolean useRegion) throws Exception {
        return TxUtil.withTxSessionApply(this.useJta, this.sessionFactory, session -> {
            Query query = session.createQuery("select account from Account as account where account.branch = :branch");
            query.setString("branch", branch);
            if (useRegion) {
                query.setCacheRegion("AccountRegion");
            }
            query.setCacheable(true);
            return query.list().size();
        });
    }

    public void createAccount(AccountHolder holder, Integer id, Integer openingBalance, String branch) throws Exception {
        TxUtil.withTxSession(this.useJta, this.sessionFactory, session -> {
            log.debug((Object)("Creating account " + id));
            Account account = new Account();
            account.setId(id);
            account.setAccountHolder(holder);
            account.setBalance(openingBalance);
            log.debug((Object)("Set branch " + branch));
            account.setBranch(branch);
            session.persist((Object)account);
            log.debug((Object)("Created account " + id));
        });
    }

    public Account getAccount(Integer id) throws Exception {
        return TxUtil.withTxSessionApply(this.useJta, this.sessionFactory, session -> {
            log.debug((Object)("Getting account " + id));
            return (Account)session.get(Account.class, (Serializable)id);
        });
    }

    public Account getAccountWithRefresh(Integer id) throws Exception {
        return TxUtil.withTxSessionApply(this.useJta, this.sessionFactory, session -> {
            log.debug((Object)("Getting account " + id + " with refresh"));
            Account acct = (Account)session.get(Account.class, (Serializable)id);
            session.refresh((Object)acct);
            return (Account)session.get(Account.class, (Serializable)id);
        });
    }

    public void updateAccountBalance(Integer id, Integer newBalance) throws Exception {
        TxUtil.withTxSession(this.useJta, this.sessionFactory, session -> {
            log.debug((Object)("Updating account " + id + " to balance " + newBalance));
            Account account = (Account)session.get(Account.class, (Serializable)id);
            account.setBalance(newBalance);
            session.update((Object)account);
            log.debug((Object)("Updated account " + id + " to balance " + newBalance));
        });
    }

    public String getBranch(Object holder, boolean useRegion) throws Exception {
        return TxUtil.withTxSessionApply(this.useJta, this.sessionFactory, session -> {
            Query query = session.createQuery("select account.branch from Account as account where account.accountHolder = ?");
            query.setParameter(0, holder);
            if (useRegion) {
                query.setCacheRegion("AccountRegion");
            }
            query.setCacheable(true);
            return (String)query.list().get(0);
        });
    }

    public int getTotalBalance(AccountHolder holder, boolean useRegion) throws Exception {
        List results = TxUtil.withTxSessionApply(this.useJta, this.sessionFactory, session -> {
            Query query = session.createQuery("select account.balance from Account as account where account.accountHolder = ?");
            query.setParameter(0, (Object)holder);
            if (useRegion) {
                query.setCacheRegion("AccountRegion");
            }
            query.setCacheable(true);
            return query.list();
        });
        int total = 0;
        if (results != null) {
            Iterator it = results.iterator();
            while (it.hasNext()) {
                System.out.println("Total = " + (total += ((Integer)it.next()).intValue()));
            }
        }
        return total;
    }

    public void cleanup() throws Exception {
        this.internalCleanup();
    }

    private void internalCleanup() throws Exception {
        TxUtil.withTxSession(this.useJta, this.sessionFactory, session -> {
            Query query = session.createQuery("select account from Account as account");
            List accts = query.list();
            if (accts != null) {
                Iterator it = accts.iterator();
                while (it.hasNext()) {
                    try {
                        Object acct = it.next();
                        log.info((Object)("Removing " + acct));
                        session.delete(acct);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    public void remove() {
        try {
            this.internalCleanup();
        }
        catch (Exception e) {
            log.error((Object)"Caught exception in remove", (Throwable)e);
        }
    }
}

