/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.hibernate.cache.functional.cluster;

import java.util.Map;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.resource.transaction.backend.jta.internal.JtaTransactionCoordinatorBuilderImpl;
import org.hibernate.resource.transaction.spi.TransactionCoordinatorBuilder;
import org.hibernate.service.ServiceRegistry;
import org.infinispan.hibernate.cache.util.InfinispanMessageLogger;
import org.infinispan.marshall.core.ExternallyMarshallable;
import org.infinispan.test.hibernate.cache.functional.AbstractFunctionalTest;
import org.infinispan.test.hibernate.cache.functional.cluster.ClusterAwareRegionFactory;
import org.infinispan.test.hibernate.cache.functional.cluster.DualNodeJtaPlatformImpl;
import org.infinispan.test.hibernate.cache.functional.cluster.DualNodeJtaTransactionManagerImpl;
import org.infinispan.test.hibernate.cache.util.InfinispanTestingSetup;
import org.infinispan.test.hibernate.cache.util.TxUtil;
import org.junit.ClassRule;

public abstract class DualNodeTest
extends AbstractFunctionalTest {
    private static final InfinispanMessageLogger log = InfinispanMessageLogger.Provider.getLog(DualNodeTest.class);
    @ClassRule
    public static final InfinispanTestingSetup infinispanTestIdentifier = new InfinispanTestingSetup();
    public static final String REGION_FACTORY_DELEGATE = "hibernate.cache.region.factory_delegate";
    public static final String NODE_ID_PROP = "hibernate.test.cluster.node.id";
    public static final String NODE_ID_FIELD = "nodeId";
    public static final String LOCAL = "local";
    public static final String REMOTE = "remote";
    private SecondNodeEnvironment secondNodeEnvironment;

    protected void withTxSession(SessionFactory sessionFactory, TxUtil.ThrowingConsumer<Session, Exception> consumer) throws Exception {
        TxUtil.withTxSession(this.useJta, sessionFactory, consumer);
    }

    protected <T> T withTxSessionApply(SessionFactory sessionFactory, TxUtil.ThrowingFunction<Session, T, Exception> consumer) throws Exception {
        return TxUtil.withTxSessionApply(this.useJta, sessionFactory, consumer);
    }

    @Override
    protected String getBaseForMappings() {
        return "org/infinispan/test/";
    }

    @Override
    public String[] getMappings() {
        return new String[]{"hibernate/cache/functional/entities/Contact.hbm.xml", "hibernate/cache/functional/entities/Customer.hbm.xml"};
    }

    @Override
    protected void addSettings(Map settings) {
        super.addSettings(settings);
        this.applyStandardSettings(settings);
        settings.put(NODE_ID_PROP, LOCAL);
        settings.put(NODE_ID_FIELD, LOCAL);
        settings.put(REGION_FACTORY_DELEGATE, this.getRegionFactoryClass());
    }

    protected void cleanupTest() throws Exception {
        this.cleanupTransactionManagement();
    }

    protected void cleanupTransactionManagement() {
        DualNodeJtaTransactionManagerImpl.cleanupTransactions();
        DualNodeJtaTransactionManagerImpl.cleanupTransactionManagers();
    }

    public void startUp() {
        super.startUp();
        ExternallyMarshallable.addToWhiteList((String)"org.hibernate.cache");
        infinispanTestIdentifier.joinContext();
        this.secondNodeEnvironment = new SecondNodeEnvironment();
    }

    public void shutDown() {
        if (this.secondNodeEnvironment != null) {
            this.secondNodeEnvironment.shutDown();
        }
        super.shutDown();
    }

    protected SecondNodeEnvironment secondNodeEnvironment() {
        return this.secondNodeEnvironment;
    }

    protected Class getCacheRegionFactory() {
        return ClusterAwareRegionFactory.class;
    }

    protected Class getJtaPlatformClass() {
        return DualNodeJtaPlatformImpl.class;
    }

    protected Class<? extends TransactionCoordinatorBuilder> getTransactionCoordinatorBuilder() {
        return JtaTransactionCoordinatorBuilderImpl.class;
    }

    protected void configureSecondNode(StandardServiceRegistryBuilder ssrb) {
    }

    protected void applyStandardSettings(Map settings) {
        settings.put("hibernate.cache.region.factory_class", ClusterAwareRegionFactory.class.getName());
    }

    public class SecondNodeEnvironment {
        private StandardServiceRegistry serviceRegistry;
        private SessionFactoryImplementor sessionFactory;

        public SecondNodeEnvironment() {
            StandardServiceRegistryBuilder ssrb = DualNodeTest.this.constructStandardServiceRegistryBuilder();
            DualNodeTest.this.applyStandardSettings(ssrb.getSettings());
            ssrb.applySetting(DualNodeTest.NODE_ID_PROP, (Object)DualNodeTest.REMOTE);
            ssrb.applySetting(DualNodeTest.NODE_ID_FIELD, (Object)DualNodeTest.REMOTE);
            DualNodeTest.this.configureSecondNode(ssrb);
            this.serviceRegistry = ssrb.build();
            MetadataSources metadataSources = new MetadataSources((ServiceRegistry)this.serviceRegistry);
            DualNodeTest.this.applyMetadataSources(metadataSources);
            Metadata metadata = metadataSources.buildMetadata();
            DualNodeTest.this.applyCacheSettings(metadata);
            DualNodeTest.this.afterMetadataBuilt(metadata);
            this.sessionFactory = (SessionFactoryImplementor)metadata.buildSessionFactory();
        }

        public StandardServiceRegistry getServiceRegistry() {
            return this.serviceRegistry;
        }

        public SessionFactoryImplementor getSessionFactory() {
            return this.sessionFactory;
        }

        public void shutDown() {
            if (this.sessionFactory != null) {
                try {
                    this.sessionFactory.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.serviceRegistry != null) {
                try {
                    StandardServiceRegistryBuilder.destroy((ServiceRegistry)this.serviceRegistry);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

