/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.hibernate.cache.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import junit.framework.AssertionFailedError;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cache.internal.StandardQueryCache;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cache.spi.QueryResultsRegion;
import org.hibernate.cache.spi.Region;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.testing.TestForIssue;
import org.infinispan.AdvancedCache;
import org.infinispan.hibernate.cache.InfinispanRegionFactory;
import org.infinispan.hibernate.cache.query.QueryResultsRegionImpl;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryVisited;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryVisitedEvent;
import org.infinispan.test.hibernate.cache.AbstractGeneralDataRegionTest;
import org.infinispan.test.hibernate.cache.util.CacheTestUtil;
import org.infinispan.util.concurrent.IsolationLevel;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.junit.Test;

public class QueryRegionImplTest
extends AbstractGeneralDataRegionTest {
    private static final Logger log = Logger.getLogger(QueryRegionImplTest.class);

    @Override
    protected Region createRegion(InfinispanRegionFactory regionFactory, String regionName, Properties properties, CacheDataDescription cdd) {
        return regionFactory.buildQueryResultsRegion(regionName, properties);
    }

    @Override
    protected String getStandardRegionName(String regionPrefix) {
        return regionPrefix + "/" + StandardQueryCache.class.getName();
    }

    @Override
    protected AdvancedCache getInfinispanCache(InfinispanRegionFactory regionFactory) {
        return regionFactory.getCacheManager().getCache(this.getStandardRegionName("test")).getAdvancedCache();
    }

    @Override
    protected StandardServiceRegistryBuilder createStandardServiceRegistryBuilder() {
        return CacheTestUtil.buildCustomQueryCacheStandardServiceRegistryBuilder("test", "replicated-query", this.jtaPlatform);
    }

    private void withQueryRegion(RegionConsumer callable) throws Exception {
        this.withSessionFactoriesAndRegions(1, (sessionFactories, regions) -> callable.accept((SessionFactory)sessionFactories.get(0), (QueryResultsRegion)regions.get(0)));
    }

    @Test
    public void testPutDoesNotBlockGet() throws Exception {
        this.withQueryRegion((sessionFactory, region) -> {
            this.withSession(sessionFactory, session -> region.put(session, (Object)"Key", (Object)"value1"));
            Assert.assertEquals((Object)"value1", (Object)this.callWithSession(sessionFactory, session -> region.get(session, (Object)"Key")));
            final CountDownLatch readerLatch = new CountDownLatch(1);
            final CountDownLatch writerLatch = new CountDownLatch(1);
            final CountDownLatch completionLatch = new CountDownLatch(1);
            final ExceptionHolder holder = new ExceptionHolder();
            Thread reader = new Thread(){

                @Override
                public void run() {
                    try {
                        Assert.assertNotEquals((Object)"value2", (Object)QueryRegionImplTest.this.callWithSession(sessionFactory, session -> region.get(session, (Object)"Key")));
                    }
                    catch (AssertionFailedError e) {
                        holder.addAssertionFailure(e);
                    }
                    catch (Exception e) {
                        holder.addException(e);
                    }
                    finally {
                        readerLatch.countDown();
                    }
                }
            };
            Thread writer = new Thread(){

                @Override
                public void run() {
                    try {
                        QueryRegionImplTest.this.withSession(sessionFactory, session -> {
                            region.put(session, (Object)"Key", (Object)"value2");
                            writerLatch.await();
                        });
                    }
                    catch (Exception e) {
                        holder.addException(e);
                    }
                    finally {
                        completionLatch.countDown();
                    }
                }
            };
            reader.setDaemon(true);
            writer.setDaemon(true);
            writer.start();
            Assert.assertFalse((String)"Writer is blocking", (boolean)completionLatch.await(100L, TimeUnit.MILLISECONDS));
            reader.start();
            Assert.assertTrue((String)"Reader finished promptly", (boolean)readerLatch.await(100L, TimeUnit.MILLISECONDS));
            writerLatch.countDown();
            Assert.assertTrue((String)"Reader finished promptly", (boolean)completionLatch.await(100L, TimeUnit.MILLISECONDS));
            Assert.assertEquals((Object)"value2", (Object)this.callWithSession(sessionFactory, session -> region.get(session, (Object)"Key")));
        });
    }

    @Test
    public void testGetDoesNotBlockPut() throws Exception {
        this.withQueryRegion((sessionFactory, region) -> {
            this.withSession(sessionFactory, session -> region.put(session, (Object)"Key", (Object)"value1"));
            Assert.assertEquals((Object)"value1", (Object)this.callWithSession(sessionFactory, session -> region.get(session, (Object)"Key")));
            final AdvancedCache cache = ((QueryResultsRegionImpl)region).getCache();
            final CountDownLatch blockerLatch = new CountDownLatch(1);
            final CountDownLatch writerLatch = new CountDownLatch(1);
            final CountDownLatch completionLatch = new CountDownLatch(1);
            final ExceptionHolder holder = new ExceptionHolder();
            Thread reader = new Thread(){

                @Override
                public void run() {
                    GetBlocker blocker = new GetBlocker(blockerLatch, "Key");
                    try {
                        cache.addListener((Object)blocker);
                        QueryRegionImplTest.this.withSession(sessionFactory, session -> region.get(session, (Object)"Key"));
                    }
                    catch (Exception e) {
                        holder.addException(e);
                    }
                    finally {
                        cache.removeListener((Object)blocker);
                    }
                }
            };
            Thread writer = new Thread(){

                @Override
                public void run() {
                    try {
                        writerLatch.await();
                        QueryRegionImplTest.this.withSession(sessionFactory, session -> region.put(session, (Object)"Key", (Object)"value2"));
                    }
                    catch (Exception e) {
                        holder.addException(e);
                    }
                    finally {
                        completionLatch.countDown();
                    }
                }
            };
            reader.setDaemon(true);
            writer.setDaemon(true);
            boolean unblocked = false;
            try {
                reader.start();
                writer.start();
                Assert.assertFalse((String)"Reader is blocking", (boolean)completionLatch.await(100L, TimeUnit.MILLISECONDS));
                writerLatch.countDown();
                Assert.assertTrue((String)"Writer finished promptly", (boolean)completionLatch.await(100L, TimeUnit.MILLISECONDS));
                blockerLatch.countDown();
                unblocked = true;
                if (IsolationLevel.REPEATABLE_READ.equals((Object)cache.getCacheConfiguration().locking().isolationLevel())) {
                    Assert.assertEquals((Object)"value1", (Object)this.callWithSession(sessionFactory, session -> region.get(session, (Object)"Key")));
                } else {
                    Assert.assertEquals((Object)"value2", (Object)this.callWithSession(sessionFactory, session -> region.get(session, (Object)"Key")));
                }
                holder.checkExceptions();
            }
            finally {
                if (!unblocked) {
                    blockerLatch.countDown();
                }
            }
        });
    }

    protected <T> T callWithSession(SessionFactory sessionFactory, SessionCallable<T> callable) throws Exception {
        Session session = sessionFactory.openSession();
        Transaction tx = session.getTransaction();
        tx.begin();
        try {
            T retval = callable.call((SharedSessionContractImplementor)session);
            tx.commit();
            T t = retval;
            return t;
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
        finally {
            session.close();
        }
    }

    protected void withSession(SessionFactory sessionFactory, SessionConsumer consumer) throws Exception {
        this.callWithSession(sessionFactory, session -> {
            consumer.accept(session);
            return null;
        });
    }

    @Test
    @TestForIssue(jiraKey="HHH-7898")
    public void testPutDuringPut() throws Exception {
        this.withQueryRegion((sessionFactory, region) -> {
            this.withSession(sessionFactory, session -> region.put(session, (Object)"Key", (Object)"value1"));
            Assert.assertEquals((Object)"value1", (Object)this.callWithSession(sessionFactory, session -> region.get(session, (Object)"Key")));
            final AdvancedCache cache = ((QueryResultsRegionImpl)region).getCache();
            final CountDownLatch blockerLatch = new CountDownLatch(1);
            final CountDownLatch triggerLatch = new CountDownLatch(1);
            final ExceptionHolder holder = new ExceptionHolder();
            Thread blocking = new Thread(){

                @Override
                public void run() {
                    block8: {
                        PutBlocker blocker = null;
                        try {
                            blocker = new PutBlocker(blockerLatch, triggerLatch, "Key");
                            cache.addListener((Object)blocker);
                            QueryRegionImplTest.this.withSession(sessionFactory, session -> region.put(session, (Object)"Key", (Object)"value2"));
                            if (blocker == null) break block8;
                        }
                        catch (Exception e) {
                            block9: {
                                try {
                                    holder.addException(e);
                                    if (blocker == null) break block9;
                                }
                                catch (Throwable throwable) {
                                    if (blocker != null) {
                                        cache.removeListener(blocker);
                                    }
                                    if (triggerLatch.getCount() > 0L) {
                                        triggerLatch.countDown();
                                    }
                                    throw throwable;
                                }
                                cache.removeListener((Object)blocker);
                            }
                            if (triggerLatch.getCount() > 0L) {
                                triggerLatch.countDown();
                            }
                        }
                        cache.removeListener((Object)blocker);
                    }
                    if (triggerLatch.getCount() > 0L) {
                        triggerLatch.countDown();
                    }
                }
            };
            Thread blocked = new Thread(){

                @Override
                public void run() {
                    try {
                        triggerLatch.await();
                        QueryRegionImplTest.this.withSession(sessionFactory, session -> region.put(session, (Object)"Key", (Object)"value3"));
                    }
                    catch (Exception e) {
                        holder.addException(e);
                    }
                }
            };
            blocking.setName("blocking-thread");
            blocking.start();
            blocked.setName("blocked-thread");
            blocked.start();
            blocked.join();
            blockerLatch.countDown();
            blocking.join();
            holder.checkExceptions();
            Assert.assertEquals((Object)"value2", (Object)this.callWithSession(sessionFactory, session -> region.get(session, (Object)"Key")));
        });
    }

    @Test
    public void testQueryUpdate() throws Exception {
        this.withQueryRegion((sessionFactory, region) -> {
            final ExceptionHolder holder = new ExceptionHolder();
            final CyclicBarrier barrier = new CyclicBarrier(2);
            this.withSession(sessionFactory, session -> region.put(session, (Object)"Key", (Object)"value1"));
            Thread updater = new Thread(){

                @Override
                public void run() {
                    try {
                        QueryRegionImplTest.this.withSession(sessionFactory, session -> {
                            Assert.assertEquals((Object)"value1", (Object)region.get(session, (Object)"Key"));
                            region.put(session, (Object)"Key", (Object)"value2");
                            Assert.assertEquals((Object)"value2", (Object)region.get(session, (Object)"Key"));
                            barrier.await(5L, TimeUnit.SECONDS);
                            barrier.await(5L, TimeUnit.SECONDS);
                            region.put(session, (Object)"Key", (Object)"value3");
                            Assert.assertEquals((Object)"value3", (Object)region.get(session, (Object)"Key"));
                            barrier.await(5L, TimeUnit.SECONDS);
                            barrier.await(5L, TimeUnit.SECONDS);
                        });
                    }
                    catch (AssertionFailedError e) {
                        holder.addAssertionFailure(e);
                        barrier.reset();
                    }
                    catch (Exception e) {
                        holder.addException(e);
                        barrier.reset();
                    }
                }
            };
            Thread reader = new Thread(){

                @Override
                public void run() {
                    try {
                        QueryRegionImplTest.this.withSession(sessionFactory, session -> {
                            Assert.assertEquals((Object)"value1", (Object)region.get(session, (Object)"Key"));
                            barrier.await(5L, TimeUnit.SECONDS);
                            Assert.assertEquals((Object)"value1", (Object)region.get(session, (Object)"Key"));
                            barrier.await(5L, TimeUnit.SECONDS);
                            barrier.await(5L, TimeUnit.SECONDS);
                            Assert.assertEquals((Object)"value1", (Object)region.get(session, (Object)"Key"));
                            barrier.await(5L, TimeUnit.SECONDS);
                        });
                    }
                    catch (AssertionFailedError e) {
                        holder.addAssertionFailure(e);
                        barrier.reset();
                    }
                    catch (Exception e) {
                        holder.addException(e);
                        barrier.reset();
                    }
                }
            };
            updater.start();
            reader.start();
            updater.join();
            reader.join();
            holder.checkExceptions();
            Assert.assertEquals((Object)"value3", (Object)this.callWithSession(sessionFactory, session -> region.get(session, (Object)"Key")));
        });
    }

    @Override
    @Test
    @TestForIssue(jiraKey="HHH-10163")
    public void testEvictAll() throws Exception {
        this.withQueryRegion((sessionFactory, region) -> {
            this.withSession(sessionFactory, s -> region.put(s, (Object)"Key", (Object)"value1"));
            this.withSession(sessionFactory, s -> Assert.assertEquals((Object)"value1", (Object)region.get(s, (Object)"Key")));
            region.evictAll();
            this.withSession(sessionFactory, s -> Assert.assertNull((Object)region.get(s, (Object)"Key")));
            Assert.assertEquals((Object)Collections.EMPTY_MAP, (Object)region.toMap());
        });
    }

    private class ExceptionHolder {
        private final List<Exception> exceptions = Collections.synchronizedList(new ArrayList());
        private final List<AssertionFailedError> assertionFailures = Collections.synchronizedList(new ArrayList());

        private ExceptionHolder() {
        }

        public void addException(Exception e) {
            this.exceptions.add(e);
        }

        public void addAssertionFailure(AssertionFailedError e) {
            this.assertionFailures.add(e);
        }

        public void checkExceptions() throws Exception {
            Iterator<Throwable> iterator = this.assertionFailures.iterator();
            if (iterator.hasNext()) {
                AssertionFailedError a = iterator.next();
                throw a;
            }
            iterator = this.exceptions.iterator();
            if (iterator.hasNext()) {
                Exception e = (Exception)iterator.next();
                throw e;
            }
        }
    }

    @Listener
    public class PutBlocker {
        private final CountDownLatch blockLatch;
        private final CountDownLatch triggerLatch;
        private final Object key;
        private boolean enabled = true;

        PutBlocker(CountDownLatch blockLatch, CountDownLatch triggerLatch, Object key) {
            this.blockLatch = blockLatch;
            this.triggerLatch = triggerLatch;
            this.key = key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CacheEntryModified
        public void nodeVisisted(CacheEntryModifiedEvent event) {
            if (!event.isPre() && event.getKey().equals(this.key)) {
                try {
                    PutBlocker putBlocker = this;
                    synchronized (putBlocker) {
                        if (this.enabled) {
                            this.triggerLatch.countDown();
                            this.enabled = false;
                            this.blockLatch.await();
                        }
                    }
                }
                catch (InterruptedException e) {
                    log.error((Object)"Interrupted waiting for latch", (Throwable)e);
                }
            }
        }
    }

    @Listener
    public class GetBlocker {
        private final CountDownLatch latch;
        private final Object key;

        GetBlocker(CountDownLatch latch, Object key) {
            this.latch = latch;
            this.key = key;
        }

        @CacheEntryVisited
        public void nodeVisisted(CacheEntryVisitedEvent event) {
            if (event.isPre() && event.getKey().equals(this.key)) {
                try {
                    this.latch.await();
                }
                catch (InterruptedException e) {
                    log.error((Object)"Interrupted waiting for latch", (Throwable)e);
                }
            }
        }
    }

    protected static interface SessionCallable<T> {
        public T call(SharedSessionContractImplementor var1) throws Exception;
    }

    protected static interface SessionConsumer {
        public void accept(SharedSessionContractImplementor var1) throws Exception;
    }

    private static interface RegionConsumer {
        public void accept(SessionFactory var1, QueryResultsRegion var2) throws Exception;
    }
}

