/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.hibernate.cache.stress;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.transaction.TransactionManager;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.RootClass;
import org.hibernate.query.Query;
import org.hibernate.service.ServiceRegistry;
import org.infinispan.hibernate.cache.util.InfinispanMessageLogger;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.hibernate.cache.functional.entities.Age;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class PutFromLoadStressTestCase {
    static final InfinispanMessageLogger log = InfinispanMessageLogger.Provider.getLog(PutFromLoadStressTestCase.class);
    static final boolean isTrace = log.isTraceEnabled();
    static final int NUM_THREADS = 100;
    static final int WARMUP_TIME_SECS = 10;
    static final long RUNNING_TIME_SECS = Integer.getInteger("time", 60).intValue();
    static final long LAUNCH_INTERVAL_MILLIS = 10L;
    static final int NUM_INSTANCES = 5000;
    static SessionFactory sessionFactory;
    static TransactionManager tm;
    final AtomicBoolean run = new AtomicBoolean(true);

    @BeforeClass
    public static void beforeClass() {
        StandardServiceRegistryBuilder ssrb = new StandardServiceRegistryBuilder().applySetting("hibernate.cache.use_second_level_cache", (Object)"true").applySetting("hibernate.cache.use_query_cache", (Object)"true").applySetting("hibernate.cache.region.factory_class", (Object)"org.infinispan.hibernate.cache.InfinispanRegionFactory").applySetting("hibernate.transaction.jta.platform", (Object)"org.hibernate.service.jta.platform.internal.JBossStandAloneJtaPlatform").applySetting("hibernate.cache.use_minimal_puts", (Object)"false").applySetting("hibernate.hbm2ddl.auto", (Object)"create-drop");
        StandardServiceRegistry serviceRegistry = ssrb.build();
        MetadataSources metadataSources = new MetadataSources((ServiceRegistry)serviceRegistry).addResource("cache/infinispan/functional/Item.hbm.xml").addResource("cache/infinispan/functional/Customer.hbm.xml").addResource("cache/infinispan/functional/Contact.hbm.xml").addAnnotatedClass(Age.class);
        Metadata metadata = metadataSources.buildMetadata();
        for (PersistentClass entityBinding : metadata.getEntityBindings()) {
            if (!(entityBinding instanceof RootClass)) continue;
            ((RootClass)entityBinding).setCacheConcurrencyStrategy("transactional");
        }
        for (Collection collectionBinding : metadata.getCollectionBindings()) {
            collectionBinding.setCacheConcurrencyStrategy("transactional");
        }
        sessionFactory = metadata.buildSessionFactory();
        tm = com.arjuna.ats.jta.TransactionManager.transactionManager();
    }

    @AfterClass
    public static void afterClass() {
        sessionFactory.close();
    }

    @Test
    public void testQueryPerformance() throws Exception {
        this.store();
        this.doTest(false);
    }

    private void store() throws Exception {
        for (int i = 0; i < 5000; ++i) {
            final Age age = new Age();
            age.setAge(i);
            TestingUtil.withTx((TransactionManager)tm, (Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    Session s = sessionFactory.openSession();
                    s.getTransaction().begin();
                    s.persist((Object)age);
                    s.getTransaction().commit();
                    s.close();
                    return null;
                }
            });
        }
    }

    private void doTest(boolean warmup) throws Exception {
        ExecutorService executor = Executors.newFixedThreadPool(100);
        try {
            CyclicBarrier barrier = new CyclicBarrier(101);
            ArrayList<Future<String>> futures = new ArrayList<Future<String>>(100);
            for (int i = 0; i < 100; ++i) {
                Future<String> future = executor.submit(new SelectQueryRunner(barrier, warmup, i + 1));
                futures.add(future);
                Thread.sleep(10L);
            }
            barrier.await();
            long timeout = warmup ? 10L : RUNNING_TIME_SECS;
            TimeUnit unit = TimeUnit.SECONDS;
            Thread.sleep(unit.toMillis(timeout));
            this.run.set(false);
            barrier.await(2L, TimeUnit.MINUTES);
            log.infof("[%s] All threads finished, check for exceptions", (Object)this.title(warmup));
            for (Future future : futures) {
                String opsPerMS = (String)future.get();
                if (warmup) continue;
                log.infof("[%s] Operations/ms: %s", (Object)this.title(warmup), (Object)opsPerMS);
            }
            log.infof("[%s] All future gets checked", (Object)this.title(warmup));
        }
        catch (Exception e) {
            log.errorf((Throwable)e, "Error in one of the execution threads during %s", (Object)this.title(warmup));
            throw e;
        }
        finally {
            executor.shutdownNow();
        }
    }

    private String title(boolean warmup) {
        return warmup ? "warmup" : "stress";
    }

    public class SelectQueryRunner
    implements Callable<String> {
        final CyclicBarrier barrier;
        final boolean warmup;
        final Integer customerId;

        public SelectQueryRunner(CyclicBarrier barrier, boolean warmup, Integer customerId) {
            this.barrier = barrier;
            this.warmup = warmup;
            this.customerId = customerId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String call() throws Exception {
            try {
                if (isTrace) {
                    log.tracef("[%s] Wait for all executions paths to be ready to perform calls", (Object)PutFromLoadStressTestCase.this.title(this.warmup));
                }
                this.barrier.await();
                long start = System.nanoTime();
                int runs = 0;
                if (isTrace) {
                    log.tracef("[%s] Start time: %d", (Object)PutFromLoadStressTestCase.this.title(this.warmup), (Object)start);
                }
                this.queryItems();
                long end = System.nanoTime();
                long duration = end - start;
                if (isTrace) {
                    log.tracef("[%s] End time: %d, duration: %d, runs: %d", new Object[]{PutFromLoadStressTestCase.this.title(this.warmup), start, duration, runs});
                }
                String string = this.opsPerMS(duration, runs);
                return string;
            }
            finally {
                if (isTrace) {
                    log.tracef("[%s] Wait for all execution paths to finish", (Object)PutFromLoadStressTestCase.this.title(this.warmup));
                }
                this.barrier.await();
            }
        }

        private void deleteCachedItems() throws Exception {
            TestingUtil.withTx((TransactionManager)tm, (Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    sessionFactory.getCache().evictEntityRegion(Age.class);
                    return null;
                }
            });
        }

        private void queryItems() throws Exception {
            TestingUtil.withTx((TransactionManager)tm, (Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    Session s = sessionFactory.getCurrentSession();
                    Query query = s.getNamedQuery("Age.findAll").setCacheable(true);
                    List result = query.list();
                    Assert.assertFalse((boolean)result.isEmpty());
                    return null;
                }
            });
        }

        private String opsPerMS(long nanos, int ops) {
            long totalMillis = TimeUnit.NANOSECONDS.toMillis(nanos);
            if (totalMillis > 0L) {
                return (long)ops / totalMillis + " ops/ms";
            }
            return "NAN ops/ms";
        }
    }
}

