/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.hibernate.cache;

import java.util.Properties;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cache.internal.CacheDataDescriptionImpl;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.TransactionalDataRegion;
import org.hibernate.internal.util.compare.ComparableComparator;
import org.hibernate.service.ServiceRegistry;
import org.infinispan.hibernate.cache.InfinispanRegionFactory;
import org.infinispan.test.hibernate.cache.AbstractRegionImplTest;
import org.infinispan.test.hibernate.cache.util.CacheTestUtil;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractEntityCollectionRegionTest
extends AbstractRegionImplTest {
    protected static CacheDataDescription MUTABLE_NON_VERSIONED = new CacheDataDescriptionImpl(true, false, ComparableComparator.INSTANCE, null);

    @Test
    public void testSupportedAccessTypes() throws Exception {
        this.supportedAccessTypeTest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void supportedAccessTypeTest() throws Exception {
        StandardServiceRegistryBuilder ssrb = this.createStandardServiceRegistryBuilder();
        StandardServiceRegistry registry = ssrb.build();
        try {
            InfinispanRegionFactory regionFactory = CacheTestUtil.startRegionFactory((ServiceRegistry)registry, this.getCacheTestSupport());
            this.supportedAccessTypeTest((RegionFactory)regionFactory, CacheTestUtil.toProperties(ssrb.getSettings()));
        }
        finally {
            StandardServiceRegistryBuilder.destroy((ServiceRegistry)registry);
        }
    }

    protected abstract void supportedAccessTypeTest(RegionFactory var1, Properties var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIsTransactionAware() throws Exception {
        StandardServiceRegistryBuilder ssrb = CacheTestUtil.buildBaselineStandardServiceRegistryBuilder("test", InfinispanRegionFactory.class, true, false, this.jtaPlatform);
        StandardServiceRegistry registry = ssrb.build();
        try {
            Properties properties = CacheTestUtil.toProperties(ssrb.getSettings());
            InfinispanRegionFactory regionFactory = CacheTestUtil.startRegionFactory((ServiceRegistry)registry, this.getCacheTestSupport());
            TransactionalDataRegion region = (TransactionalDataRegion)this.createRegion(regionFactory, "test/test", properties, this.getCacheDataDescription());
            Assert.assertTrue((String)"Region is transaction-aware", (boolean)region.isTransactionAware());
            CacheTestUtil.stopRegionFactory(regionFactory, this.getCacheTestSupport());
        }
        finally {
            StandardServiceRegistryBuilder.destroy((ServiceRegistry)registry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetCacheDataDescription() throws Exception {
        StandardServiceRegistryBuilder ssrb = CacheTestUtil.buildBaselineStandardServiceRegistryBuilder("test", InfinispanRegionFactory.class, true, false, this.jtaPlatform);
        StandardServiceRegistry registry = ssrb.build();
        try {
            Properties properties = CacheTestUtil.toProperties(ssrb.getSettings());
            InfinispanRegionFactory regionFactory = CacheTestUtil.startRegionFactory((ServiceRegistry)registry, this.getCacheTestSupport());
            TransactionalDataRegion region = (TransactionalDataRegion)this.createRegion(regionFactory, "test/test", properties, this.getCacheDataDescription());
            CacheDataDescription cdd = region.getCacheDataDescription();
            Assert.assertNotNull((Object)cdd);
            CacheDataDescription expected = this.getCacheDataDescription();
            Assert.assertEquals((Object)expected.isMutable(), (Object)cdd.isMutable());
            Assert.assertEquals((Object)expected.isVersioned(), (Object)cdd.isVersioned());
            Assert.assertEquals((Object)expected.getVersionComparator(), (Object)cdd.getVersionComparator());
        }
        finally {
            StandardServiceRegistryBuilder.destroy((ServiceRegistry)registry);
        }
    }
}

