/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.hibernate.cache;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import junit.framework.AssertionFailedError;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cache.internal.CacheDataDescriptionImpl;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cache.spi.access.RegionAccessStrategy;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.jdbc.connections.spi.JdbcConnectionAccess;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.transaction.internal.TransactionImpl;
import org.hibernate.internal.util.compare.ComparableComparator;
import org.hibernate.resource.jdbc.spi.JdbcSessionContext;
import org.hibernate.resource.jdbc.spi.JdbcSessionOwner;
import org.hibernate.resource.transaction.TransactionCoordinator;
import org.hibernate.resource.transaction.backend.jdbc.internal.JdbcResourceLocalTransactionCoordinatorBuilderImpl;
import org.hibernate.resource.transaction.backend.jdbc.spi.JdbcResourceTransactionAccess;
import org.hibernate.resource.transaction.spi.TransactionCoordinatorOwner;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.testing.AfterClassOnce;
import org.hibernate.testing.BeforeClassOnce;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.hibernate.cache.access.PutFromLoadValidator;
import org.infinispan.hibernate.cache.impl.BaseRegion;
import org.infinispan.hibernate.cache.util.Caches;
import org.infinispan.hibernate.cache.util.FutureUpdate;
import org.infinispan.hibernate.cache.util.TombstoneUpdate;
import org.infinispan.hibernate.cache.util.VersionedEntry;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestResourceTracker;
import org.infinispan.test.hibernate.cache.AbstractNonFunctionalTest;
import org.infinispan.test.hibernate.cache.NodeEnvironment;
import org.infinispan.test.hibernate.cache.util.BatchModeJtaPlatform;
import org.infinispan.test.hibernate.cache.util.BatchModeTransactionCoordinator;
import org.infinispan.test.hibernate.cache.util.ExpectingInterceptor;
import org.infinispan.test.hibernate.cache.util.JdbcResourceTransactionMock;
import org.infinispan.test.hibernate.cache.util.TestInfinispanRegionFactory;
import org.infinispan.test.hibernate.cache.util.TestSynchronization;
import org.infinispan.test.hibernate.cache.util.TestTimeService;
import org.jboss.logging.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public abstract class AbstractRegionAccessStrategyTest<R extends BaseRegion, S extends RegionAccessStrategy>
extends AbstractNonFunctionalTest {
    protected final Logger log = Logger.getLogger(((Object)((Object)this)).getClass());
    public static final String REGION_NAME = "test/com.foo.test";
    public static final String KEY_BASE = "KEY";
    public static final String VALUE1 = "VALUE1";
    public static final String VALUE2 = "VALUE2";
    public static final CacheDataDescription CACHE_DATA_DESCRIPTION = new CacheDataDescriptionImpl(true, true, ComparableComparator.INSTANCE, null);
    protected static final TestTimeService TIME_SERVICE = new TestTimeService();
    protected NodeEnvironment localEnvironment;
    protected R localRegion;
    protected S localAccessStrategy;
    protected NodeEnvironment remoteEnvironment;
    protected R remoteRegion;
    protected S remoteAccessStrategy;
    protected boolean transactional;
    protected boolean invalidation;
    protected boolean synchronous;
    protected Exception node1Exception;
    protected Exception node2Exception;
    protected AssertionFailedError node1Failure;
    protected AssertionFailedError node2Failure;
    protected List<Runnable> cleanup = new ArrayList<Runnable>();

    @Override
    protected boolean canUseLocalMode() {
        return false;
    }

    @BeforeClassOnce
    public void prepareResources() throws Exception {
        TestResourceTracker.testStarted((String)((Object)((Object)this)).getClass().getSimpleName());
        StandardServiceRegistryBuilder ssrb = this.createStandardServiceRegistryBuilder();
        this.localEnvironment = new NodeEnvironment(ssrb);
        this.localEnvironment.prepare();
        this.localRegion = this.getRegion(this.localEnvironment);
        this.localAccessStrategy = this.getAccessStrategy(this.localRegion);
        this.transactional = Caches.isTransactionalCache((AdvancedCache)this.localRegion.getCache());
        this.invalidation = Caches.isInvalidationCache((AdvancedCache)this.localRegion.getCache());
        this.synchronous = Caches.isSynchronousCache((AdvancedCache)this.localRegion.getCache());
        this.remoteEnvironment = new NodeEnvironment(ssrb);
        this.remoteEnvironment.prepare();
        this.remoteRegion = this.getRegion(this.remoteEnvironment);
        this.remoteAccessStrategy = this.getAccessStrategy(this.remoteRegion);
        this.waitForClusterToForm(new Cache[]{this.localRegion.getCache(), this.remoteRegion.getCache()});
    }

    @After
    public void cleanup() {
        this.cleanup.forEach(Runnable::run);
        this.cleanup.clear();
        if (this.localRegion != null) {
            this.localRegion.getCache().clear();
        }
        if (this.remoteRegion != null) {
            this.remoteRegion.getCache().clear();
        }
    }

    @AfterClassOnce
    public void releaseResources() throws Exception {
        try {
            if (this.localEnvironment != null) {
                this.localEnvironment.release();
            }
        }
        finally {
            if (this.remoteEnvironment != null) {
                this.remoteEnvironment.release();
            }
        }
        TestResourceTracker.testFinished((String)((Object)((Object)this)).getClass().getSimpleName());
    }

    @Override
    protected StandardServiceRegistryBuilder createStandardServiceRegistryBuilder() {
        StandardServiceRegistryBuilder ssrb = super.createStandardServiceRegistryBuilder();
        ssrb.applySetting(TestInfinispanRegionFactory.TIME_SERVICE, (Object)TIME_SERVICE);
        return ssrb;
    }

    protected void putFromLoadTest(boolean useMinimalAPI, boolean isRemoval) throws Exception {
        Object KEY = this.generateNextKey();
        CountDownLatch writeLatch1 = new CountDownLatch(1);
        CountDownLatch writeLatch2 = new CountDownLatch(1);
        CountDownLatch completionLatch = new CountDownLatch(2);
        CountDownLatch[] putFromLoadLatches = new CountDownLatch[2];
        Thread node1 = new Thread(() -> {
            try {
                SessionImplementor session = this.mockedSession();
                putFromLoadLatches[0] = this.withTx(this.localEnvironment, session, () -> {
                    Assert.assertNull((Object)this.localAccessStrategy.get(session, KEY, session.getTimestamp()));
                    writeLatch1.await();
                    CountDownLatch latch = this.expectPutFromLoad(this.remoteRegion);
                    if (useMinimalAPI) {
                        this.localAccessStrategy.putFromLoad(session, KEY, (Object)VALUE1, session.getTimestamp(), (Object)1, true);
                    } else {
                        this.localAccessStrategy.putFromLoad(session, KEY, (Object)VALUE1, session.getTimestamp(), (Object)1);
                    }
                    this.doUpdate(this.localAccessStrategy, session, KEY, VALUE2, 2);
                    return latch;
                });
            }
            catch (Exception e) {
                this.log.error((Object)"node1 caught exception", (Throwable)e);
                this.node1Exception = e;
            }
            catch (AssertionFailedError e) {
                this.node1Failure = e;
            }
            finally {
                writeLatch2.countDown();
                completionLatch.countDown();
            }
        }, this.putFromLoadTestThreadName("node1", useMinimalAPI, isRemoval));
        Thread node2 = new Thread(() -> {
            try {
                SessionImplementor session = this.mockedSession();
                putFromLoadLatches[1] = this.withTx(this.remoteEnvironment, session, () -> {
                    Assert.assertNull((Object)this.remoteAccessStrategy.get(session, KEY, session.getTimestamp()));
                    writeLatch1.countDown();
                    writeLatch2.await();
                    CountDownLatch latch = this.expectPutFromLoad(this.localRegion);
                    if (useMinimalAPI) {
                        this.remoteAccessStrategy.putFromLoad(session, KEY, (Object)VALUE1, session.getTimestamp(), (Object)1, true);
                    } else {
                        this.remoteAccessStrategy.putFromLoad(session, KEY, (Object)VALUE1, session.getTimestamp(), (Object)1);
                    }
                    return latch;
                });
            }
            catch (Exception e) {
                this.log.error((Object)"node2 caught exception", (Throwable)e);
                this.node2Exception = e;
            }
            catch (AssertionFailedError e) {
                this.node2Failure = e;
            }
            finally {
                completionLatch.countDown();
            }
        }, this.putFromLoadTestThreadName("node2", useMinimalAPI, isRemoval));
        node1.setDaemon(true);
        node2.setDaemon(true);
        CountDownLatch remoteUpdate = this.expectAfterUpdate();
        node1.start();
        node2.start();
        Assert.assertTrue((String)"Threads completed", (boolean)completionLatch.await(2L, TimeUnit.SECONDS));
        this.assertThreadsRanCleanly();
        Assert.assertTrue((String)"Update was replicated", (boolean)remoteUpdate.await(2L, TimeUnit.SECONDS));
        this.assertPutFromLoadLatches(putFromLoadLatches);
        SessionImplementor s1 = this.mockedSession();
        Assert.assertEquals((Object)(isRemoval ? null : VALUE2), (Object)this.localAccessStrategy.get(s1, KEY, s1.getTimestamp()));
        SessionImplementor s2 = this.mockedSession();
        Object remoteValue = this.remoteAccessStrategy.get(s2, KEY, s2.getTimestamp());
        if (this.isUsingInvalidation() || isRemoval) {
            Assert.assertNull((Object)remoteValue);
        } else {
            Assert.assertEquals((Object)VALUE2, (Object)remoteValue);
        }
    }

    protected void assertPutFromLoadLatches(CountDownLatch[] latches) {
        boolean await0 = this.await(latches[0]);
        boolean await1 = this.await(latches[1]);
        Assert.assertTrue((String)String.format("One of the latches in %s should have at least completed", Arrays.toString(latches)), (await0 || await1 ? 1 : 0) != 0);
    }

    private boolean await(CountDownLatch latch) {
        Assert.assertNotNull((Object)latch);
        try {
            this.log.debugf("Await latch: %s", (Object)latch);
            boolean await = latch.await(1L, TimeUnit.SECONDS);
            this.log.debugf("Finished waiting for latch, did latch reach zero? %b", (Object)await);
            return await;
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    String putFromLoadTestThreadName(String node, boolean useMinimalAPI, boolean isRemoval) {
        return String.format("putFromLoad=%s,%s,%s,%s,minimal=%s,isRemove=%s", node, this.mode, this.cacheMode, this.accessType, useMinimalAPI, isRemoval);
    }

    protected CountDownLatch expectAfterUpdate() {
        return this.expectPutWithValue(value -> value instanceof FutureUpdate);
    }

    protected CountDownLatch expectPutWithValue(Predicate<Object> valuePredicate) {
        if (!this.isUsingInvalidation() && this.accessType != AccessType.NONSTRICT_READ_WRITE) {
            CountDownLatch latch = new CountDownLatch(1);
            ExpectingInterceptor.get(this.remoteRegion.getCache()).when((ctx, cmd) -> cmd instanceof PutKeyValueCommand && valuePredicate.test(((PutKeyValueCommand)cmd).getValue())).countDown(latch);
            this.cleanup.add(() -> ExpectingInterceptor.cleanup(this.remoteRegion.getCache()));
            return latch;
        }
        return new CountDownLatch(0);
    }

    protected CountDownLatch expectPutFromLoad() {
        return this.expectPutWithValue(value -> value instanceof TombstoneUpdate);
    }

    protected CountDownLatch expectPutFromLoad(R region) {
        CountDownLatch latch;
        Predicate<Object> valuePredicate;
        Predicate<Object> predicate = valuePredicate = this.accessType == AccessType.NONSTRICT_READ_WRITE ? value -> value instanceof VersionedEntry : value -> value instanceof TombstoneUpdate;
        if (!this.isUsingInvalidation()) {
            latch = new CountDownLatch(1);
            ExpectingInterceptor.get(region.getCache()).when((ctx, cmd) -> cmd instanceof PutKeyValueCommand && valuePredicate.test(((PutKeyValueCommand)cmd).getValue())).countDown(latch);
            this.cleanup.add(() -> ExpectingInterceptor.cleanup(region.getCache()));
        } else {
            latch = new CountDownLatch(0);
        }
        this.log.debugf("Create latch for putFromLoad: %s", (Object)latch);
        return latch;
    }

    protected abstract void doUpdate(S var1, SessionImplementor var2, Object var3, Object var4, Object var5) throws RollbackException, SystemException;

    protected SessionImplementor mockedSession() {
        SessionMock session = (SessionMock)Mockito.mock(SessionMock.class);
        Mockito.when((Object)session.isClosed()).thenReturn((Object)false);
        Mockito.when((Object)session.getTimestamp()).thenReturn((Object)TIME_SERVICE.wallClockTime());
        if (this.jtaPlatform == BatchModeJtaPlatform.class) {
            BatchModeTransactionCoordinator txCoord = new BatchModeTransactionCoordinator();
            Mockito.when((Object)session.getTransactionCoordinator()).thenReturn((Object)txCoord);
            Mockito.when((Object)session.beginTransaction()).then(invocation -> {
                Transaction tx = txCoord.newTransaction();
                tx.begin();
                return tx;
            });
        } else if (this.jtaPlatform == null) {
            Connection connection = (Connection)Mockito.mock(Connection.class);
            JdbcConnectionAccess jdbcConnectionAccess = (JdbcConnectionAccess)Mockito.mock(JdbcConnectionAccess.class);
            try {
                Mockito.when((Object)jdbcConnectionAccess.obtainConnection()).thenReturn((Object)connection);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            JdbcSessionOwner jdbcSessionOwner = (JdbcSessionOwner)Mockito.mock(JdbcSessionOwner.class);
            Mockito.when((Object)jdbcSessionOwner.getJdbcConnectionAccess()).thenReturn((Object)jdbcConnectionAccess);
            SqlExceptionHelper sqlExceptionHelper = (SqlExceptionHelper)Mockito.mock(SqlExceptionHelper.class);
            JdbcServices jdbcServices = (JdbcServices)Mockito.mock(JdbcServices.class);
            Mockito.when((Object)jdbcServices.getSqlExceptionHelper()).thenReturn((Object)sqlExceptionHelper);
            ServiceRegistry serviceRegistry = (ServiceRegistry)Mockito.mock(ServiceRegistry.class);
            Mockito.when((Object)serviceRegistry.getService(JdbcServices.class)).thenReturn((Object)jdbcServices);
            JdbcSessionContext jdbcSessionContext = (JdbcSessionContext)Mockito.mock(JdbcSessionContext.class);
            Mockito.when((Object)jdbcSessionContext.getServiceRegistry()).thenReturn((Object)serviceRegistry);
            Mockito.when((Object)jdbcSessionOwner.getJdbcSessionContext()).thenReturn((Object)jdbcSessionContext);
            NonJtaTransactionCoordinator txOwner = (NonJtaTransactionCoordinator)Mockito.mock(NonJtaTransactionCoordinator.class);
            Mockito.when((Object)txOwner.getResourceLocalTransaction()).thenReturn((Object)new JdbcResourceTransactionMock());
            Mockito.when((Object)txOwner.getJdbcSessionOwner()).thenReturn((Object)jdbcSessionOwner);
            Mockito.when((Object)txOwner.isActive()).thenReturn((Object)true);
            TransactionCoordinator txCoord = JdbcResourceLocalTransactionCoordinatorBuilderImpl.INSTANCE.buildTransactionCoordinator((TransactionCoordinatorOwner)txOwner, null);
            Mockito.when((Object)session.getTransactionCoordinator()).thenReturn((Object)txCoord);
            Mockito.when((Object)session.beginTransaction()).then(invocation -> {
                TransactionImpl tx = new TransactionImpl(txCoord);
                tx.begin();
                return tx;
            });
        } else {
            throw new IllegalStateException("Unknown JtaPlatform: " + this.jtaPlatform);
        }
        return session;
    }

    protected abstract S getAccessStrategy(R var1);

    @Test
    public void testRemove() throws Exception {
        this.evictOrRemoveTest(false);
    }

    @Test
    public void testEvict() throws Exception {
        this.evictOrRemoveTest(true);
    }

    protected abstract R getRegion(NodeEnvironment var1);

    protected void waitForClusterToForm(Cache ... caches) {
        TestingUtil.blockUntilViewsReceived((int)10000, Arrays.asList(caches));
    }

    protected boolean isTransactional() {
        return this.transactional;
    }

    protected boolean isUsingInvalidation() {
        return this.invalidation;
    }

    protected boolean isSynchronous() {
        return this.synchronous;
    }

    protected void evictOrRemoveTest(boolean evict) throws Exception {
        Object KEY = this.generateNextKey();
        Assert.assertEquals((long)0L, (long)this.localRegion.getCache().size());
        Assert.assertEquals((long)0L, (long)this.remoteRegion.getCache().size());
        CountDownLatch localPutFromLoadLatch = this.expectRemotePutFromLoad(this.remoteRegion.getCache(), this.localRegion.getCache());
        CountDownLatch remotePutFromLoadLatch = this.expectRemotePutFromLoad(this.localRegion.getCache(), this.remoteRegion.getCache());
        SessionImplementor s1 = this.mockedSession();
        Assert.assertNull((String)"local is clean", (Object)this.localAccessStrategy.get(s1, KEY, s1.getTimestamp()));
        SessionImplementor s2 = this.mockedSession();
        Assert.assertNull((String)"remote is clean", (Object)this.remoteAccessStrategy.get(s2, KEY, s2.getTimestamp()));
        SessionImplementor s3 = this.mockedSession();
        this.localAccessStrategy.putFromLoad(s3, KEY, (Object)VALUE1, s3.getTimestamp(), (Object)1);
        SessionImplementor s5 = this.mockedSession();
        this.remoteAccessStrategy.putFromLoad(s5, KEY, (Object)VALUE1, s5.getTimestamp(), (Object)1);
        Assert.assertTrue((boolean)localPutFromLoadLatch.await(1L, TimeUnit.SECONDS));
        Assert.assertTrue((boolean)remotePutFromLoadLatch.await(1L, TimeUnit.SECONDS));
        SessionImplementor s4 = this.mockedSession();
        Assert.assertEquals((Object)VALUE1, (Object)this.localAccessStrategy.get(s4, KEY, s4.getTimestamp()));
        SessionImplementor s6 = this.mockedSession();
        Assert.assertEquals((Object)VALUE1, (Object)this.remoteAccessStrategy.get(s6, KEY, s6.getTimestamp()));
        CountDownLatch endInvalidationLatch = this.createEndInvalidationLatch(evict);
        SessionImplementor session = this.mockedSession();
        this.withTx(this.localEnvironment, session, () -> {
            if (evict) {
                this.localAccessStrategy.evict(KEY);
            } else {
                this.doRemove(this.localAccessStrategy, session, KEY);
            }
            return null;
        });
        SessionImplementor s7 = this.mockedSession();
        Assert.assertNull((Object)this.localAccessStrategy.get(s7, KEY, s7.getTimestamp()));
        SessionImplementor s8 = this.mockedSession();
        Assert.assertNull((Object)this.remoteAccessStrategy.get(s8, KEY, s8.getTimestamp()));
        Assert.assertTrue((boolean)endInvalidationLatch.await(1L, TimeUnit.SECONDS));
        Assert.assertEquals((long)0L, (long)this.localRegion.getCache().size());
        Assert.assertEquals((long)0L, (long)this.remoteRegion.getCache().size());
    }

    protected void doRemove(S strategy, SessionImplementor session, Object key) throws SystemException, RollbackException {
        SoftLock softLock = strategy.lockItem(session, key, null);
        strategy.remove(session, key);
        session.getTransactionCoordinator().getLocalSynchronizations().registerSynchronization((Synchronization)new TestSynchronization.UnlockItem((RegionAccessStrategy)strategy, session, key, softLock));
    }

    @Test
    public void testRemoveAll() throws Exception {
        this.evictOrRemoveAllTest(false);
    }

    @Test
    public void testEvictAll() throws Exception {
        this.evictOrRemoveAllTest(true);
    }

    protected void assertThreadsRanCleanly() {
        if (this.node1Failure != null) {
            throw this.node1Failure;
        }
        if (this.node2Failure != null) {
            throw this.node2Failure;
        }
        if (this.node1Exception != null) {
            this.log.error((Object)"node1 saw an exception", (Throwable)this.node1Exception);
            Assert.assertEquals((String)"node1 saw no exceptions", null, (Object)this.node1Exception);
        }
        if (this.node2Exception != null) {
            this.log.error((Object)"node2 saw an exception", (Throwable)this.node2Exception);
            Assert.assertEquals((String)"node2 saw no exceptions", null, (Object)this.node2Exception);
        }
    }

    protected abstract Object generateNextKey();

    protected void evictOrRemoveAllTest(boolean evict) throws Exception {
        Object KEY = this.generateNextKey();
        Assert.assertEquals((long)0L, (long)this.localRegion.getCache().size());
        Assert.assertEquals((long)0L, (long)this.remoteRegion.getCache().size());
        SessionImplementor s1 = this.mockedSession();
        Assert.assertNull((String)"local is clean", (Object)this.localAccessStrategy.get(s1, KEY, s1.getTimestamp()));
        SessionImplementor s2 = this.mockedSession();
        Assert.assertNull((String)"remote is clean", (Object)this.remoteAccessStrategy.get(s2, KEY, s2.getTimestamp()));
        CountDownLatch localPutFromLoadLatch = this.expectRemotePutFromLoad(this.remoteRegion.getCache(), this.localRegion.getCache());
        CountDownLatch remotePutFromLoadLatch = this.expectRemotePutFromLoad(this.localRegion.getCache(), this.remoteRegion.getCache());
        SessionImplementor s3 = this.mockedSession();
        this.localAccessStrategy.putFromLoad(s3, KEY, (Object)VALUE1, s3.getTimestamp(), (Object)1);
        SessionImplementor s5 = this.mockedSession();
        this.remoteAccessStrategy.putFromLoad(s5, KEY, (Object)VALUE1, s5.getTimestamp(), (Object)1);
        Assert.assertTrue((boolean)localPutFromLoadLatch.await(1L, TimeUnit.SECONDS));
        Assert.assertTrue((boolean)remotePutFromLoadLatch.await(1L, TimeUnit.SECONDS));
        SessionImplementor s4 = this.mockedSession();
        SessionImplementor s6 = this.mockedSession();
        Assert.assertEquals((Object)VALUE1, (Object)this.localAccessStrategy.get(s4, KEY, s4.getTimestamp()));
        Assert.assertEquals((Object)VALUE1, (Object)this.remoteAccessStrategy.get(s6, KEY, s6.getTimestamp()));
        CountDownLatch endInvalidationLatch = this.createEndInvalidationLatch(evict);
        this.withTx(this.localEnvironment, this.mockedSession(), () -> {
            if (evict) {
                this.localAccessStrategy.evictAll();
            } else {
                SoftLock softLock = this.localAccessStrategy.lockRegion();
                this.localAccessStrategy.removeAll();
                this.localAccessStrategy.unlockRegion(softLock);
            }
            return null;
        });
        SessionImplementor s7 = this.mockedSession();
        Assert.assertNull((Object)this.localAccessStrategy.get(s7, KEY, s7.getTimestamp()));
        Assert.assertEquals((long)0L, (long)this.localRegion.getCache().size());
        SessionImplementor s8 = this.mockedSession();
        Assert.assertNull((Object)this.remoteAccessStrategy.get(s8, KEY, s8.getTimestamp()));
        Assert.assertEquals((long)0L, (long)this.remoteRegion.getCache().size());
        Assert.assertTrue((boolean)endInvalidationLatch.await(1L, TimeUnit.SECONDS));
        TIME_SERVICE.advance(1L);
        CountDownLatch lastPutFromLoadLatch = this.expectRemotePutFromLoad(this.remoteRegion.getCache(), this.localRegion.getCache());
        SessionImplementor s9 = this.mockedSession();
        this.log.infof("Call remote strategy putFromLoad for key=%s and value=%s", KEY, (Object)VALUE1);
        Assert.assertTrue((boolean)this.remoteAccessStrategy.putFromLoad(s9, KEY, (Object)VALUE1, s9.getTimestamp(), (Object)1));
        SessionImplementor s10 = this.mockedSession();
        this.log.infof("Call remote strategy get for key=%s", KEY);
        Assert.assertEquals((Object)VALUE1, (Object)this.remoteAccessStrategy.get(s10, KEY, s10.getTimestamp()));
        Assert.assertTrue((boolean)lastPutFromLoadLatch.await(1L, TimeUnit.SECONDS));
        Assert.assertEquals((long)1L, (long)this.remoteRegion.getCache().size());
        SessionImplementor s11 = this.mockedSession();
        Assert.assertEquals((Object)(this.isUsingInvalidation() ? null : VALUE1), (Object)this.localAccessStrategy.get(s11, KEY, s11.getTimestamp()));
        SessionImplementor s12 = this.mockedSession();
        Assert.assertEquals((Object)VALUE1, (Object)this.remoteAccessStrategy.get(s12, KEY, s12.getTimestamp()));
    }

    private CountDownLatch createEndInvalidationLatch(boolean evict) {
        CountDownLatch endInvalidationLatch;
        if (this.invalidation && !evict) {
            endInvalidationLatch = new CountDownLatch(1);
            if (this.transactional) {
                PutFromLoadValidator originalValidator = PutFromLoadValidator.removeFromCache((AdvancedCache)this.remoteRegion.getCache());
                Assert.assertEquals(PutFromLoadValidator.class, originalValidator.getClass());
                PutFromLoadValidator mockValidator = (PutFromLoadValidator)Mockito.spy((Object)originalValidator);
                ((PutFromLoadValidator)Mockito.doAnswer(invocation -> {
                    try {
                        Object object = invocation.callRealMethod();
                        return object;
                    }
                    finally {
                        endInvalidationLatch.countDown();
                    }
                }).when((Object)mockValidator)).endInvalidatingKey(Matchers.any(), Matchers.any());
                PutFromLoadValidator.addToCache((AdvancedCache)this.remoteRegion.getCache(), (PutFromLoadValidator)mockValidator);
                this.cleanup.add(() -> {
                    PutFromLoadValidator.removeFromCache((AdvancedCache)this.remoteRegion.getCache());
                    PutFromLoadValidator.addToCache((AdvancedCache)this.remoteRegion.getCache(), (PutFromLoadValidator)originalValidator);
                });
            } else {
                ExpectingInterceptor.get(this.remoteRegion.getCache()).when((ctx, cmd) -> cmd instanceof InvalidateCommand).countDown(endInvalidationLatch);
                this.cleanup.add(() -> ExpectingInterceptor.cleanup(this.remoteRegion.getCache()));
            }
        } else {
            endInvalidationLatch = new CountDownLatch(0);
        }
        return endInvalidationLatch;
    }

    private CountDownLatch expectRemotePutFromLoad(AdvancedCache localCache, AdvancedCache remoteCache) {
        CountDownLatch putFromLoadLatch;
        if (!this.isUsingInvalidation()) {
            putFromLoadLatch = new CountDownLatch(1);
            ExpectingInterceptor.Condition remoteCondition = ExpectingInterceptor.get(remoteCache).when((ctx, cmd) -> !ctx.isOriginLocal() && cmd instanceof PutKeyValueCommand);
            ExpectingInterceptor.Condition localCondition = ExpectingInterceptor.get(localCache).whenFails((ctx, cmd) -> ctx.isOriginLocal() && cmd instanceof PutKeyValueCommand);
            remoteCondition.run(() -> {
                localCondition.cancel();
                putFromLoadLatch.countDown();
            });
            localCondition.run(() -> {
                remoteCondition.cancel();
                putFromLoadLatch.countDown();
            });
            this.cleanup.add(() -> ExpectingInterceptor.cleanup(localCache, remoteCache));
        } else {
            putFromLoadLatch = new CountDownLatch(0);
        }
        return putFromLoadLatch;
    }

    private static interface NonJtaTransactionCoordinator
    extends TransactionCoordinatorOwner,
    JdbcResourceTransactionAccess {
    }

    private static interface SessionMock
    extends Session,
    SessionImplementor {
    }
}

