/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.hibernate.cache.collection;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import org.hibernate.cache.spi.access.CollectionRegionAccessStrategy;
import org.hibernate.cache.spi.access.RegionAccessStrategy;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.spi.SessionImplementor;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.test.categories.Smoke;
import org.infinispan.hibernate.cache.access.AccessDelegate;
import org.infinispan.hibernate.cache.access.NonTxInvalidationCacheAccessDelegate;
import org.infinispan.hibernate.cache.access.PutFromLoadValidator;
import org.infinispan.hibernate.cache.access.TxInvalidationCacheAccessDelegate;
import org.infinispan.hibernate.cache.collection.CollectionRegionImpl;
import org.infinispan.test.hibernate.cache.AbstractRegionAccessStrategyTest;
import org.infinispan.test.hibernate.cache.NodeEnvironment;
import org.infinispan.test.hibernate.cache.util.TestSynchronization;
import org.infinispan.test.hibernate.cache.util.TestingKeyFactory;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Matchers;
import org.mockito.Mockito;

@Category(value={Smoke.class})
public class CollectionRegionAccessStrategyTest
extends AbstractRegionAccessStrategyTest<CollectionRegionImpl, CollectionRegionAccessStrategy> {
    protected static int testCount;

    @Override
    protected Object generateNextKey() {
        return TestingKeyFactory.generateCollectionCacheKey("KEY" + testCount++);
    }

    @Override
    protected CollectionRegionImpl getRegion(NodeEnvironment environment) {
        return environment.getCollectionRegion("test/com.foo.test", CACHE_DATA_DESCRIPTION);
    }

    @Override
    protected CollectionRegionAccessStrategy getAccessStrategy(CollectionRegionImpl region) {
        return region.buildAccessStrategy(this.accessType);
    }

    @Test
    public void testGetRegion() {
        Assert.assertEquals((String)"Correct region", (Object)this.localRegion, (Object)((CollectionRegionAccessStrategy)this.localAccessStrategy).getRegion());
    }

    @Test
    public void testPutFromLoadRemoveDoesNotProduceStaleData() throws Exception {
        if (!this.cacheMode.isInvalidation()) {
            return;
        }
        CountDownLatch pferLatch = new CountDownLatch(1);
        CountDownLatch removeLatch = new CountDownLatch(1);
        PutFromLoadValidator originalValidator = PutFromLoadValidator.removeFromCache((AdvancedCache)((CollectionRegionImpl)this.localRegion).getCache());
        PutFromLoadValidator mockValidator = (PutFromLoadValidator)Mockito.spy((Object)originalValidator);
        ((PutFromLoadValidator)Mockito.doAnswer(invocation -> {
            try {
                Object object = invocation.callRealMethod();
                return object;
            }
            finally {
                try {
                    removeLatch.countDown();
                    Assert.assertFalse((boolean)pferLatch.await(2L, TimeUnit.SECONDS));
                }
                catch (InterruptedException e) {
                    this.log.debug((Object)"Interrupted");
                    Thread.currentThread().interrupt();
                }
                catch (Exception e) {
                    this.log.error((Object)"Error", (Throwable)e);
                    throw new RuntimeException("Error", e);
                }
            }
        }).when((Object)mockValidator)).acquirePutFromLoadLock((SessionImplementor)Matchers.any(), Matchers.any(), Matchers.anyLong());
        PutFromLoadValidator.addToCache((AdvancedCache)((CollectionRegionImpl)this.localRegion).getCache(), (PutFromLoadValidator)mockValidator);
        this.cleanup.add(() -> {
            PutFromLoadValidator.removeFromCache((AdvancedCache)((CollectionRegionImpl)this.localRegion).getCache());
            PutFromLoadValidator.addToCache((AdvancedCache)((CollectionRegionImpl)this.localRegion).getCache(), (PutFromLoadValidator)originalValidator);
        });
        TxInvalidationCacheAccessDelegate delegate = ((CollectionRegionImpl)this.localRegion).getCache().getCacheConfiguration().transaction().transactionMode().isTransactional() ? new TxInvalidationCacheAccessDelegate(this.localRegion, mockValidator) : new NonTxInvalidationCacheAccessDelegate(this.localRegion, mockValidator);
        ExecutorService executorService = Executors.newCachedThreadPool();
        this.cleanup.add(() -> executorService.shutdownNow());
        String KEY = "k1";
        Future<Void> pferFuture = executorService.submit(() -> this.lambda$testPutFromLoadRemoveDoesNotProduceStaleData$3((AccessDelegate)delegate));
        Future<Void> removeFuture = executorService.submit(() -> this.lambda$testPutFromLoadRemoveDoesNotProduceStaleData$5(removeLatch, (AccessDelegate)delegate, pferLatch));
        pferFuture.get();
        removeFuture.get();
        Assert.assertFalse((boolean)((CollectionRegionImpl)this.localRegion).getCache().containsKey((Object)"k1"));
        Assert.assertFalse((boolean)((CollectionRegionImpl)this.remoteRegion).getCache().containsKey((Object)"k1"));
    }

    @Test
    public void testPutFromLoad() throws Exception {
        this.putFromLoadTest(false, true);
    }

    @Test
    public void testPutFromLoadMinimal() throws Exception {
        this.putFromLoadTest(true, true);
    }

    @Override
    protected void doUpdate(CollectionRegionAccessStrategy strategy, SessionImplementor session, Object key, Object value, Object version) throws RollbackException, SystemException {
        SoftLock softLock = strategy.lockItem(session, key, version);
        strategy.remove(session, key);
        session.getTransactionCoordinator().getLocalSynchronizations().registerSynchronization((Synchronization)new TestSynchronization.UnlockItem((RegionAccessStrategy)strategy, session, key, softLock));
    }

    private /* synthetic */ Void lambda$testPutFromLoadRemoveDoesNotProduceStaleData$5(CountDownLatch removeLatch, AccessDelegate delegate, CountDownLatch pferLatch) throws Exception {
        removeLatch.await();
        SessionImplementor session = this.mockedSession();
        this.withTx(this.localEnvironment, session, () -> {
            delegate.remove(session, (Object)"k1");
            return null;
        });
        pferLatch.countDown();
        return null;
    }

    private /* synthetic */ Void lambda$testPutFromLoadRemoveDoesNotProduceStaleData$3(AccessDelegate delegate) throws Exception {
        SessionImplementor session = this.mockedSession();
        delegate.putFromLoad(session, (Object)"k1", (Object)"v1", session.getTimestamp(), null);
        return null;
    }
}

