/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.hibernate.cache.functional;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.hibernate.testing.TestForIssue;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.distribution.BlockingInterceptor;
import org.infinispan.hibernate.cache.util.Tombstone;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.test.hibernate.cache.functional.AbstractNonInvalidationTest;
import org.infinispan.test.hibernate.cache.functional.entities.Item;
import org.junit.Assert;
import org.junit.Test;

public class TombstoneTest
extends AbstractNonInvalidationTest {
    @Override
    public List<Object[]> getParameters() {
        return Arrays.asList(READ_WRITE_REPLICATED, READ_WRITE_DISTRIBUTED);
    }

    @Test
    public void testTombstoneExpiration() throws Exception {
        CyclicBarrier loadBarrier = new CyclicBarrier(2);
        CountDownLatch flushLatch = new CountDownLatch(2);
        CountDownLatch commitLatch = new CountDownLatch(1);
        Future<Boolean> first = this.removeFlushWait(this.itemId, loadBarrier, null, flushLatch, commitLatch);
        Future<Boolean> second = this.removeFlushWait(this.itemId, loadBarrier, null, flushLatch, commitLatch);
        this.awaitOrThrow(flushLatch);
        this.assertTombstone(1);
        commitLatch.countDown();
        first.get(2000L, TimeUnit.SECONDS);
        second.get(2000L, TimeUnit.SECONDS);
        this.assertTombstone(1);
        TIME_SERVICE.advance(this.timeout + 1L);
        this.assertEmptyCache();
    }

    @Test
    public void testTwoUpdates1() throws Exception {
        CyclicBarrier loadBarrier = new CyclicBarrier(2);
        CountDownLatch preFlushLatch = new CountDownLatch(1);
        CountDownLatch flushLatch1 = new CountDownLatch(1);
        CountDownLatch flushLatch2 = new CountDownLatch(1);
        CountDownLatch commitLatch1 = new CountDownLatch(1);
        CountDownLatch commitLatch2 = new CountDownLatch(1);
        Future<Boolean> update1 = this.updateFlushWait(this.itemId, loadBarrier, null, flushLatch1, commitLatch1);
        Future<Boolean> update2 = this.updateFlushWait(this.itemId, loadBarrier, preFlushLatch, flushLatch2, commitLatch2);
        this.awaitOrThrow(flushLatch1);
        this.assertTombstone(1);
        preFlushLatch.countDown();
        this.awaitOrThrow(flushLatch2);
        this.assertTombstone(1);
        commitLatch2.countDown();
        Assert.assertFalse((boolean)update2.get(2000L, TimeUnit.SECONDS));
        this.assertTombstone(1);
        commitLatch1.countDown();
        Assert.assertTrue((boolean)update1.get(2000L, TimeUnit.SECONDS));
        this.assertSingleCacheEntry();
    }

    @Test
    public void testTwoUpdates2() throws Exception {
        CyclicBarrier loadBarrier = new CyclicBarrier(2);
        CountDownLatch preFlushLatch = new CountDownLatch(1);
        CountDownLatch flushLatch1 = new CountDownLatch(1);
        CountDownLatch flushLatch2 = new CountDownLatch(1);
        CountDownLatch commitLatch1 = new CountDownLatch(1);
        CountDownLatch commitLatch2 = new CountDownLatch(1);
        Future<Boolean> update1 = this.updateFlushWait(this.itemId, loadBarrier, null, flushLatch1, commitLatch1);
        Future<Boolean> update2 = this.updateFlushWait(this.itemId, loadBarrier, preFlushLatch, flushLatch2, commitLatch2);
        this.awaitOrThrow(flushLatch1);
        this.assertCacheContains(Tombstone.class);
        preFlushLatch.countDown();
        this.awaitOrThrow(flushLatch2);
        this.assertTombstone(1);
        commitLatch1.countDown();
        Assert.assertTrue((boolean)update1.get(2000L, TimeUnit.SECONDS));
        this.assertSingleCacheEntry();
        commitLatch2.countDown();
        Assert.assertFalse((boolean)update2.get(2000L, TimeUnit.SECONDS));
        this.assertSingleCacheEntry();
        TIME_SERVICE.advance(this.TIMEOUT + 1L);
        this.assertSingleCacheEntry();
    }

    @Test
    public void testRemoveUpdateExpiration() throws Exception {
        CyclicBarrier loadBarrier = new CyclicBarrier(2);
        CountDownLatch preFlushLatch = new CountDownLatch(1);
        CountDownLatch flushLatch = new CountDownLatch(1);
        CountDownLatch commitLatch = new CountDownLatch(1);
        Future<Boolean> first = this.removeFlushWait(this.itemId, loadBarrier, null, flushLatch, commitLatch);
        Future<Boolean> second = this.updateFlushWait(this.itemId, loadBarrier, preFlushLatch, null, commitLatch);
        this.awaitOrThrow(flushLatch);
        this.assertTombstone(1);
        preFlushLatch.countDown();
        commitLatch.countDown();
        first.get(2000L, TimeUnit.SECONDS);
        second.get(2000L, TimeUnit.SECONDS);
        this.assertTombstone(1);
        TIME_SERVICE.advance(this.timeout + 1L);
        this.assertEmptyCache();
    }

    @Test
    public void testUpdateRemoveExpiration() throws Exception {
        CyclicBarrier loadBarrier = new CyclicBarrier(2);
        CountDownLatch preFlushLatch = new CountDownLatch(1);
        CountDownLatch flushLatch = new CountDownLatch(1);
        CountDownLatch commitLatch = new CountDownLatch(1);
        Future<Boolean> first = this.updateFlushWait(this.itemId, loadBarrier, null, flushLatch, commitLatch);
        Future<Boolean> second = this.removeFlushWait(this.itemId, loadBarrier, preFlushLatch, null, commitLatch);
        this.awaitOrThrow(flushLatch);
        this.assertTombstone(1);
        preFlushLatch.countDown();
        commitLatch.countDown();
        first.get(2000L, TimeUnit.SECONDS);
        boolean removeSucceeded = second.get(2000L, TimeUnit.SECONDS);
        if (removeSucceeded) {
            this.assertCacheContains(Tombstone.class);
            TIME_SERVICE.advance(this.timeout + 1L);
            this.assertEmptyCache();
        } else {
            this.assertSingleCacheEntry();
            TIME_SERVICE.advance(this.timeout + 1L);
            this.assertSingleCacheEntry();
        }
    }

    @Test
    public void testUpdateEvictExpiration() throws Exception {
        CyclicBarrier loadBarrier = new CyclicBarrier(2);
        CountDownLatch preEvictLatch = new CountDownLatch(1);
        CountDownLatch postEvictLatch = new CountDownLatch(1);
        CountDownLatch flushLatch = new CountDownLatch(1);
        CountDownLatch commitLatch = new CountDownLatch(1);
        Future<Boolean> first = this.updateFlushWait(this.itemId, loadBarrier, null, flushLatch, commitLatch);
        Future<Boolean> second = this.evictWait(this.itemId, loadBarrier, preEvictLatch, postEvictLatch);
        this.awaitOrThrow(flushLatch);
        this.assertTombstone(1);
        preEvictLatch.countDown();
        this.awaitOrThrow(postEvictLatch);
        this.assertTombstone(1);
        commitLatch.countDown();
        first.get(2000L, TimeUnit.SECONDS);
        second.get(2000L, TimeUnit.SECONDS);
        this.assertSingleCacheEntry();
        TIME_SERVICE.advance(this.timeout + 1L);
        this.assertSingleCacheEntry();
    }

    @Test
    public void testEvictUpdate() throws Exception {
        CyclicBarrier loadBarrier = new CyclicBarrier(2);
        CountDownLatch preFlushLatch = new CountDownLatch(1);
        CountDownLatch postEvictLatch = new CountDownLatch(1);
        CountDownLatch flushLatch = new CountDownLatch(1);
        CountDownLatch commitLatch = new CountDownLatch(1);
        Future<Boolean> first = this.evictWait(this.itemId, loadBarrier, null, postEvictLatch);
        Future<Boolean> second = this.updateFlushWait(this.itemId, loadBarrier, preFlushLatch, flushLatch, commitLatch);
        this.awaitOrThrow(postEvictLatch);
        this.assertEmptyCache();
        preFlushLatch.countDown();
        this.awaitOrThrow(flushLatch);
        this.assertTombstone(1);
        commitLatch.countDown();
        first.get(2000L, TimeUnit.SECONDS);
        second.get(2000L, TimeUnit.SECONDS);
        this.assertSingleCacheEntry();
        TIME_SERVICE.advance(this.timeout + 1L);
        this.assertSingleCacheEntry();
    }

    @Test
    public void testEvictUpdate2() throws Exception {
        CountDownLatch flushLatch = new CountDownLatch(1);
        CountDownLatch commitLatch = new CountDownLatch(1);
        this.sessionFactory().getCache().evictEntity(Item.class, (Serializable)Long.valueOf(this.itemId));
        this.assertEmptyCache();
        TIME_SERVICE.advance(1L);
        Future<Boolean> update = this.updateFlushWait(this.itemId, null, null, flushLatch, commitLatch);
        this.awaitOrThrow(flushLatch);
        this.assertTombstone(1);
        commitLatch.countDown();
        update.get(2000L, TimeUnit.SECONDS);
        this.assertSingleCacheEntry();
        TIME_SERVICE.advance(this.timeout + 2L);
        this.assertSingleCacheEntry();
    }

    @Test
    public void testEvictPutFromLoad() throws Exception {
        this.sessionFactory().getCache().evictEntity(Item.class, (Serializable)Long.valueOf(this.itemId));
        this.assertEmptyCache();
        TIME_SERVICE.advance(1L);
        this.assertItemDescription("Original item");
        this.assertSingleCacheEntry();
        TIME_SERVICE.advance(this.timeout + 2L);
        this.assertSingleCacheEntry();
    }

    protected void assertItemDescription(String expected) throws Exception {
        Assert.assertEquals((Object)expected, (Object)this.withTxSessionApply(s -> ((Item)s.load(Item.class, (Serializable)Long.valueOf(this.itemId))).getDescription()));
    }

    @Test
    public void testPutFromLoadDuringUpdate() throws Exception {
        CountDownLatch flushLatch = new CountDownLatch(1);
        CountDownLatch commitLatch = new CountDownLatch(1);
        CyclicBarrier putFromLoadBarrier = new CyclicBarrier(2);
        Future<?> putFromLoad = this.blockedPutFromLoad(putFromLoadBarrier);
        Future<Boolean> update = this.updateFlushWait(this.itemId, null, null, flushLatch, commitLatch);
        this.awaitOrThrow(flushLatch);
        this.assertTombstone(1);
        this.unblockPutFromLoad(putFromLoadBarrier, putFromLoad);
        commitLatch.countDown();
        update.get(2000L, TimeUnit.SECONDS);
        this.assertSingleCacheEntry();
        this.assertItemDescription("Updated item");
    }

    @TestForIssue(jiraKey="HHH-11323")
    @Test
    public void testEvictPutFromLoadDuringUpdate() throws Exception {
        CountDownLatch flushLatch = new CountDownLatch(1);
        CountDownLatch commitLatch = new CountDownLatch(1);
        CyclicBarrier putFromLoadBarrier = new CyclicBarrier(2);
        Future<?> putFromLoad = this.blockedPutFromLoad(putFromLoadBarrier);
        Future<Boolean> update = this.updateFlushWait(this.itemId, null, null, flushLatch, commitLatch);
        this.awaitOrThrow(flushLatch);
        this.sessionFactory().getCache().evictEntity(Item.class, (Serializable)Long.valueOf(this.itemId));
        commitLatch.countDown();
        update.get(2000L, TimeUnit.SECONDS);
        this.unblockPutFromLoad(putFromLoadBarrier, putFromLoad);
        this.assertItemDescription("Updated item");
    }

    private Future<?> blockedPutFromLoad(CyclicBarrier putFromLoadBarrier) throws InterruptedException, BrokenBarrierException, TimeoutException {
        BlockingInterceptor blockingInterceptor = new BlockingInterceptor(putFromLoadBarrier, PutKeyValueCommand.class, false, true);
        this.entityCache.getAsyncInterceptorChain().addInterceptor((AsyncInterceptor)blockingInterceptor, 0);
        this.cleanup.add(() -> this.entityCache.removeInterceptor(BlockingInterceptor.class));
        Future<Object> putFromLoad = this.executor.submit(() -> this.withTxSessionApply(s -> {
            Assert.assertEquals((Object)"Original item", (Object)((Item)s.load(Item.class, (Serializable)Long.valueOf(this.itemId))).getDescription());
            return null;
        }));
        putFromLoadBarrier.await(2000L, TimeUnit.SECONDS);
        blockingInterceptor.suspend(true);
        return putFromLoad;
    }

    private void unblockPutFromLoad(CyclicBarrier putFromLoadBarrier, Future<?> putFromLoad) throws InterruptedException, BrokenBarrierException, TimeoutException, ExecutionException {
        putFromLoadBarrier.await(2000L, TimeUnit.SECONDS);
        putFromLoad.get(2000L, TimeUnit.SECONDS);
    }

    private void assertTombstone(int expectedSize) {
        Tombstone tombstone = this.assertCacheContains(Tombstone.class);
        Assert.assertEquals((String)("Tombstone is " + tombstone), (long)expectedSize, (long)tombstone.size());
    }
}

