/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.hibernate.cache;

import java.io.Serializable;
import java.util.Iterator;
import org.hibernate.SessionFactory;
import org.hibernate.cache.internal.DefaultCacheKeysFactory;
import org.hibernate.cache.internal.SimpleCacheKeysFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.spi.CacheImplementor;
import org.hibernate.testing.junit4.BaseUnitTestCase;
import org.infinispan.Cache;
import org.infinispan.test.hibernate.cache.functional.entities.Name;
import org.infinispan.test.hibernate.cache.functional.entities.Person;
import org.infinispan.test.hibernate.cache.util.InfinispanTestingSetup;
import org.infinispan.test.hibernate.cache.util.TestInfinispanRegionFactory;
import org.infinispan.test.hibernate.cache.util.TxUtil;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class CacheKeysFactoryTest
extends BaseUnitTestCase {
    @Rule
    public InfinispanTestingSetup infinispanTestIdentifier = new InfinispanTestingSetup();

    private SessionFactory getSessionFactory(String cacheKeysFactory) {
        Configuration configuration = new Configuration().setProperty("hibernate.cache.use_second_level_cache", "true").setProperty("hibernate.cache.region.factory_class", TestInfinispanRegionFactory.class.getName()).setProperty("hibernate.cache.default_cache_concurrency_strategy", "transactional").setProperty("javax.persistence.sharedCache.mode", "ALL").setProperty("hibernate.hbm2ddl.auto", "create-drop");
        if (cacheKeysFactory != null) {
            configuration.setProperty("hibernate.cache.keys_factory", cacheKeysFactory);
        }
        configuration.addAnnotatedClass(Person.class);
        return configuration.buildSessionFactory();
    }

    @Test
    public void testNotSet() throws Exception {
        this.test(null, "CacheKeyImplementation");
    }

    @Test
    public void testDefault() throws Exception {
        this.test("default", "CacheKeyImplementation");
    }

    @Test
    public void testDefaultClass() throws Exception {
        this.test(DefaultCacheKeysFactory.class.getName(), "CacheKeyImplementation");
    }

    @Test
    public void testSimple() throws Exception {
        this.test("simple", Name.class.getSimpleName());
    }

    @Test
    public void testSimpleClass() throws Exception {
        this.test(SimpleCacheKeysFactory.class.getName(), Name.class.getSimpleName());
    }

    private void test(String cacheKeysFactory, String keyClassName) throws Exception {
        SessionFactory sessionFactory = this.getSessionFactory(cacheKeysFactory);
        TxUtil.withTxSession(false, sessionFactory, s -> {
            Person person = new Person("John", "Black", 39);
            s.persist((Object)person);
        });
        TestInfinispanRegionFactory regionFactory = (TestInfinispanRegionFactory)((CacheImplementor)sessionFactory.getCache()).getRegionFactory();
        Cache cache = regionFactory.getCacheManager().getCache(Person.class.getName());
        Iterator iterator = cache.getAdvancedCache().getDataContainer().keySet().iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        Object key = iterator.next();
        Assert.assertEquals((Object)keyClassName, (Object)key.getClass().getSimpleName());
        TxUtil.withTxSession(false, sessionFactory, s -> {
            Person person = (Person)s.load(Person.class, (Serializable)new Name("John", "Black"));
            Assert.assertEquals((long)39L, (long)person.getAge());
        });
    }
}

