/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.hibernate.cache;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.SharedSessionContract;
import org.hibernate.Transaction;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cache.spi.GeneralDataRegion;
import org.hibernate.cache.spi.Region;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.service.ServiceRegistry;
import org.infinispan.AdvancedCache;
import org.infinispan.CacheSet;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.hibernate.cache.InfinispanRegionFactory;
import org.infinispan.hibernate.cache.impl.BaseGeneralDataRegion;
import org.infinispan.hibernate.cache.impl.BaseRegion;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.hibernate.cache.AbstractRegionImplTest;
import org.infinispan.test.hibernate.cache.util.CacheTestUtil;
import org.infinispan.test.hibernate.cache.util.ExpectingInterceptor;
import org.infinispan.test.hibernate.cache.util.TestInfinispanRegionFactory;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractGeneralDataRegionTest
extends AbstractRegionImplTest {
    protected static final String KEY = "Key";
    protected static final String VALUE1 = "value1";
    protected static final String VALUE2 = "value2";
    protected static final String VALUE3 = "value3";

    @Override
    public List<Object[]> getCacheModeParameters() {
        return Arrays.asList(new Object[][]{{CacheMode.INVALIDATION_SYNC, AccessType.TRANSACTIONAL}});
    }

    @Override
    protected void putInRegion(Region region, Object key, Object value) {
        ((GeneralDataRegion)region).put(null, key, value);
    }

    @Override
    protected void removeFromRegion(Region region, Object key) {
        ((GeneralDataRegion)region).evict(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void withSessionFactoriesAndRegions(int num, SFRConsumer consumer) throws Exception {
        StandardServiceRegistryBuilder ssrb = this.createStandardServiceRegistryBuilder().applySetting("hibernate.cache.region.factory_class", (Object)TestInfinispanRegionFactory.class.getName());
        Properties properties = CacheTestUtil.toProperties(ssrb.getSettings());
        ArrayList<StandardServiceRegistry> registries = new ArrayList<StandardServiceRegistry>();
        ArrayList<SessionFactory> sessionFactories = new ArrayList<SessionFactory>();
        ArrayList<GeneralDataRegion> regions = new ArrayList<GeneralDataRegion>();
        for (int i = 0; i < num; ++i) {
            StandardServiceRegistry registry = ssrb.build();
            registries.add(registry);
            SessionFactory sessionFactory = new MetadataSources((ServiceRegistry)registry).buildMetadata().buildSessionFactory();
            sessionFactories.add(sessionFactory);
            InfinispanRegionFactory regionFactory = (InfinispanRegionFactory)registry.getService(RegionFactory.class);
            GeneralDataRegion region = (GeneralDataRegion)this.createRegion(regionFactory, this.getStandardRegionName("test"), properties, null);
            regions.add(region);
        }
        this.waitForClusterToForm(regions);
        try {
            consumer.accept(sessionFactories, regions);
        }
        finally {
            for (SessionFactory sessionFactory : sessionFactories) {
                sessionFactory.close();
            }
            for (StandardServiceRegistry registry : registries) {
                StandardServiceRegistryBuilder.destroy((ServiceRegistry)registry);
            }
        }
    }

    private void waitForClusterToForm(List<GeneralDataRegion> regions) {
        List caches = regions.stream().map(r -> ((BaseRegion)r).getCache()).collect(Collectors.toList());
        TestingUtil.blockUntilViewsReceived((int)20000, caches);
        TestingUtil.waitForNoRebalance(caches);
    }

    @Test
    public void testEvict() throws Exception {
        this.withSessionFactoriesAndRegions(2, (sessionFactories, regions) -> {
            GeneralDataRegion localRegion = (GeneralDataRegion)regions.get(0);
            GeneralDataRegion remoteRegion = (GeneralDataRegion)regions.get(1);
            SessionImplementor localSession = (SessionImplementor)((SessionFactory)sessionFactories.get(0)).openSession();
            SessionImplementor remoteSession = (SessionImplementor)((SessionFactory)sessionFactories.get(1)).openSession();
            AdvancedCache localCache = ((BaseRegion)localRegion).getCache();
            AdvancedCache remoteCache = ((BaseRegion)remoteRegion).getCache();
            try {
                Assert.assertNull((String)"local is clean", (Object)localRegion.get(localSession, (Object)KEY));
                Assert.assertNull((String)"remote is clean", (Object)remoteRegion.get(remoteSession, (Object)KEY));
                boolean isLocalNodeBackupOwner = localCache.getDistributionManager().locate((Object)KEY).indexOf(localCache.getCacheManager().getAddress()) > 0;
                CountDownLatch insertLatch = new CountDownLatch(isLocalNodeBackupOwner ? 3 : 2);
                ExpectingInterceptor.get(localCache).when((ctx, cmd) -> cmd instanceof PutKeyValueCommand).countDown(insertLatch);
                ExpectingInterceptor.get(remoteCache).when((ctx, cmd) -> cmd instanceof PutKeyValueCommand).countDown(insertLatch);
                Transaction tx = ((SharedSessionContract)localSession).getTransaction();
                tx.begin();
                try {
                    localRegion.put(localSession, (Object)KEY, (Object)VALUE1);
                    tx.commit();
                }
                catch (Exception e) {
                    tx.rollback();
                    throw e;
                }
                Assert.assertTrue((boolean)insertLatch.await(2L, TimeUnit.SECONDS));
                Assert.assertEquals((Object)VALUE1, (Object)localRegion.get(localSession, (Object)KEY));
                Assert.assertEquals((Object)VALUE1, (Object)remoteRegion.get(remoteSession, (Object)KEY));
                CountDownLatch removeLatch = new CountDownLatch(isLocalNodeBackupOwner ? 3 : 2);
                ExpectingInterceptor.get(localCache).when((ctx, cmd) -> cmd instanceof RemoveCommand).countDown(removeLatch);
                ExpectingInterceptor.get(remoteCache).when((ctx, cmd) -> cmd instanceof RemoveCommand).countDown(removeLatch);
                this.regionEvict(localRegion);
                Assert.assertTrue((boolean)removeLatch.await(2L, TimeUnit.SECONDS));
                Assert.assertEquals(null, (Object)localRegion.get(localSession, (Object)KEY));
                Assert.assertEquals(null, (Object)remoteRegion.get(remoteSession, (Object)KEY));
            }
            catch (Throwable throwable) {
                ((Session)localSession).close();
                ((Session)remoteSession).close();
                ExpectingInterceptor.cleanup(localCache, remoteCache);
                throw throwable;
            }
            ((Session)localSession).close();
            ((Session)remoteSession).close();
            ExpectingInterceptor.cleanup(localCache, remoteCache);
        });
    }

    protected void regionEvict(GeneralDataRegion region) throws Exception {
        region.evict((Object)KEY);
    }

    protected abstract String getStandardRegionName(String var1);

    public void testEvictAll() throws Exception {
        this.withSessionFactoriesAndRegions(2, (sessionFactories, regions) -> {
            GeneralDataRegion localRegion = (GeneralDataRegion)regions.get(0);
            GeneralDataRegion remoteRegion = (GeneralDataRegion)regions.get(1);
            AdvancedCache localCache = ((BaseGeneralDataRegion)localRegion).getCache();
            AdvancedCache remoteCache = ((BaseGeneralDataRegion)remoteRegion).getCache();
            SessionImplementor localSession = (SessionImplementor)((SessionFactory)sessionFactories.get(0)).openSession();
            SessionImplementor remoteSession = (SessionImplementor)((SessionFactory)sessionFactories.get(1)).openSession();
            try {
                CacheSet localKeys = localCache.keySet();
                Assert.assertEquals((String)("No valid children in " + localKeys), (long)0L, (long)localKeys.size());
                CacheSet remoteKeys = remoteCache.keySet();
                Assert.assertEquals((String)("No valid children in " + remoteKeys), (long)0L, (long)remoteKeys.size());
                Assert.assertNull((String)"local is clean", (Object)localRegion.get(null, (Object)KEY));
                Assert.assertNull((String)"remote is clean", (Object)remoteRegion.get(null, (Object)KEY));
                localRegion.put(localSession, (Object)KEY, (Object)VALUE1);
                Assert.assertEquals((Object)VALUE1, (Object)localRegion.get(null, (Object)KEY));
                remoteRegion.put(remoteSession, (Object)KEY, (Object)VALUE1);
                Assert.assertEquals((Object)VALUE1, (Object)remoteRegion.get(null, (Object)KEY));
                localRegion.evictAll();
                Assert.assertNull((Object)localRegion.get(null, (Object)KEY));
                localKeys = localCache.keySet();
                Assert.assertEquals((String)("No valid children in " + localKeys), (long)0L, (long)localKeys.size());
                Assert.assertEquals(null, (Object)remoteRegion.get(null, (Object)KEY));
                remoteKeys = remoteCache.keySet();
                Assert.assertEquals((String)("No valid children in " + remoteKeys), (long)0L, (long)remoteKeys.size());
                Assert.assertEquals((String)"local is clean", null, (Object)localRegion.get(null, (Object)KEY));
                Assert.assertEquals((String)"remote is clean", null, (Object)remoteRegion.get(null, (Object)KEY));
            }
            finally {
                ((Session)localSession).close();
                ((Session)remoteSession).close();
            }
        });
    }

    protected static interface SFRConsumer {
        public void accept(List<SessionFactory> var1, List<GeneralDataRegion> var2) throws Exception;
    }
}

