/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.hibernate.cache;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.hibernate.cache.internal.DefaultCacheKeysFactory;
import org.hibernate.cache.internal.SimpleCacheKeysFactory;
import org.hibernate.cache.spi.CacheKeysFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.testing.TestForIssue;
import org.hibernate.testing.junit4.BaseUnitTestCase;
import org.infinispan.test.hibernate.cache.functional.entities.PK;
import org.infinispan.test.hibernate.cache.functional.entities.WithEmbeddedId;
import org.infinispan.test.hibernate.cache.functional.entities.WithSimpleId;
import org.infinispan.test.hibernate.cache.util.InfinispanTestingSetup;
import org.infinispan.test.hibernate.cache.util.TestInfinispanRegionFactory;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class CacheKeySerializationTest
extends BaseUnitTestCase {
    @Rule
    public InfinispanTestingSetup infinispanTestIdentifier = new InfinispanTestingSetup();

    private SessionFactoryImplementor getSessionFactory(String cacheKeysFactory) {
        Configuration configuration = new Configuration().setProperty("hibernate.cache.use_second_level_cache", "true").setProperty("hibernate.cache.region.factory_class", TestInfinispanRegionFactory.class.getName()).setProperty("hibernate.cache.default_cache_concurrency_strategy", "transactional").setProperty("javax.persistence.sharedCache.mode", "ALL").setProperty("hibernate.hbm2ddl.auto", "create-drop");
        if (cacheKeysFactory != null) {
            configuration.setProperty("hibernate.cache.keys_factory", cacheKeysFactory);
        }
        configuration.addAnnotatedClass(WithSimpleId.class);
        configuration.addAnnotatedClass(WithEmbeddedId.class);
        return (SessionFactoryImplementor)configuration.buildSessionFactory();
    }

    @Test
    @TestForIssue(jiraKey="HHH-11202")
    public void testSimpleCacheKeySimpleId() throws Exception {
        this.testId(SimpleCacheKeysFactory.INSTANCE, WithSimpleId.class.getName(), 1L);
    }

    @Test
    @TestForIssue(jiraKey="HHH-11202")
    public void testSimpleCacheKeyEmbeddedId() throws Exception {
        this.testId(SimpleCacheKeysFactory.INSTANCE, WithEmbeddedId.class.getName(), new PK(1L));
    }

    @Test
    @TestForIssue(jiraKey="HHH-11202")
    public void testDefaultCacheKeySimpleId() throws Exception {
        this.testId((CacheKeysFactory)DefaultCacheKeysFactory.INSTANCE, WithSimpleId.class.getName(), 1L);
    }

    @Test
    @TestForIssue(jiraKey="HHH-11202")
    public void testDefaultCacheKeyEmbeddedId() throws Exception {
        this.testId((CacheKeysFactory)DefaultCacheKeysFactory.INSTANCE, WithEmbeddedId.class.getName(), new PK(1L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testId(CacheKeysFactory cacheKeysFactory, String entityName, Object id) throws Exception {
        SessionFactoryImplementor sessionFactory = this.getSessionFactory(cacheKeysFactory.getClass().getName());
        EntityPersister persister = sessionFactory.getEntityPersister(entityName);
        Object key = cacheKeysFactory.createEntityKey(id, persister, sessionFactory, null);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(key);
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray()));
        Object keyClone = ois.readObject();
        try {
            Assert.assertEquals((Object)key, (Object)keyClone);
            Assert.assertEquals((Object)keyClone, (Object)key);
            Assert.assertEquals((long)key.hashCode(), (long)keyClone.hashCode());
            Object idClone = cacheKeysFactory.getEntityId(keyClone);
            Assert.assertEquals((long)id.hashCode(), (long)idClone.hashCode());
            Assert.assertEquals((Object)id, (Object)idClone);
            Assert.assertEquals((Object)idClone, (Object)id);
            Assert.assertTrue((boolean)persister.getIdentifierType().isEqual(id, idClone, sessionFactory));
            Assert.assertTrue((boolean)persister.getIdentifierType().isEqual(idClone, id, sessionFactory));
            sessionFactory.close();
        }
        finally {
            sessionFactory.close();
        }
    }
}

