/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.hibernate.cache;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.service.ServiceRegistry;
import org.infinispan.hibernate.cache.InfinispanRegionFactory;
import org.infinispan.hibernate.cache.collection.CollectionRegionImpl;
import org.infinispan.hibernate.cache.entity.EntityRegionImpl;
import org.infinispan.test.hibernate.cache.util.CacheTestUtil;

public class NodeEnvironment {
    private final StandardServiceRegistryBuilder ssrb;
    private final Properties properties;
    private StandardServiceRegistry serviceRegistry;
    private InfinispanRegionFactory regionFactory;
    private Map<String, EntityRegionImpl> entityRegionMap;
    private Map<String, CollectionRegionImpl> collectionRegionMap;

    public NodeEnvironment(StandardServiceRegistryBuilder ssrb) {
        this.ssrb = ssrb;
        this.properties = CacheTestUtil.toProperties(ssrb.getSettings());
    }

    public StandardServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    public EntityRegionImpl getEntityRegion(String name, CacheDataDescription cacheDataDescription) {
        if (this.entityRegionMap == null) {
            this.entityRegionMap = new HashMap<String, EntityRegionImpl>();
            return this.buildAndStoreEntityRegion(name, cacheDataDescription);
        }
        EntityRegionImpl region = this.entityRegionMap.get(name);
        if (region == null) {
            region = this.buildAndStoreEntityRegion(name, cacheDataDescription);
        }
        return region;
    }

    private EntityRegionImpl buildAndStoreEntityRegion(String name, CacheDataDescription cacheDataDescription) {
        EntityRegionImpl region = (EntityRegionImpl)this.regionFactory.buildEntityRegion(name, this.properties, cacheDataDescription);
        this.entityRegionMap.put(name, region);
        return region;
    }

    public CollectionRegionImpl getCollectionRegion(String name, CacheDataDescription cacheDataDescription) {
        if (this.collectionRegionMap == null) {
            this.collectionRegionMap = new HashMap<String, CollectionRegionImpl>();
            return this.buildAndStoreCollectionRegion(name, cacheDataDescription);
        }
        CollectionRegionImpl region = this.collectionRegionMap.get(name);
        if (region == null) {
            region = this.buildAndStoreCollectionRegion(name, cacheDataDescription);
            this.collectionRegionMap.put(name, region);
        }
        return region;
    }

    private CollectionRegionImpl buildAndStoreCollectionRegion(String name, CacheDataDescription cacheDataDescription) {
        CollectionRegionImpl region = (CollectionRegionImpl)this.regionFactory.buildCollectionRegion(name, this.properties, cacheDataDescription);
        return region;
    }

    public void prepare() throws Exception {
        this.serviceRegistry = this.ssrb.build();
        this.regionFactory = CacheTestUtil.startRegionFactory((ServiceRegistry)this.serviceRegistry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() throws Exception {
        try {
            if (this.entityRegionMap != null) {
                for (EntityRegionImpl region : this.entityRegionMap.values()) {
                    try {
                        region.getCache().stop();
                    }
                    catch (Exception exception) {}
                }
                this.entityRegionMap.clear();
            }
            if (this.collectionRegionMap != null) {
                for (CollectionRegionImpl reg : this.collectionRegionMap.values()) {
                    try {
                        reg.getCache().stop();
                    }
                    catch (Exception exception) {}
                }
                this.collectionRegionMap.clear();
            }
        }
        finally {
            try {
                if (this.regionFactory != null) {
                    this.regionFactory.stop();
                }
            }
            finally {
                if (this.serviceRegistry != null) {
                    StandardServiceRegistryBuilder.destroy((ServiceRegistry)this.serviceRegistry);
                }
            }
        }
    }
}

