/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.hibernate.cache;

import org.hibernate.cache.internal.CacheDataDescriptionImpl;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cache.spi.access.RegionAccessStrategy;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.util.compare.ComparableComparator;
import org.hibernate.testing.AfterClassOnce;
import org.hibernate.testing.BeforeClassOnce;
import org.infinispan.test.fwk.TestResourceTracker;
import org.infinispan.test.hibernate.cache.AbstractNonFunctionalTest;
import org.infinispan.test.hibernate.cache.NodeEnvironment;
import org.infinispan.test.hibernate.cache.util.TestingKeyFactory;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public abstract class AbstractExtraAPITest<S extends RegionAccessStrategy>
extends AbstractNonFunctionalTest {
    public static final String REGION_NAME = "test/com.foo.test";
    public static final Object KEY = TestingKeyFactory.generateCollectionCacheKey("KEY");
    public static final CacheDataDescription CACHE_DATA_DESCRIPTION = new CacheDataDescriptionImpl(true, true, ComparableComparator.INSTANCE, null);
    protected static final SessionImplementor SESSION = (SessionImplementor)Mockito.mock(SessionImplementor.class);
    protected S accessStrategy;
    protected NodeEnvironment environment;

    @BeforeClassOnce
    public final void prepareLocalAccessStrategy() throws Exception {
        TestResourceTracker.testStarted((String)((Object)((Object)this)).getClass().getSimpleName());
        this.environment = new NodeEnvironment(this.createStandardServiceRegistryBuilder());
        this.environment.prepare();
        this.accessStrategy = this.getAccessStrategy();
    }

    protected abstract S getAccessStrategy();

    @AfterClassOnce
    public final void releaseLocalAccessStrategy() throws Exception {
        if (this.environment != null) {
            this.environment.release();
        }
        TestResourceTracker.testFinished((String)((Object)((Object)this)).getClass().getSimpleName());
    }

    @Test
    public void testLockItem() {
        Assert.assertNull((Object)this.accessStrategy.lockItem(SESSION, KEY, (Object)1));
    }

    @Test
    public void testLockRegion() {
        Assert.assertNull((Object)this.accessStrategy.lockRegion());
    }

    @Test
    public void testUnlockItem() {
        this.accessStrategy.unlockItem(SESSION, KEY, (SoftLock)new MockSoftLock());
    }

    @Test
    public void testUnlockRegion() {
        this.accessStrategy.unlockItem(SESSION, KEY, (SoftLock)new MockSoftLock());
    }

    public static class MockSoftLock
    implements SoftLock {
    }
}

