/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.hibernate.cache.functional.cluster;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Phaser;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.testing.TestForIssue;
import org.infinispan.AdvancedCache;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commons.util.Util;
import org.infinispan.commons.util.concurrent.ConcurrentHashSet;
import org.infinispan.context.InvocationContext;
import org.infinispan.hibernate.cache.access.PutFromLoadValidator;
import org.infinispan.hibernate.cache.util.FutureUpdate;
import org.infinispan.hibernate.cache.util.InfinispanMessageLogger;
import org.infinispan.interceptors.base.BaseCustomInterceptor;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryVisited;
import org.infinispan.notifications.cachelistener.event.CacheEntryVisitedEvent;
import org.infinispan.test.hibernate.cache.functional.cluster.ClusterAwareRegionFactory;
import org.infinispan.test.hibernate.cache.functional.cluster.DualNodeTest;
import org.infinispan.test.hibernate.cache.functional.entities.Contact;
import org.infinispan.test.hibernate.cache.functional.entities.Customer;
import org.infinispan.test.hibernate.cache.util.ExpectingInterceptor;
import org.infinispan.test.hibernate.cache.util.TestInfinispanRegionFactory;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class EntityCollectionInvalidationTest
extends DualNodeTest {
    private static final InfinispanMessageLogger log = InfinispanMessageLogger.Provider.getLog(EntityCollectionInvalidationTest.class);
    private static final Integer CUSTOMER_ID = new Integer(1);
    private EmbeddedCacheManager localManager;
    private EmbeddedCacheManager remoteManager;
    private AdvancedCache localCustomerCache;
    private AdvancedCache remoteCustomerCache;
    private AdvancedCache localContactCache;
    private AdvancedCache remoteContactCache;
    private AdvancedCache localCollectionCache;
    private AdvancedCache remoteCollectionCache;
    private MyListener localListener;
    private MyListener remoteListener;
    private SessionFactory localFactory;
    private SessionFactory remoteFactory;

    @Override
    public List<Object[]> getParameters() {
        return this.getParameters(true, true, false, true);
    }

    @Override
    public void startUp() {
        super.startUp();
        this.localManager = ClusterAwareRegionFactory.getCacheManager("local");
        this.localCustomerCache = this.localManager.getCache(Customer.class.getName()).getAdvancedCache();
        this.localContactCache = this.localManager.getCache(Contact.class.getName()).getAdvancedCache();
        this.localCollectionCache = this.localManager.getCache(Customer.class.getName() + ".contacts").getAdvancedCache();
        this.localListener = new MyListener("local");
        this.localCustomerCache.addListener((Object)this.localListener);
        this.localContactCache.addListener((Object)this.localListener);
        this.localCollectionCache.addListener((Object)this.localListener);
        this.remoteManager = ClusterAwareRegionFactory.getCacheManager("remote");
        this.remoteCustomerCache = this.remoteManager.getCache(Customer.class.getName()).getAdvancedCache();
        this.remoteContactCache = this.remoteManager.getCache(Contact.class.getName()).getAdvancedCache();
        this.remoteCollectionCache = this.remoteManager.getCache(Customer.class.getName() + ".contacts").getAdvancedCache();
        this.remoteListener = new MyListener("remote");
        this.remoteCustomerCache.addListener((Object)this.remoteListener);
        this.remoteContactCache.addListener((Object)this.remoteListener);
        this.remoteCollectionCache.addListener((Object)this.remoteListener);
        this.localFactory = this.sessionFactory();
        this.remoteFactory = this.secondNodeEnvironment().getSessionFactory();
    }

    @Override
    public void shutDown() {
        this.cleanupTransactionManagement();
    }

    @Override
    protected void cleanupTest() throws Exception {
        this.cleanup(this.localFactory);
        this.localListener.clear();
        this.remoteListener.clear();
    }

    @Override
    protected void addSettings(Map settings) {
        super.addSettings(settings);
        settings.put(TestInfinispanRegionFactory.PENDING_PUTS_SIMPLE, false);
    }

    @Test
    public void testAll() throws Exception {
        this.assertEmptyCaches();
        Assert.assertTrue((boolean)this.remoteListener.isEmpty());
        Assert.assertTrue((boolean)this.localListener.isEmpty());
        log.debug((Object)"Create node 0");
        IdContainer ids = this.createCustomer(this.localFactory);
        Assert.assertTrue((boolean)this.remoteListener.isEmpty());
        Assert.assertTrue((boolean)this.localListener.isEmpty());
        log.debug((Object)"Find node 0");
        this.getCustomer(ids.customerId, this.localFactory);
        log.debug((Object)"Find(2) node 0");
        this.localListener.clear();
        this.getCustomer(ids.customerId, this.localFactory);
        log.debug((Object)"Check cache 0");
        this.assertLoadedFromCache(this.localListener, ids.customerId, ids.contactIds);
        log.debug((Object)"Find node 1");
        this.getCustomer(ids.customerId, this.remoteFactory);
        log.debug((Object)"Find(2) node 1");
        this.remoteListener.clear();
        this.getCustomer(ids.customerId, this.remoteFactory);
        log.debug((Object)"Check cache 1");
        this.assertLoadedFromCache(this.remoteListener, ids.customerId, ids.contactIds);
        this.remoteListener.clear();
        CountDownLatch modifyLatch = null;
        if (!this.cacheMode.isInvalidation() && this.accessType != AccessType.NONSTRICT_READ_WRITE) {
            modifyLatch = new CountDownLatch(1);
            ExpectingInterceptor.get(this.localCustomerCache).when(this::isFutureUpdate).countDown(modifyLatch);
        }
        ids = this.modifyCustomer(ids.customerId, this.remoteFactory);
        this.assertLoadedFromCache(this.remoteListener, ids.customerId, ids.contactIds);
        if (modifyLatch != null) {
            Assert.assertTrue((boolean)modifyLatch.await(2L, TimeUnit.SECONDS));
            ExpectingInterceptor.cleanup(this.localCustomerCache);
        }
        Assert.assertEquals((long)0L, (long)this.localCollectionCache.size());
        if (this.cacheMode.isInvalidation()) {
            Assert.assertEquals((long)0L, (long)this.localCustomerCache.size());
        } else {
            Assert.assertEquals((long)1L, (long)this.localCustomerCache.size());
        }
    }

    @TestForIssue(jiraKey="HHH-9881")
    @Test
    public void testConcurrentLoadAndRemoval() throws Exception {
        if (!this.remoteCustomerCache.getCacheConfiguration().clustering().cacheMode().isInvalidation()) {
            return;
        }
        AtomicReference getException = new AtomicReference();
        AtomicReference deleteException = new AtomicReference();
        Phaser getPhaser = new Phaser(2);
        HookInterceptor hookInterceptor = new HookInterceptor(getException);
        AdvancedCache remotePPCache = this.remoteCustomerCache.getCacheManager().getCache(this.remoteCustomerCache.getName() + "-" + "pending-puts").getAdvancedCache();
        remotePPCache.getAdvancedCache().addInterceptor((CommandInterceptor)hookInterceptor, 0);
        IdContainer idContainer = new IdContainer();
        this.withTxSession(this.localFactory, s -> {
            Customer customer = new Customer();
            customer.setName("JBoss");
            s.persist((Object)customer);
            idContainer.customerId = customer.getId();
        });
        Thread getThread = new Thread(() -> {
            try {
                this.withTxSession(this.remoteFactory, s -> s.get(Customer.class, (Serializable)idContainer.customerId));
            }
            catch (Exception e) {
                log.error((Object)"Failure to get customer", (Throwable)e);
                getException.set(e);
            }
        }, "get-thread");
        Thread deleteThread = new Thread(() -> {
            try {
                this.withTxSession(this.localFactory, s -> {
                    Customer customer = (Customer)s.get(Customer.class, (Serializable)idContainer.customerId);
                    s.delete((Object)customer);
                });
            }
            catch (Exception e) {
                log.error((Object)"Failure to delete customer", (Throwable)e);
                deleteException.set(e);
            }
        }, "delete-thread");
        hookInterceptor.block(getPhaser, getThread);
        getThread.start();
        EntityCollectionInvalidationTest.arriveAndAwait(getPhaser);
        deleteThread.start();
        deleteThread.join();
        hookInterceptor.unblock();
        EntityCollectionInvalidationTest.arriveAndAwait(getPhaser);
        getThread.join();
        if (getException.get() != null) {
            throw new IllegalStateException("get-thread failed", (Throwable)getException.get());
        }
        if (deleteException.get() != null) {
            throw new IllegalStateException("delete-thread failed", (Throwable)deleteException.get());
        }
        Customer localCustomer = this.getCustomer(idContainer.customerId, this.localFactory);
        Assert.assertNull((Object)localCustomer);
        Customer remoteCustomer = this.getCustomer(idContainer.customerId, this.remoteFactory);
        Assert.assertNull((Object)remoteCustomer);
        Assert.assertTrue((boolean)this.remoteCustomerCache.isEmpty());
    }

    protected void assertEmptyCaches() {
        Assert.assertTrue((boolean)this.localCustomerCache.isEmpty());
        Assert.assertTrue((boolean)this.localContactCache.isEmpty());
        Assert.assertTrue((boolean)this.localCollectionCache.isEmpty());
        Assert.assertTrue((boolean)this.remoteCustomerCache.isEmpty());
        Assert.assertTrue((boolean)this.remoteContactCache.isEmpty());
        Assert.assertTrue((boolean)this.remoteCollectionCache.isEmpty());
    }

    private IdContainer createCustomer(SessionFactory sessionFactory) throws Exception {
        log.debug((Object)"CREATE CUSTOMER");
        Customer customer = new Customer();
        customer.setName("JBoss");
        HashSet<Contact> contacts = new HashSet<Contact>();
        Contact kabir = new Contact();
        kabir.setCustomer(customer);
        kabir.setName("Kabir");
        kabir.setTlf("1111");
        contacts.add(kabir);
        Contact bill = new Contact();
        bill.setCustomer(customer);
        bill.setName("Bill");
        bill.setTlf("2222");
        contacts.add(bill);
        customer.setContacts(contacts);
        ArrayList<Runnable> cleanup = new ArrayList<Runnable>();
        CountDownLatch customerLatch = new CountDownLatch(1);
        CountDownLatch collectionLatch = new CountDownLatch(1);
        CountDownLatch contactsLatch = new CountDownLatch(2);
        if (this.cacheMode.isInvalidation()) {
            cleanup.add(this.mockValidator(this.remoteCustomerCache, customerLatch));
            cleanup.add(this.mockValidator(this.remoteCollectionCache, collectionLatch));
            cleanup.add(this.mockValidator(this.remoteContactCache, contactsLatch));
        } else if (this.accessType == AccessType.NONSTRICT_READ_WRITE) {
            Stream.of(customerLatch, collectionLatch, contactsLatch, contactsLatch).forEach(l -> l.countDown());
        } else {
            ExpectingInterceptor.get(this.remoteCustomerCache).when(this::isFutureUpdate).countDown(collectionLatch);
            ExpectingInterceptor.get(this.remoteCollectionCache).when(this::isFutureUpdate).countDown(customerLatch);
            ExpectingInterceptor.get(this.remoteContactCache).when(this::isFutureUpdate).countDown(contactsLatch);
            cleanup.add(() -> ExpectingInterceptor.cleanup(this.remoteCustomerCache, this.remoteCollectionCache, this.remoteContactCache));
        }
        this.withTxSession(sessionFactory, session -> session.save((Object)customer));
        Assert.assertTrue((boolean)customerLatch.await(2L, TimeUnit.SECONDS));
        Assert.assertTrue((boolean)collectionLatch.await(2L, TimeUnit.SECONDS));
        Assert.assertTrue((boolean)contactsLatch.await(2L, TimeUnit.SECONDS));
        cleanup.forEach(Runnable::run);
        IdContainer ids = new IdContainer();
        ids.customerId = customer.getId();
        HashSet<Integer> contactIds = new HashSet<Integer>();
        contactIds.add(kabir.getId());
        contactIds.add(bill.getId());
        ids.contactIds = contactIds;
        log.debug((Object)"CREATE CUSTOMER -  END");
        return ids;
    }

    private boolean isFutureUpdate(InvocationContext ctx, VisitableCommand cmd) {
        return cmd instanceof PutKeyValueCommand && ((PutKeyValueCommand)cmd).getValue() instanceof FutureUpdate;
    }

    private Runnable mockValidator(AdvancedCache cache, CountDownLatch latch) {
        PutFromLoadValidator originalValidator = PutFromLoadValidator.removeFromCache((AdvancedCache)cache);
        PutFromLoadValidator mockValidator = (PutFromLoadValidator)Mockito.spy((Object)originalValidator);
        ((PutFromLoadValidator)Mockito.doAnswer(invocation -> {
            try {
                Object object = invocation.callRealMethod();
                return object;
            }
            finally {
                latch.countDown();
            }
        }).when((Object)mockValidator)).endInvalidatingKey(Matchers.any(), Matchers.any());
        PutFromLoadValidator.addToCache((AdvancedCache)cache, (PutFromLoadValidator)mockValidator);
        return () -> {
            PutFromLoadValidator.removeFromCache((AdvancedCache)cache);
            PutFromLoadValidator.addToCache((AdvancedCache)cache, (PutFromLoadValidator)originalValidator);
        };
    }

    private Customer getCustomer(Integer id, SessionFactory sessionFactory) throws Exception {
        log.debug((Object)("Find customer with id=" + id));
        return this.withTxSessionApply(sessionFactory, session -> this.doGetCustomer(id, (Session)session));
    }

    private Customer doGetCustomer(Integer id, Session session) throws Exception {
        Customer customer = (Customer)session.get(Customer.class, (Serializable)id);
        if (customer == null) {
            return null;
        }
        Set<Contact> contacts = customer.getContacts();
        if (contacts != null) {
            Iterator<Contact> it = contacts.iterator();
            while (it.hasNext()) {
                it.next().getName();
            }
        }
        return customer;
    }

    private IdContainer modifyCustomer(Integer id, SessionFactory sessionFactory) throws Exception {
        log.debug((Object)("Modify customer with id=" + id));
        return this.withTxSessionApply(sessionFactory, session -> {
            IdContainer ids = new IdContainer();
            HashSet<Integer> contactIds = new HashSet<Integer>();
            Customer customer = this.doGetCustomer(id, (Session)session);
            customer.setName("NewJBoss");
            ids.customerId = customer.getId();
            Set<Contact> contacts = customer.getContacts();
            for (Contact c : contacts) {
                contactIds.add(c.getId());
            }
            Contact contact = contacts.iterator().next();
            contacts.remove(contact);
            contactIds.remove(contact.getId());
            ids.contactIds = contactIds;
            contact.setCustomer(null);
            session.save((Object)customer);
            return ids;
        });
    }

    private void cleanup(SessionFactory sessionFactory) throws Exception {
        this.withTxSession(sessionFactory, session -> {
            Customer c = (Customer)session.get(Customer.class, (Serializable)CUSTOMER_ID);
            if (c != null) {
                Set<Contact> contacts = c.getContacts();
                Iterator<Contact> it = contacts.iterator();
                while (it.hasNext()) {
                    session.delete((Object)it.next());
                }
                c.setContacts(null);
                session.delete((Object)c);
            }
            for (Object contact : session.createCriteria(Contact.class).list()) {
                session.delete(contact);
            }
        });
    }

    private void assertLoadedFromCache(MyListener listener, Integer custId, Set contactIds) {
        Assert.assertTrue((String)("Customer#" + custId + " was in cache"), (boolean)listener.visited.contains("Customer#" + custId));
        for (Integer contactId : contactIds) {
            Assert.assertTrue((String)("Contact#" + contactId + " was in cache"), (boolean)listener.visited.contains("Contact#" + contactId));
            Assert.assertTrue((String)("Contact#" + contactId + " was in cache"), (boolean)listener.visited.contains("Contact#" + contactId));
        }
        Assert.assertTrue((String)("Customer.contacts" + custId + " was in cache"), (boolean)listener.visited.contains("Customer.contacts#" + custId));
    }

    protected static void arriveAndAwait(Phaser phaser) throws TimeoutException, InterruptedException {
        try {
            phaser.awaitAdvanceInterruptibly(phaser.arrive(), 10L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            log.error((Object)("Failed to progress: " + Util.threadDump()));
            throw e;
        }
    }

    private static class HookInterceptor
    extends BaseCustomInterceptor {
        final AtomicReference<Exception> failure;
        Phaser phaser;
        Thread thread;

        private HookInterceptor(AtomicReference<Exception> failure) {
            this.failure = failure;
        }

        public synchronized void block(Phaser phaser, Thread thread) {
            this.phaser = phaser;
            this.thread = thread;
        }

        public synchronized void unblock() {
            this.phaser = null;
            this.thread = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
            try {
                Thread thread;
                Phaser phaser;
                HookInterceptor hookInterceptor = this;
                synchronized (hookInterceptor) {
                    phaser = this.phaser;
                    thread = this.thread;
                }
                if (phaser != null) {
                    if (Thread.currentThread() == thread) {
                        EntityCollectionInvalidationTest.arriveAndAwait(phaser);
                        EntityCollectionInvalidationTest.arriveAndAwait(phaser);
                    }
                }
            }
            catch (Exception e) {
                this.failure.set(e);
                throw e;
            }
            finally {
                return super.visitGetKeyValueCommand(ctx, command);
            }
        }
    }

    private class IdContainer {
        Integer customerId;
        Set<Integer> contactIds;

        private IdContainer() {
        }
    }

    @Listener
    public static class MyListener {
        private static final InfinispanMessageLogger log = InfinispanMessageLogger.Provider.getLog(MyListener.class);
        private Set<String> visited = new ConcurrentHashSet();
        private final String name;

        public MyListener(String name) {
            this.name = name;
        }

        public void clear() {
            this.visited.clear();
        }

        public boolean isEmpty() {
            return this.visited.isEmpty();
        }

        @CacheEntryVisited
        public void nodeVisited(CacheEntryVisitedEvent event) {
            log.debug((Object)event.toString());
            if (!event.isPre()) {
                String key = event.getCache().getName() + "#" + event.getKey();
                log.debug((Object)("MyListener[" + this.name + "] - Visiting key " + key));
                String token = ".entities.";
                int index = key.indexOf(token);
                if (index > -1) {
                    key = key.substring(index += token.length());
                    log.debug((Object)("MyListener[" + this.name + "] - recording visit to " + key));
                    this.visited.add(key);
                }
            }
        }
    }
}

