/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.hibernate.cache;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import javax.transaction.TransactionManager;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.resource.transaction.spi.TransactionStatus;
import org.hibernate.testing.junit4.BaseUnitTestCase;
import org.hibernate.testing.junit4.CustomParameterized;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.hibernate.cache.util.Caches;
import org.infinispan.test.hibernate.cache.NodeEnvironment;
import org.infinispan.test.hibernate.cache.util.BatchModeJtaPlatform;
import org.infinispan.test.hibernate.cache.util.CacheTestSupport;
import org.infinispan.test.hibernate.cache.util.CacheTestUtil;
import org.infinispan.test.hibernate.cache.util.InfinispanTestingSetup;
import org.infinispan.test.hibernate.cache.util.TestInfinispanRegionFactory;
import org.jboss.logging.Logger;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=CustomParameterized.class)
public abstract class AbstractNonFunctionalTest
extends BaseUnitTestCase {
    private static final Logger log = Logger.getLogger(AbstractNonFunctionalTest.class);
    @Rule
    public InfinispanTestingSetup infinispanTestIdentifier = new InfinispanTestingSetup();
    @Parameterized.Parameter(value=0)
    public String mode;
    @Parameterized.Parameter(value=1)
    public Class<? extends JtaPlatform> jtaPlatform;
    @Parameterized.Parameter(value=2)
    public CacheMode cacheMode;
    @Parameterized.Parameter(value=3)
    public AccessType accessType;
    public static final String REGION_PREFIX = "test";
    private static final String PREFER_IPV4STACK = "java.net.preferIPv4Stack";
    private String preferIPv4Stack;
    private static final String JGROUPS_CFG_FILE = "hibernate.cache.infinispan.jgroups_cfg";
    private String jgroupsCfgFile;
    private CacheTestSupport testSupport = new CacheTestSupport();

    @CustomParameterized.Order(value=0)
    @Parameterized.Parameters(name="{0}")
    public List<Object[]> getJtaParameters() {
        return Arrays.asList({"JTA", BatchModeJtaPlatform.class}, {"non-JTA", null});
    }

    @CustomParameterized.Order(value=1)
    @Parameterized.Parameters(name="{2},{3}")
    public List<Object[]> getCacheModeParameters() {
        ArrayList<Object[]> modes = new ArrayList<Object[]>();
        for (AccessType accessType : new AccessType[]{AccessType.TRANSACTIONAL, AccessType.READ_ONLY, AccessType.READ_WRITE}) {
            modes.add(new Object[]{CacheMode.INVALIDATION_SYNC, accessType});
        }
        for (AccessType accessType : new AccessType[]{AccessType.READ_ONLY, AccessType.READ_WRITE, AccessType.NONSTRICT_READ_WRITE}) {
            modes.add(new Object[]{CacheMode.REPL_SYNC, accessType});
            modes.add(new Object[]{CacheMode.DIST_SYNC, accessType});
            if (!this.canUseLocalMode()) continue;
            modes.add(new Object[]{CacheMode.LOCAL, accessType});
        }
        if (this.canUseLocalMode()) {
            modes.add(new Object[]{CacheMode.LOCAL, AccessType.TRANSACTIONAL});
        }
        return modes;
    }

    @Before
    public void prepareCacheSupport() throws Exception {
        this.preferIPv4Stack = System.getProperty(PREFER_IPV4STACK);
        System.setProperty(PREFER_IPV4STACK, "true");
        this.jgroupsCfgFile = System.getProperty(JGROUPS_CFG_FILE);
        System.setProperty(JGROUPS_CFG_FILE, "2lc-test-tcp.xml");
        this.testSupport.setUp();
    }

    @After
    public void releaseCachSupport() throws Exception {
        this.testSupport.tearDown();
        if (this.preferIPv4Stack == null) {
            System.clearProperty(PREFER_IPV4STACK);
        } else {
            System.setProperty(PREFER_IPV4STACK, this.preferIPv4Stack);
        }
        if (this.jgroupsCfgFile == null) {
            System.clearProperty(JGROUPS_CFG_FILE);
        } else {
            System.setProperty(JGROUPS_CFG_FILE, this.jgroupsCfgFile);
        }
    }

    protected boolean canUseLocalMode() {
        return true;
    }

    protected <T> T withTx(NodeEnvironment environment, SessionImplementor session, Callable<T> callable) throws Exception {
        if (this.jtaPlatform != null) {
            TransactionManager tm = ((JtaPlatform)environment.getServiceRegistry().getService(JtaPlatform.class)).retrieveTransactionManager();
            return (T)Caches.withinTx((TransactionManager)tm, callable);
        }
        Transaction transaction = ((Session)session).beginTransaction();
        boolean rollingBack = false;
        try {
            T retval = callable.call();
            if (transaction.getStatus() == TransactionStatus.ACTIVE) {
                transaction.commit();
            } else {
                rollingBack = true;
                transaction.rollback();
            }
            return retval;
        }
        catch (Exception e) {
            if (!rollingBack) {
                try {
                    transaction.rollback();
                }
                catch (Exception suppressed) {
                    e.addSuppressed(suppressed);
                }
            }
            throw e;
        }
    }

    protected void registerCache(Cache cache) {
        this.testSupport.registerCache(cache);
    }

    protected void unregisterCache(Cache cache) {
        this.testSupport.unregisterCache(cache);
    }

    protected void registerFactory(RegionFactory factory) {
        this.testSupport.registerFactory(factory);
    }

    protected void unregisterFactory(RegionFactory factory) {
        this.testSupport.unregisterFactory(factory);
    }

    protected CacheTestSupport getCacheTestSupport() {
        return this.testSupport;
    }

    protected StandardServiceRegistryBuilder createStandardServiceRegistryBuilder() {
        StandardServiceRegistryBuilder ssrb = CacheTestUtil.buildBaselineStandardServiceRegistryBuilder(REGION_PREFIX, this.getRegionFactoryClass(), true, false, this.jtaPlatform);
        ssrb.applySetting(TestInfinispanRegionFactory.TRANSACTIONAL, (Object)(this.accessType == AccessType.TRANSACTIONAL ? 1 : 0));
        ssrb.applySetting(TestInfinispanRegionFactory.CACHE_MODE, (Object)this.cacheMode);
        return ssrb;
    }

    protected Class<? extends RegionFactory> getRegionFactoryClass() {
        return TestInfinispanRegionFactory.class;
    }
}

