/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.hibernate.cache.collection;

import java.util.Properties;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cache.spi.CollectionRegion;
import org.hibernate.cache.spi.Region;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cache.spi.access.CollectionRegionAccessStrategy;
import org.infinispan.AdvancedCache;
import org.infinispan.hibernate.cache.InfinispanRegionFactory;
import org.infinispan.test.hibernate.cache.AbstractEntityCollectionRegionTest;
import org.junit.Assert;

public class CollectionRegionImplTest
extends AbstractEntityCollectionRegionTest {
    protected static final String CACHE_NAME = "test";

    @Override
    protected void supportedAccessTypeTest(RegionFactory regionFactory, Properties properties) {
        CollectionRegion region = regionFactory.buildCollectionRegion(CACHE_NAME, properties, MUTABLE_NON_VERSIONED);
        Assert.assertNotNull((Object)region.buildAccessStrategy(this.accessType));
        ((InfinispanRegionFactory)regionFactory).getCacheManager().administration().removeCache(CACHE_NAME);
    }

    @Override
    protected Region createRegion(InfinispanRegionFactory regionFactory, String regionName, Properties properties, CacheDataDescription cdd) {
        return regionFactory.buildCollectionRegion(regionName, properties, cdd);
    }

    @Override
    protected AdvancedCache getInfinispanCache(InfinispanRegionFactory regionFactory) {
        return regionFactory.getCacheManager().getCache("entity").getAdvancedCache();
    }

    @Override
    protected void putInRegion(Region region, Object key, Object value) {
        CollectionRegionAccessStrategy strategy = ((CollectionRegion)region).buildAccessStrategy(AccessType.TRANSACTIONAL);
        strategy.putFromLoad(null, key, value, region.nextTimestamp(), (Object)new Integer(1));
    }

    @Override
    protected void removeFromRegion(Region region, Object key) {
        ((CollectionRegion)region).buildAccessStrategy(AccessType.TRANSACTIONAL).remove(null, key);
    }
}

