/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.hibernate.cache.functional;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.hibernate.PessimisticLockException;
import org.hibernate.Session;
import org.hibernate.StaleStateException;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cache.spi.Region;
import org.hibernate.cache.spi.entry.CacheEntry;
import org.hibernate.testing.AfterClassOnce;
import org.hibernate.testing.BeforeClassOnce;
import org.infinispan.AdvancedCache;
import org.infinispan.hibernate.cache.InfinispanRegionFactory;
import org.infinispan.hibernate.cache.entity.EntityRegionImpl;
import org.infinispan.hibernate.cache.util.Caches;
import org.infinispan.hibernate.cache.util.InfinispanMessageLogger;
import org.infinispan.test.hibernate.cache.functional.SingleNodeTest;
import org.infinispan.test.hibernate.cache.functional.entities.Item;
import org.infinispan.test.hibernate.cache.util.TestInfinispanRegionFactory;
import org.infinispan.util.ControlledTimeService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public abstract class AbstractNonInvalidationTest
extends SingleNodeTest {
    protected static final int WAIT_TIMEOUT = 2000;
    protected static final ControlledTimeService TIME_SERVICE = new ControlledTimeService();
    protected long TIMEOUT;
    protected ExecutorService executor;
    protected InfinispanMessageLogger log = InfinispanMessageLogger.Provider.getLog(((Object)((Object)this)).getClass());
    protected AdvancedCache entityCache;
    protected long itemId;
    protected Region region;
    protected long timeout;
    protected final List<Runnable> cleanup = new ArrayList<Runnable>();

    @BeforeClassOnce
    public void setup() {
        this.executor = Executors.newCachedThreadPool(new ThreadFactory(){
            AtomicInteger counter = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "Executor-" + this.counter.incrementAndGet());
            }
        });
    }

    @AfterClassOnce
    public void shutdown() {
        this.executor.shutdown();
    }

    protected void configureStandardServiceRegistryBuilder(StandardServiceRegistryBuilder ssrb) {
        String url = (String)ssrb.getSettings().get("hibernate.connection.url");
        if (url != null && url.contains("LOCK_TIMEOUT")) {
            url = url.replaceAll("LOCK_TIMEOUT=[^;]*", "LOCK_TIMEOUT=100");
        }
        ssrb.applySetting("hibernate.connection.url", (Object)url);
    }

    protected void startUp() {
        super.startUp();
        InfinispanRegionFactory regionFactory = (InfinispanRegionFactory)this.sessionFactory().getSettings().getRegionFactory();
        this.TIMEOUT = regionFactory.getPendingPutsCacheConfiguration().expiration().maxIdle();
        this.region = this.sessionFactory().getSecondLevelCacheRegion(Item.class.getName());
        this.entityCache = ((EntityRegionImpl)this.region).getCache();
    }

    @Before
    public void insertAndClearCache() throws Exception {
        this.region = this.sessionFactory().getSecondLevelCacheRegion(Item.class.getName());
        this.entityCache = ((EntityRegionImpl)this.region).getCache();
        this.timeout = ((EntityRegionImpl)this.region).getRegionFactory().getPendingPutsCacheConfiguration().expiration().maxIdle();
        Item item = new Item("my item", "Original item");
        this.withTxSession(s -> s.persist((Object)item));
        this.entityCache.clear();
        Assert.assertEquals((String)"Cache is not empty", (Object)Collections.EMPTY_SET, (Object)this.entityCache.keySet());
        this.itemId = item.getId();
        this.log.info((Object)"Insert and clear finished");
    }

    @After
    public void cleanup() throws Exception {
        this.cleanup.forEach(Runnable::run);
        this.cleanup.clear();
        this.withTxSession(s -> s.createQuery("delete from Item").executeUpdate());
    }

    protected Future<Boolean> removeFlushWait(long id, CyclicBarrier loadBarrier, CountDownLatch preFlushLatch, CountDownLatch flushLatch, CountDownLatch commitLatch) throws Exception {
        return this.executor.submit(() -> this.withTxSessionApply(s -> {
            try {
                Item item = (Item)s.load(Item.class, (Serializable)Long.valueOf(id));
                item.getName();
                loadBarrier.await(2000L, TimeUnit.SECONDS);
                s.delete((Object)item);
                if (preFlushLatch != null) {
                    this.awaitOrThrow(preFlushLatch);
                }
                s.flush();
            }
            catch (StaleStateException e) {
                this.log.info((Object)"Exception thrown: ", (Throwable)e);
                this.markRollbackOnly((Session)s);
                Boolean bl = false;
                return bl;
            }
            catch (javax.persistence.PessimisticLockException | PessimisticLockException e) {
                this.log.info((Object)"Exception thrown: ", e);
                this.markRollbackOnly((Session)s);
                Boolean bl = false;
                return bl;
            }
            finally {
                if (flushLatch != null) {
                    flushLatch.countDown();
                }
            }
            this.awaitOrThrow(commitLatch);
            return true;
        }));
    }

    protected Future<Boolean> updateFlushWait(long id, CyclicBarrier loadBarrier, CountDownLatch preFlushLatch, CountDownLatch flushLatch, CountDownLatch commitLatch) throws Exception {
        return this.executor.submit(() -> this.withTxSessionApply(s -> {
            try {
                Item item = (Item)s.load(Item.class, (Serializable)Long.valueOf(id));
                item.getName();
                if (loadBarrier != null) {
                    loadBarrier.await(2000L, TimeUnit.SECONDS);
                }
                item.setDescription("Updated item");
                s.update((Object)item);
                if (preFlushLatch != null) {
                    this.awaitOrThrow(preFlushLatch);
                }
                s.flush();
            }
            catch (StaleStateException e) {
                this.log.info((Object)"Exception thrown: ", (Throwable)e);
                this.markRollbackOnly((Session)s);
                Boolean bl = false;
                return bl;
            }
            catch (javax.persistence.PessimisticLockException | PessimisticLockException e) {
                this.log.info((Object)"Exception thrown: ", e);
                this.markRollbackOnly((Session)s);
                Boolean bl = false;
                return bl;
            }
            finally {
                if (flushLatch != null) {
                    flushLatch.countDown();
                }
            }
            if (commitLatch != null) {
                this.awaitOrThrow(commitLatch);
            }
            return true;
        }));
    }

    protected Future<Boolean> evictWait(long id, CyclicBarrier loadBarrier, CountDownLatch preEvictLatch, CountDownLatch postEvictLatch) throws Exception {
        return this.executor.submit(() -> {
            try {
                loadBarrier.await(2000L, TimeUnit.SECONDS);
                if (preEvictLatch != null) {
                    this.awaitOrThrow(preEvictLatch);
                }
                this.sessionFactory().getCache().evictEntity(Item.class, (Serializable)Long.valueOf(id));
            }
            finally {
                if (postEvictLatch != null) {
                    postEvictLatch.countDown();
                }
            }
            return true;
        });
    }

    protected void awaitOrThrow(CountDownLatch latch) throws InterruptedException, TimeoutException {
        if (!latch.await(2000L, TimeUnit.SECONDS)) {
            throw new TimeoutException();
        }
    }

    @Override
    protected void addSettings(Map settings) {
        super.addSettings(settings);
        settings.put(TestInfinispanRegionFactory.TIME_SERVICE, TIME_SERVICE);
    }

    protected void assertEmptyCache() {
        Assert.assertNull((Object)this.entityCache.get((Object)this.itemId));
        Map contents = Caches.entrySet((AdvancedCache)this.entityCache).toMap();
        Assert.assertEquals((Object)Collections.EMPTY_MAP, (Object)contents);
    }

    protected <T> T assertCacheContains(Class<T> expected) {
        Map contents = Caches.entrySet((AdvancedCache)this.entityCache).toMap();
        Assert.assertEquals((String)"Cache does not have single element", (long)1L, (long)contents.size());
        Object value = contents.get(this.itemId);
        Assert.assertTrue((String)String.valueOf(value), (boolean)expected.isInstance(value));
        return (T)value;
    }

    protected Object assertSingleCacheEntry() {
        return this.assertCacheContains(CacheEntry.class);
    }
}

