/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.hibernate.cache.functional;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.hibernate.FlushMode;
import org.hibernate.stat.SecondLevelCacheStatistics;
import org.infinispan.hibernate.cache.util.InfinispanMessageLogger;
import org.infinispan.test.hibernate.cache.functional.SingleNodeTest;
import org.infinispan.test.hibernate.cache.functional.entities.Contact;
import org.infinispan.test.hibernate.cache.functional.entities.Customer;
import org.infinispan.test.hibernate.cache.util.InfinispanTestingSetup;
import org.infinispan.test.hibernate.cache.util.TestInfinispanRegionFactory;
import org.infinispan.util.ControlledTimeService;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class BulkOperationsTest
extends SingleNodeTest {
    private static final InfinispanMessageLogger log = InfinispanMessageLogger.Provider.getLog(BulkOperationsTest.class);
    private static final ControlledTimeService TIME_SERVICE = new AlwaysMoveForwardTimeService();
    @Rule
    public TestName name = new TestName();
    @ClassRule
    public static final InfinispanTestingSetup infinispanTestIdentifier = new InfinispanTestingSetup();

    @Override
    public List<Object[]> getParameters() {
        return this.getParameters(true, true, false, true);
    }

    @Override
    protected String getBaseForMappings() {
        return "org/infinispan/test/";
    }

    @Override
    public String[] getMappings() {
        return new String[]{"hibernate/cache/functional/entities/Contact.hbm.xml", "hibernate/cache/functional/entities/Customer.hbm.xml"};
    }

    @Override
    protected void addSettings(Map settings) {
        super.addSettings(settings);
        settings.put(TestInfinispanRegionFactory.TIME_SERVICE, TIME_SERVICE);
    }

    @Test
    public void testBulkOperations() throws Throwable {
        log.infof("*** %s", (Object)this.name.getMethodName());
        boolean cleanedUp = false;
        try {
            this.createContacts();
            List<Integer> rhContacts = this.getContactsByCustomer("Red Hat");
            Assert.assertNotNull((String)"Red Hat contacts exist", rhContacts);
            Assert.assertEquals((String)"Created expected number of Red Hat contacts", (long)10L, (long)rhContacts.size());
            SecondLevelCacheStatistics contactSlcs = this.sessionFactory().getStatistics().getSecondLevelCacheStatistics(Contact.class.getName());
            Assert.assertEquals((long)20L, (long)contactSlcs.getElementCountInMemory());
            Assert.assertEquals((String)"Deleted all Red Hat contacts", (long)10L, (long)this.deleteContacts());
            Assert.assertEquals((long)0L, (long)contactSlcs.getElementCountInMemory());
            List<Integer> jbContacts = this.getContactsByCustomer("JBoss");
            Assert.assertNotNull((String)"JBoss contacts exist", jbContacts);
            Assert.assertEquals((String)"JBoss contacts remain", (long)10L, (long)jbContacts.size());
            for (Integer id : rhContacts) {
                Assert.assertNull((String)("Red Hat contact " + id + " cannot be retrieved"), (Object)this.getContact(id));
            }
            rhContacts = this.getContactsByCustomer("Red Hat");
            if (rhContacts != null) {
                Assert.assertEquals((String)"No Red Hat contacts remain", (long)0L, (long)rhContacts.size());
            }
            this.updateContacts("Kabir", "Updated");
            Assert.assertEquals((long)0L, (long)contactSlcs.getElementCountInMemory());
            TIME_SERVICE.advance(1L);
            for (Integer id : jbContacts) {
                Contact contact = this.getContact(id);
                Assert.assertNotNull((String)("JBoss contact " + id + " exists"), (Object)contact);
                String expected = "Kabir".equals(contact.getName()) ? "Updated" : "2222";
                Assert.assertEquals((String)("JBoss contact " + id + " has correct TLF"), (Object)expected, (Object)contact.getTlf());
            }
            List<Integer> updated = this.getContactsByTLF("Updated");
            Assert.assertNotNull((String)"Got updated contacts", updated);
            Assert.assertEquals((String)"Updated contacts", (long)5L, (long)updated.size());
            Assert.assertEquals((long)10L, (long)contactSlcs.getElementCountInMemory());
            this.updateContactsWithOneManual("Kabir", "UpdatedAgain");
            Assert.assertEquals((long)0L, (long)contactSlcs.getElementCountInMemory());
            for (Integer id : jbContacts) {
                Contact contact = this.getContact(id);
                Assert.assertNotNull((String)("JBoss contact " + id + " exists"), (Object)contact);
                String expected = "Kabir".equals(contact.getName()) ? "UpdatedAgain" : "2222";
                Assert.assertEquals((String)("JBoss contact " + id + " has correct TLF"), (Object)expected, (Object)contact.getTlf());
            }
            updated = this.getContactsByTLF("UpdatedAgain");
            Assert.assertNotNull((String)"Got updated contacts", updated);
            Assert.assertEquals((String)"Updated contacts", (long)5L, (long)updated.size());
        }
        catch (Throwable t) {
            cleanedUp = true;
            this.cleanup(true);
            throw t;
        }
        finally {
            if (!cleanedUp) {
                this.cleanup(false);
            }
        }
    }

    public void createContacts() throws Exception {
        this.withTxSession(s -> {
            for (int i = 0; i < 10; ++i) {
                Customer c = this.createCustomer(i);
                s.persist((Object)c);
            }
        });
    }

    public int deleteContacts() throws Exception {
        String deleteHQL = "delete Contact where customer in  (select customer FROM Customer as customer where customer.name = :cName)";
        int rowsAffected = this.withTxSessionApply(s -> s.createQuery(deleteHQL).setFlushMode(FlushMode.AUTO).setParameter("cName", (Object)"Red Hat").executeUpdate());
        return rowsAffected;
    }

    public List<Integer> getContactsByCustomer(String customerName) throws Exception {
        String selectHQL = "select contact.id from Contact contact where contact.customer.name = :cName";
        return this.withTxSessionApply(s -> s.createQuery(selectHQL).setFlushMode(FlushMode.AUTO).setParameter("cName", (Object)customerName).list());
    }

    public List<Integer> getContactsByTLF(String tlf) throws Exception {
        String selectHQL = "select contact.id from Contact contact where contact.tlf = :cTLF";
        return this.withTxSessionApply(s -> s.createQuery(selectHQL).setFlushMode(FlushMode.AUTO).setParameter("cTLF", (Object)tlf).list());
    }

    public int updateContacts(String name, String newTLF) throws Exception {
        String updateHQL = "update Contact set tlf = :cNewTLF where name = :cName";
        return this.withTxSessionApply(s -> s.createQuery(updateHQL).setFlushMode(FlushMode.AUTO).setParameter("cNewTLF", (Object)newTLF).setParameter("cName", (Object)name).executeUpdate());
    }

    public int updateContactsWithOneManual(String name, String newTLF) throws Exception {
        String queryHQL = "from Contact c where c.name = :cName";
        String updateHQL = "update Contact set tlf = :cNewTLF where name = :cName";
        return this.withTxSessionApply(s -> {
            List list = s.createQuery(queryHQL).setParameter("cName", (Object)name).list();
            ((Contact)list.get(0)).setTlf(newTLF);
            return s.createQuery(updateHQL).setFlushMode(FlushMode.AUTO).setParameter("cNewTLF", (Object)newTLF).setParameter("cName", (Object)name).executeUpdate();
        });
    }

    public Contact getContact(Integer id) throws Exception {
        return this.withTxSessionApply(s -> (Contact)s.get(Contact.class, (Serializable)id));
    }

    public void cleanup(boolean ignore) throws Exception {
        String deleteContactHQL = "delete from Contact";
        String deleteCustomerHQL = "delete from Customer";
        this.withTxSession(s -> {
            s.createQuery(deleteContactHQL).setFlushMode(FlushMode.AUTO).executeUpdate();
            s.createQuery(deleteCustomerHQL).setFlushMode(FlushMode.AUTO).executeUpdate();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Customer createCustomer(int id) throws Exception {
        System.out.println("CREATE CUSTOMER " + id);
        try {
            Customer customer = new Customer();
            customer.setName(id % 2 == 0 ? "JBoss" : "Red Hat");
            HashSet<Contact> contacts = new HashSet<Contact>();
            Contact kabir = new Contact();
            kabir.setCustomer(customer);
            kabir.setName("Kabir");
            kabir.setTlf("1111");
            contacts.add(kabir);
            Contact bill = new Contact();
            bill.setCustomer(customer);
            bill.setName("Bill");
            bill.setTlf("2222");
            contacts.add(bill);
            customer.setContacts(contacts);
            Customer customer2 = customer;
            return customer2;
        }
        finally {
            System.out.println("CREATE CUSTOMER " + id + " -  END");
        }
    }

    private static final class AlwaysMoveForwardTimeService
    extends ControlledTimeService {
        private AlwaysMoveForwardTimeService() {
        }

        public long wallClockTime() {
            this.advance(1L);
            return super.wallClockTime();
        }
    }
}

