/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.hibernate.cache.functional;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.hibernate.FlushMode;
import org.hibernate.LockMode;
import org.hibernate.Session;
import org.hibernate.stat.SecondLevelCacheStatistics;
import org.infinispan.hibernate.cache.util.InfinispanMessageLogger;
import org.infinispan.test.hibernate.cache.functional.SingleNodeTest;
import org.infinispan.test.hibernate.cache.functional.entities.Contact;
import org.infinispan.test.hibernate.cache.functional.entities.Customer;
import org.infinispan.test.hibernate.cache.util.TestInfinispanRegionFactory;
import org.infinispan.util.ControlledTimeService;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class ConcurrentWriteTest
extends SingleNodeTest {
    private static final InfinispanMessageLogger log = InfinispanMessageLogger.Provider.getLog(ConcurrentWriteTest.class);
    private static final boolean trace = log.isTraceEnabled();
    private static final int USER_COUNT = 5;
    private static final int ITERATION_COUNT = 150;
    private static final int THINK_TIME_MILLIS = 10;
    private static final long LAUNCH_INTERVAL_MILLIS = 10L;
    private static final Random random = new Random();
    private static final ControlledTimeService TIME_SERVICE = new ControlledTimeService();
    private static volatile boolean TERMINATE_ALL_USERS = false;
    private Set<Integer> customerIDs = new HashSet<Integer>();

    @Override
    public List<Object[]> getParameters() {
        return this.getParameters(true, true, false, true);
    }

    protected void prepareTest() throws Exception {
        super.prepareTest();
        TERMINATE_ALL_USERS = false;
    }

    @Override
    protected void addSettings(Map settings) {
        super.addSettings(settings);
        settings.put(TestInfinispanRegionFactory.TIME_SERVICE, TIME_SERVICE);
    }

    protected void cleanupTest() throws Exception {
        try {
            super.cleanupTest();
        }
        finally {
            this.cleanup();
        }
    }

    @Test
    public void testPingDb() throws Exception {
        this.withTxSession(s -> s.createQuery("from " + Customer.class.getName()).list());
    }

    @Test
    public void testSingleUser() throws Exception {
        this.sessionFactory().getStatistics().clear();
        TIME_SERVICE.advance(1L);
        Customer customer = this.createCustomer(0);
        Integer customerId = customer.getId();
        this.getCustomerIDs().add(customerId);
        TIME_SERVICE.advance(1L);
        Assert.assertNull((String)"contact exists despite not being added", (Object)this.getFirstContact(customerId));
        SecondLevelCacheStatistics customerSlcs = this.sessionFactory().getStatistics().getSecondLevelCacheStatistics(Customer.class.getName());
        Assert.assertEquals((long)1L, (long)customerSlcs.getPutCount());
        Assert.assertEquals((long)1L, (long)customerSlcs.getElementCountInMemory());
        Assert.assertEquals((long)1L, (long)customerSlcs.getEntries().size());
        log.infof("Add contact to customer {0}", (Object)customerId);
        SecondLevelCacheStatistics contactsCollectionSlcs = this.sessionFactory().getStatistics().getSecondLevelCacheStatistics(Customer.class.getName() + ".contacts");
        Assert.assertEquals((long)1L, (long)contactsCollectionSlcs.getPutCount());
        Assert.assertEquals((long)1L, (long)contactsCollectionSlcs.getElementCountInMemory());
        Assert.assertEquals((long)1L, (long)contactsCollectionSlcs.getEntries().size());
        Contact contact = this.addContact(customerId);
        Assert.assertNotNull((String)"contact returned by addContact is null", (Object)contact);
        Assert.assertEquals((String)"Customer.contacts cache was not invalidated after addContact", (long)0L, (long)contactsCollectionSlcs.getElementCountInMemory());
        Assert.assertNotNull((String)"Contact missing after successful add call", (Object)this.getFirstContact(customerId));
        this.readEveryonesFirstContact();
        this.removeContact(customerId);
        Assert.assertNull((String)"contact still exists after successful remove call", (Object)this.getFirstContact(customerId));
    }

    @Ignore
    @Test
    public void testManyUsers() throws Throwable {
        try {
            for (int i = 0; i < 5; ++i) {
                Customer customer = this.createCustomer(0);
                this.getCustomerIDs().add(customer.getId());
            }
            Assert.assertEquals((String)"failed to create enough Customers", (long)5L, (long)this.getCustomerIDs().size());
            ExecutorService executor = Executors.newFixedThreadPool(5);
            CyclicBarrier barrier = new CyclicBarrier(6);
            ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>(5);
            for (Integer n : this.getCustomerIDs()) {
                Future<Void> future = executor.submit(new UserRunner(n, barrier));
                futures.add(future);
                Thread.sleep(10L);
            }
            barrier.await(2L, TimeUnit.MINUTES);
            log.info((Object)"All threads finished, let's shutdown the executor and check whether any exceptions were reported");
            for (Future future : futures) {
                future.get();
            }
            executor.shutdown();
            log.info((Object)"All future gets checked");
        }
        catch (Throwable t) {
            log.error((Object)"Error running test", t);
            throw t;
        }
    }

    public void cleanup() throws Exception {
        this.getCustomerIDs().clear();
        String deleteContactHQL = "delete from Contact";
        String deleteCustomerHQL = "delete from Customer";
        this.withTxSession(s -> {
            s.createQuery(deleteContactHQL).setFlushMode(FlushMode.AUTO).executeUpdate();
            s.createQuery(deleteCustomerHQL).setFlushMode(FlushMode.AUTO).executeUpdate();
        });
    }

    private Customer createCustomer(int nameSuffix) throws Exception {
        return this.withTxSessionApply(s -> {
            Customer customer = new Customer();
            customer.setName("customer_" + nameSuffix);
            customer.setContacts(new HashSet<Contact>());
            s.persist((Object)customer);
            return customer;
        });
    }

    private void readEveryonesFirstContact() throws Exception {
        this.withTxSession(s -> {
            for (Integer customerId : this.getCustomerIDs()) {
                if (TERMINATE_ALL_USERS) {
                    this.markRollbackOnly((Session)s);
                    return;
                }
                Customer customer = (Customer)s.load(Customer.class, (Serializable)customerId);
                Set<Contact> contacts = customer.getContacts();
                if (contacts.isEmpty()) continue;
                contacts.iterator().next();
            }
        });
    }

    private Contact getFirstContact(Integer customerId) throws Exception {
        assert (customerId != null);
        return this.withTxSessionApply(s -> {
            Contact firstContact;
            Customer customer = (Customer)s.load(Customer.class, (Serializable)customerId);
            Set<Contact> contacts = customer.getContacts();
            Contact contact = firstContact = contacts.isEmpty() ? null : contacts.iterator().next();
            if (TERMINATE_ALL_USERS) {
                this.markRollbackOnly((Session)s);
            }
            return firstContact;
        });
    }

    private Contact addContact(Integer customerId) throws Exception {
        assert (customerId != null);
        return this.withTxSessionApply(s -> {
            Customer customer = (Customer)s.load(Customer.class, (Serializable)customerId);
            Contact contact = new Contact();
            contact.setName("contact name");
            contact.setTlf("wtf is tlf?");
            contact.setCustomer(customer);
            customer.getContacts().add(contact);
            if (TERMINATE_ALL_USERS) {
                this.markRollbackOnly((Session)s);
            }
            return contact;
        });
    }

    private void removeContact(Integer customerId) throws Exception {
        assert (customerId != null);
        this.withTxSession(s -> {
            Customer customer = (Customer)s.load(Customer.class, (Serializable)customerId);
            Set<Contact> contacts = customer.getContacts();
            if (contacts.size() != 1) {
                throw new IllegalStateException("can't remove contact: customer id=" + customerId + " expected exactly 1 contact, actual count=" + contacts.size());
            }
            Contact contact = contacts.iterator().next();
            s.lock((Object)contact, LockMode.PESSIMISTIC_WRITE);
            contacts.remove(contact);
            contact.setCustomer(null);
            if (TERMINATE_ALL_USERS) {
                this.markRollbackOnly((Session)s);
            }
        });
    }

    public Set<Integer> getCustomerIDs() {
        return this.customerIDs;
    }

    private String statusOfRunnersToString(Set<UserRunner> runners) {
        assert (runners != null);
        StringBuilder sb = new StringBuilder("TEST CONFIG [userCount=5, iterationsPerUser=150, thinkTimeMillis=10]  STATE of UserRunners: ");
        for (UserRunner r : runners) {
            sb.append(r.toString()).append(System.lineSeparator());
        }
        return sb.toString();
    }

    public static String getStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        throwable.printStackTrace(pw);
        return sw.getBuffer().toString();
    }

    private void thinkRandomTime() {
        try {
            Thread.sleep(random.nextInt(10));
        }
        catch (InterruptedException ex) {
            throw new RuntimeException("sleep interrupted", ex);
        }
        if (TERMINATE_ALL_USERS) {
            throw new RuntimeException("told to terminate (because a UserRunner had failed)");
        }
    }

    class UserRunner
    implements Callable<Void> {
        private final CyclicBarrier barrier;
        private final Integer customerId;
        private int completedIterations = 0;
        private Throwable causeOfFailure;

        public UserRunner(Integer cId, CyclicBarrier barrier) {
            assert (cId != null);
            this.customerId = cId;
            this.barrier = barrier;
        }

        private boolean contactExists() throws Exception {
            return ConcurrentWriteTest.this.getFirstContact(this.customerId) != null;
        }

        @Override
        public Void call() throws Exception {
            Thread.currentThread().setName("UserRunnerThread-" + this.getCustomerId());
            log.info((Object)"Wait for all executions paths to be ready to perform calls");
            try {
                for (int i = 0; i < 150 && !TERMINATE_ALL_USERS; ++i) {
                    this.contactExists();
                    if (trace) {
                        log.trace((Object)("Add contact for customer " + this.customerId));
                    }
                    ConcurrentWriteTest.this.addContact(this.customerId);
                    if (trace) {
                        log.trace((Object)"Added contact");
                    }
                    ConcurrentWriteTest.this.thinkRandomTime();
                    this.contactExists();
                    ConcurrentWriteTest.this.thinkRandomTime();
                    if (trace) {
                        log.trace((Object)"Read all customers' first contact");
                    }
                    ConcurrentWriteTest.this.readEveryonesFirstContact();
                    if (trace) {
                        log.trace((Object)"Read completed");
                    }
                    ConcurrentWriteTest.this.thinkRandomTime();
                    if (trace) {
                        log.trace((Object)("Remove contact of customer" + this.customerId));
                    }
                    ConcurrentWriteTest.this.removeContact(this.customerId);
                    if (trace) {
                        log.trace((Object)"Removed contact");
                    }
                    this.contactExists();
                    ConcurrentWriteTest.this.thinkRandomTime();
                    ++this.completedIterations;
                    if (!trace) continue;
                    log.tracef("Iteration completed %d", this.completedIterations);
                }
            }
            catch (Throwable t) {
                TERMINATE_ALL_USERS = true;
                log.error((Object)"Error", t);
                throw new Exception(t);
            }
            finally {
                log.info((Object)"Wait for all execution paths to finish");
                this.barrier.await();
            }
            return null;
        }

        public boolean isSuccess() {
            return 150 == this.getCompletedIterations();
        }

        public int getCompletedIterations() {
            return this.completedIterations;
        }

        public Throwable getCauseOfFailure() {
            return this.causeOfFailure;
        }

        public Integer getCustomerId() {
            return this.customerId;
        }

        public String toString() {
            return super.toString() + "[customerId=" + this.getCustomerId() + " iterationsCompleted=" + this.getCompletedIterations() + " completedAll=" + this.isSuccess() + " causeOfFailure=" + (this.causeOfFailure != null ? ConcurrentWriteTest.getStackTrace(this.causeOfFailure) : "") + "] ";
        }
    }
}

