/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.hibernate.cache.functional;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.context.Flag;
import org.infinispan.hibernate.cache.entity.EntityRegionImpl;
import org.infinispan.test.hibernate.cache.functional.SingleNodeTest;
import org.infinispan.test.hibernate.cache.functional.entities.Item;
import org.junit.Assert;
import org.junit.Test;

public class NoTenancyTest
extends SingleNodeTest {
    @Override
    public List<Object[]> getParameters() {
        return Collections.singletonList(READ_ONLY_INVALIDATION);
    }

    @Test
    public void testNoTenancy() throws Exception {
        Item item = new Item("my item", "description");
        this.withTxSession(s -> s.persist((Object)item));
        for (int i = 0; i < 5; ++i) {
            this.withTxSession(s -> {
                Item item2 = (Item)s.get(Item.class, (Serializable)item.getId());
                Assert.assertNotNull((Object)item2);
                Assert.assertEquals((Object)item.getName(), (Object)item2.getName());
            });
        }
        EntityRegionImpl region = (EntityRegionImpl)this.sessionFactory().getSecondLevelCacheRegion(Item.class.getName());
        AdvancedCache localCache = region.getCache().withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL});
        Assert.assertEquals((long)1L, (long)localCache.size());
        try (CloseableIterator iterator = localCache.keySet().iterator();){
            Assert.assertEquals((Object)this.sessionFactory().getClassMetadata(Item.class).getIdentifierType().getReturnedClass(), iterator.next().getClass());
        }
    }
}

