/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.hibernate.cache.functional;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.hibernate.stat.SecondLevelCacheStatistics;
import org.hibernate.stat.Statistics;
import org.infinispan.hibernate.cache.util.InfinispanMessageLogger;
import org.infinispan.test.hibernate.cache.functional.SingleNodeTest;
import org.infinispan.test.hibernate.cache.functional.entities.Item;
import org.infinispan.test.hibernate.cache.util.TestInfinispanRegionFactory;
import org.infinispan.util.ControlledTimeService;
import org.junit.Assert;
import org.junit.Test;

public class ReadOnlyTest
extends SingleNodeTest {
    protected static final InfinispanMessageLogger log = InfinispanMessageLogger.Provider.getLog(ReadOnlyTest.class);
    protected static final ControlledTimeService TIME_SERVICE = new ControlledTimeService();

    @Override
    public List<Object[]> getParameters() {
        return this.getParameters(false, false, true, true);
    }

    @Test
    public void testEmptySecondLevelCacheEntry() throws Exception {
        this.sessionFactory().getCache().evictCollectionRegion(Item.class.getName() + ".items");
        Statistics stats = this.sessionFactory().getStatistics();
        stats.clear();
        SecondLevelCacheStatistics statistics = stats.getSecondLevelCacheStatistics(Item.class.getName() + ".items");
        Map cacheEntries = statistics.getEntries();
        Assert.assertEquals((long)0L, (long)cacheEntries.size());
    }

    @Test
    public void testInsertDeleteEntity() throws Exception {
        Statistics stats = this.sessionFactory().getStatistics();
        stats.clear();
        Item item = new Item("chris", "Chris's Item");
        this.withTxSession(s -> s.persist((Object)item));
        log.info((Object)"Entry persisted, let's load and delete it.");
        this.withTxSession(s -> {
            Item found = (Item)s.load(Item.class, (Serializable)item.getId());
            log.info((Object)stats.toString());
            Assert.assertEquals((Object)item.getDescription(), (Object)found.getDescription());
            Assert.assertEquals((long)0L, (long)stats.getSecondLevelCacheMissCount());
            Assert.assertEquals((long)1L, (long)stats.getSecondLevelCacheHitCount());
            s.delete((Object)found);
        });
    }

    @Test
    public void testInsertClearCacheDeleteEntity() throws Exception {
        Statistics stats = this.sessionFactory().getStatistics();
        stats.clear();
        Item item = new Item("chris", "Chris's Item");
        this.withTxSession(s -> s.persist((Object)item));
        Assert.assertEquals((long)0L, (long)stats.getSecondLevelCacheMissCount());
        Assert.assertEquals((long)0L, (long)stats.getSecondLevelCacheHitCount());
        Assert.assertEquals((long)1L, (long)stats.getSecondLevelCachePutCount());
        log.info((Object)"Entry persisted, let's load and delete it.");
        this.cleanupCache();
        TIME_SERVICE.advance(1L);
        this.withTxSession(s -> {
            Item found = (Item)s.load(Item.class, (Serializable)item.getId());
            log.info((Object)stats.toString());
            Assert.assertEquals((Object)item.getDescription(), (Object)found.getDescription());
            Assert.assertEquals((long)1L, (long)stats.getSecondLevelCacheMissCount());
            Assert.assertEquals((long)0L, (long)stats.getSecondLevelCacheHitCount());
            Assert.assertEquals((long)2L, (long)stats.getSecondLevelCachePutCount());
            s.delete((Object)found);
        });
    }

    @Override
    protected void addSettings(Map settings) {
        super.addSettings(settings);
        settings.put(TestInfinispanRegionFactory.TIME_SERVICE, TIME_SERVICE);
    }
}

