/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.hibernate.cache.functional;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import javax.transaction.Synchronization;
import org.hibernate.PessimisticLockException;
import org.hibernate.Session;
import org.hibernate.StaleStateException;
import org.hibernate.engine.spi.SessionImplementor;
import org.infinispan.AdvancedCache;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commons.util.ByRef;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.hibernate.cache.access.VersionedCallInterceptor;
import org.infinispan.hibernate.cache.impl.BaseTransactionalDataRegion;
import org.infinispan.hibernate.cache.util.Caches;
import org.infinispan.hibernate.cache.util.VersionedEntry;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.test.hibernate.cache.functional.AbstractNonInvalidationTest;
import org.infinispan.test.hibernate.cache.functional.entities.Item;
import org.infinispan.test.hibernate.cache.functional.entities.OtherItem;
import org.junit.Assert;
import org.junit.Test;

public class VersionedTest
extends AbstractNonInvalidationTest {
    @Override
    public List<Object[]> getParameters() {
        return Arrays.asList(NONSTRICT_REPLICATED, NONSTRICT_DISTRIBUTED);
    }

    @Override
    protected boolean getUseQueryCache() {
        return false;
    }

    @Test
    public void testTwoRemoves() throws Exception {
        CyclicBarrier loadBarrier = new CyclicBarrier(2);
        CountDownLatch flushLatch = new CountDownLatch(2);
        CountDownLatch commitLatch = new CountDownLatch(1);
        Future<Boolean> first = this.removeFlushWait(this.itemId, loadBarrier, null, flushLatch, commitLatch);
        Future<Boolean> second = this.removeFlushWait(this.itemId, loadBarrier, null, flushLatch, commitLatch);
        this.awaitOrThrow(flushLatch);
        this.assertSingleCacheEntry();
        commitLatch.countDown();
        boolean firstResult = first.get(2000L, TimeUnit.SECONDS);
        boolean secondResult = second.get(2000L, TimeUnit.SECONDS);
        Assert.assertTrue((firstResult != secondResult ? 1 : 0) != 0);
        this.assertSingleEmpty();
        TIME_SERVICE.advance(this.timeout + 1L);
        this.assertEmptyCache();
    }

    @Test
    public void testRemoveRolledBack() throws Exception {
        this.withTxSession(s -> {
            Item item = (Item)s.load(Item.class, (Serializable)Long.valueOf(this.itemId));
            s.delete((Object)item);
            this.assertSingleCacheEntry();
            s.flush();
            this.assertSingleCacheEntry();
            this.markRollbackOnly((Session)s);
        });
        this.assertSingleCacheEntry();
    }

    @Test
    public void testUpdateRolledBack() throws Exception {
        ByRef entryRef = new ByRef(null);
        this.withTxSession(s -> {
            Item item = (Item)s.load(Item.class, (Serializable)Long.valueOf(this.itemId));
            item.getDescription();
            Object prevEntry = this.assertSingleCacheEntry();
            entryRef.set(prevEntry);
            item.setDescription("Updated item");
            s.update((Object)item);
            Assert.assertEquals((Object)prevEntry, (Object)this.assertSingleCacheEntry());
            s.flush();
            Assert.assertEquals((Object)prevEntry, (Object)this.assertSingleCacheEntry());
            this.markRollbackOnly((Session)s);
        });
        Assert.assertEquals((Object)entryRef.get(), (Object)this.assertSingleCacheEntry());
    }

    @Test
    public void testStaleReadDuringUpdate() throws Exception {
        ByRef<Object> entryRef = this.testStaleRead((s, item) -> {
            item.setDescription("Updated item");
            s.update(item);
        });
        Assert.assertNotEquals((Object)entryRef.get(), (Object)this.assertSingleCacheEntry());
        this.withTxSession(s -> {
            Item item = (Item)s.load(Item.class, (Serializable)Long.valueOf(this.itemId));
            Assert.assertEquals((Object)"Updated item", (Object)item.getDescription());
        });
    }

    @Test
    public void testStaleReadDuringRemove() throws Exception {
        this.testStaleRead((s, item) -> s.delete(item));
        this.assertSingleEmpty();
        this.withTxSession(s -> {
            Item item = (Item)s.get(Item.class, (Serializable)Long.valueOf(this.itemId));
            Assert.assertNull((Object)item);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ByRef<Object> testStaleRead(BiConsumer<Session, Item> consumer) throws Exception {
        final AtomicReference synchronizationException = new AtomicReference();
        final CountDownLatch syncLatch = new CountDownLatch(1);
        final CountDownLatch commitLatch = new CountDownLatch(1);
        Future<Boolean> action = this.executor.submit(() -> this.withTxSessionApply(s -> {
            try {
                ((SessionImplementor)s).getTransactionCoordinator().getLocalSynchronizations().registerSynchronization(new Synchronization(){

                    public void beforeCompletion() {
                    }

                    public void afterCompletion(int i) {
                        syncLatch.countDown();
                        try {
                            VersionedTest.this.awaitOrThrow(commitLatch);
                        }
                        catch (Exception e) {
                            synchronizationException.set(e);
                        }
                    }
                });
                Item item = (Item)s.load(Item.class, (Serializable)Long.valueOf(this.itemId));
                consumer.accept((Session)s, item);
                s.flush();
            }
            catch (StaleStateException e) {
                this.log.info((Object)"Exception thrown: ", (Throwable)e);
                this.markRollbackOnly((Session)s);
                return false;
            }
            catch (PessimisticLockException e) {
                this.log.info((Object)"Exception thrown: ", (Throwable)e);
                this.markRollbackOnly((Session)s);
                return false;
            }
            return true;
        }));
        this.awaitOrThrow(syncLatch);
        ByRef entryRef = new ByRef(null);
        try {
            this.withTxSession(s -> {
                Item item = (Item)s.load(Item.class, (Serializable)Long.valueOf(this.itemId));
                Assert.assertEquals((Object)"Original item", (Object)item.getDescription());
                entryRef.set(this.assertSingleCacheEntry());
            });
        }
        finally {
            commitLatch.countDown();
        }
        Assert.assertTrue((boolean)action.get(2000L, TimeUnit.SECONDS));
        Assert.assertNull(synchronizationException.get());
        return entryRef;
    }

    @Test
    public void testUpdateEvictExpiration() throws Exception {
        CyclicBarrier loadBarrier = new CyclicBarrier(2);
        CountDownLatch preEvictLatch = new CountDownLatch(1);
        CountDownLatch postEvictLatch = new CountDownLatch(1);
        CountDownLatch flushLatch = new CountDownLatch(1);
        CountDownLatch commitLatch = new CountDownLatch(1);
        Future<Boolean> first = this.updateFlushWait(this.itemId, loadBarrier, null, flushLatch, commitLatch);
        Future<Boolean> second = this.evictWait(this.itemId, loadBarrier, preEvictLatch, postEvictLatch);
        this.awaitOrThrow(flushLatch);
        this.assertSingleCacheEntry();
        preEvictLatch.countDown();
        this.awaitOrThrow(postEvictLatch);
        this.assertSingleEmpty();
        commitLatch.countDown();
        first.get(2000L, TimeUnit.SECONDS);
        second.get(2000L, TimeUnit.SECONDS);
        this.assertSingleEmpty();
        TIME_SERVICE.advance(this.timeout + 1L);
        this.assertEmptyCache();
    }

    @Test
    public void testEvictUpdateExpiration() throws Exception {
        this.sessionFactory().getCache().evictEntity(Item.class, (Serializable)Long.valueOf(this.itemId));
        this.assertSingleEmpty();
        TIME_SERVICE.advance(1L);
        this.withTxSession(s -> {
            Item item = (Item)s.load(Item.class, (Serializable)Long.valueOf(this.itemId));
            item.setDescription("Updated item");
            s.update((Object)item);
        });
        this.assertSingleCacheEntry();
        TIME_SERVICE.advance(this.timeout + 1L);
        this.assertSingleCacheEntry();
    }

    @Test
    public void testEvictAndPutFromLoad() throws Exception {
        this.sessionFactory().getCache().evictEntity(Item.class, (Serializable)Long.valueOf(this.itemId));
        this.assertSingleEmpty();
        TIME_SERVICE.advance(1L);
        this.withTxSession(s -> {
            Item item = (Item)s.load(Item.class, (Serializable)Long.valueOf(this.itemId));
            Assert.assertEquals((Object)"Original item", (Object)item.getDescription());
        });
        this.assertSingleCacheEntry();
        TIME_SERVICE.advance(this.TIMEOUT + 1L);
        this.assertSingleCacheEntry();
    }

    @Test
    public void testCollectionUpdate() throws Exception {
        TIME_SERVICE.advance(1L);
        this.withTxSession(s -> {
            Item item = (Item)s.load(Item.class, (Serializable)Long.valueOf(this.itemId));
            OtherItem otherItem = new OtherItem();
            otherItem.setName("Other 1");
            s.persist((Object)otherItem);
            item.addOtherItem(otherItem);
        });
        this.withTxSession(s -> {
            Item item = (Item)s.load(Item.class, (Serializable)Long.valueOf(this.itemId));
            Set<OtherItem> otherItems = item.getOtherItems();
            Assert.assertFalse((boolean)otherItems.isEmpty());
            otherItems.remove(otherItems.iterator().next());
        });
        AdvancedCache collectionCache = ((BaseTransactionalDataRegion)this.sessionFactory().getSecondLevelCacheRegion(Item.class.getName() + ".otherItems")).getCache();
        CountDownLatch putFromLoadLatch = new CountDownLatch(1);
        AtomicBoolean committing = new AtomicBoolean(false);
        CollectionUpdateTestInterceptor collectionUpdateTestInterceptor = new CollectionUpdateTestInterceptor(putFromLoadLatch);
        AnotherCollectionUpdateTestInterceptor anotherInterceptor = new AnotherCollectionUpdateTestInterceptor(putFromLoadLatch, committing);
        AsyncInterceptorChain interceptorChain = collectionCache.getAsyncInterceptorChain();
        interceptorChain.addInterceptorBefore((AsyncInterceptor)collectionUpdateTestInterceptor, VersionedCallInterceptor.class);
        interceptorChain.addInterceptor((AsyncInterceptor)anotherInterceptor, 0);
        TIME_SERVICE.advance(1L);
        Future<Boolean> addFuture = this.executor.submit(() -> this.withTxSessionApply(s -> {
            collectionUpdateTestInterceptor.updateLatch.await();
            Item item = (Item)s.load(Item.class, (Serializable)Long.valueOf(this.itemId));
            OtherItem otherItem = new OtherItem();
            otherItem.setName("Other 2");
            s.persist((Object)otherItem);
            item.addOtherItem(otherItem);
            committing.set(true);
            return true;
        }));
        Future<Boolean> readFuture = this.executor.submit(() -> this.withTxSessionApply(s -> {
            Item item = (Item)s.load(Item.class, (Serializable)Long.valueOf(this.itemId));
            Assert.assertTrue((boolean)item.getOtherItems().isEmpty());
            return true;
        }));
        addFuture.get();
        readFuture.get();
        interceptorChain.removeInterceptor(CollectionUpdateTestInterceptor.class);
        interceptorChain.removeInterceptor(AnotherCollectionUpdateTestInterceptor.class);
        this.withTxSession(s -> Assert.assertFalse((boolean)((Item)s.load(Item.class, (Serializable)Long.valueOf(this.itemId))).getOtherItems().isEmpty()));
    }

    protected void assertSingleEmpty() {
        Map contents = Caches.entrySet((AdvancedCache)this.entityCache).toMap();
        Assert.assertEquals((long)1L, (long)contents.size());
        Object value = contents.get(this.itemId);
        Assert.assertEquals(VersionedEntry.class, value.getClass());
        Assert.assertNull((Object)((VersionedEntry)value).getValue());
    }

    private class AnotherCollectionUpdateTestInterceptor
    extends DDAsyncInterceptor {
        final CountDownLatch putFromLoadLatch;
        final AtomicBoolean committing;

        public AnotherCollectionUpdateTestInterceptor(CountDownLatch putFromLoadLatch, AtomicBoolean committing) {
            this.putFromLoadLatch = putFromLoadLatch;
            this.committing = committing;
        }

        public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
            if (this.committing.get() && !command.hasFlag(Flag.ZERO_LOCK_ACQUISITION_TIMEOUT)) {
                this.putFromLoadLatch.countDown();
            }
            return super.visitPutKeyValueCommand(ctx, command);
        }
    }

    private class CollectionUpdateTestInterceptor
    extends DDAsyncInterceptor {
        final AtomicBoolean firstPutFromLoad = new AtomicBoolean(true);
        final CountDownLatch putFromLoadLatch;
        final CountDownLatch updateLatch = new CountDownLatch(1);

        public CollectionUpdateTestInterceptor(CountDownLatch putFromLoadLatch) {
            this.putFromLoadLatch = putFromLoadLatch;
        }

        public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
            if (command.hasFlag(Flag.ZERO_LOCK_ACQUISITION_TIMEOUT) && this.firstPutFromLoad.compareAndSet(true, false)) {
                this.updateLatch.countDown();
                this.putFromLoadLatch.await();
            }
            return super.visitPutKeyValueCommand(ctx, command);
        }
    }
}

