/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.hibernate.cache.functional.cluster;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.service.UnknownUnwrapTypeException;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.Stoppable;
import org.hibernate.testing.env.ConnectionProviderBuilder;
import org.infinispan.test.hibernate.cache.functional.cluster.DualNodeJtaTransactionImpl;
import org.infinispan.test.hibernate.cache.functional.cluster.DualNodeJtaTransactionManagerImpl;

public class DualNodeConnectionProviderImpl
implements ConnectionProvider,
Configurable {
    private static ConnectionProvider actualConnectionProvider = ConnectionProviderBuilder.buildConnectionProvider();
    private String nodeId;
    private boolean isTransactional;

    public boolean isUnwrappableAs(Class unwrapType) {
        return DualNodeConnectionProviderImpl.class.isAssignableFrom(unwrapType) || ConnectionProvider.class.isAssignableFrom(unwrapType);
    }

    public <T> T unwrap(Class<T> unwrapType) {
        if (DualNodeConnectionProviderImpl.class.isAssignableFrom(unwrapType)) {
            return (T)this;
        }
        if (ConnectionProvider.class.isAssignableFrom(unwrapType)) {
            return (T)actualConnectionProvider;
        }
        throw new UnknownUnwrapTypeException(unwrapType);
    }

    public static ConnectionProvider getActualConnectionProvider() {
        return actualConnectionProvider;
    }

    public void setNodeId(String nodeId) throws HibernateException {
        if (nodeId == null) {
            throw new HibernateException("nodeId not configured");
        }
        this.nodeId = nodeId;
    }

    public Connection getConnection() throws SQLException {
        DualNodeJtaTransactionImpl currentTransaction = DualNodeJtaTransactionManagerImpl.getInstance(this.nodeId).getCurrentTransaction();
        if (currentTransaction == null) {
            this.isTransactional = false;
            return actualConnectionProvider.getConnection();
        }
        this.isTransactional = true;
        Connection connection = currentTransaction.getEnlistedConnection();
        if (connection == null) {
            connection = actualConnectionProvider.getConnection();
            currentTransaction.enlistConnection(connection);
        }
        return connection;
    }

    public void closeConnection(Connection conn) throws SQLException {
        if (!this.isTransactional) {
            conn.close();
        }
    }

    public void close() throws HibernateException {
        if (actualConnectionProvider instanceof Stoppable) {
            ((Stoppable)actualConnectionProvider).stop();
        }
    }

    public boolean supportsAggressiveRelease() {
        return true;
    }

    public void configure(Map configurationValues) {
        this.nodeId = (String)configurationValues.get("nodeId");
    }
}

