/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.hibernate.cache.functional.cluster;

import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.infinispan.Cache;
import org.infinispan.CacheSet;
import org.infinispan.commons.test.categories.Smoke;
import org.infinispan.hibernate.cache.util.InfinispanMessageLogger;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryVisited;
import org.infinispan.notifications.cachelistener.event.CacheEntryVisitedEvent;
import org.infinispan.test.hibernate.cache.functional.cluster.ClusterAwareRegionFactory;
import org.infinispan.test.hibernate.cache.functional.cluster.DualNodeTest;
import org.infinispan.test.hibernate.cache.functional.entities.Citizen;
import org.infinispan.test.hibernate.cache.functional.entities.NaturalIdOnManyToOne;
import org.infinispan.test.hibernate.cache.functional.entities.State;
import org.jboss.util.collection.ConcurrentSet;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={Smoke.class})
public class NaturalIdInvalidationTest
extends DualNodeTest {
    private static final InfinispanMessageLogger log = InfinispanMessageLogger.Provider.getLog(NaturalIdInvalidationTest.class);
    @Rule
    public TestName name = new TestName();

    @Override
    public List<Object[]> getParameters() {
        return this.getParameters(true, true, true, true);
    }

    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Citizen.class, State.class, NaturalIdOnManyToOne.class};
    }

    @Test
    public void testAll() throws Exception {
        log.infof("*** %s", (Object)this.name.getMethodName());
        EmbeddedCacheManager localManager = ClusterAwareRegionFactory.getCacheManager("local");
        Cache localNaturalIdCache = localManager.getCache(Citizen.class.getName() + "##NaturalId");
        MyListener localListener = new MyListener("local");
        localNaturalIdCache.addListener((Object)localListener);
        EmbeddedCacheManager remoteManager = ClusterAwareRegionFactory.getCacheManager("remote");
        Cache remoteNaturalIdCache = remoteManager.getCache(Citizen.class.getName() + "##NaturalId");
        MyListener remoteListener = new MyListener("remote");
        remoteNaturalIdCache.addListener((Object)remoteListener);
        SessionFactoryImplementor localFactory = this.sessionFactory();
        SessionFactoryImplementor remoteFactory = this.secondNodeEnvironment().getSessionFactory();
        try {
            Assert.assertTrue((boolean)remoteListener.isEmpty());
            Assert.assertTrue((boolean)localListener.isEmpty());
            CountDownLatch remoteUpdateLatch = this.getRemoteUpdateLatch(remoteNaturalIdCache);
            this.saveSomeCitizens((SessionFactory)localFactory);
            Assert.assertTrue((boolean)this.await(remoteUpdateLatch));
            Assert.assertTrue((boolean)remoteListener.isEmpty());
            Assert.assertTrue((boolean)localListener.isEmpty());
            log.debug((Object)"Find node 0");
            this.getCitizenWithCriteria((SessionFactory)localFactory);
            log.debug((Object)"Find(2) node 0");
            localListener.clear();
            this.getCitizenWithCriteria((SessionFactory)localFactory);
            log.debug((Object)"Check cache 0");
            this.assertLoadedFromCache(localListener, "1234");
            log.debug((Object)"Find node 1");
            this.getCitizenWithCriteria((SessionFactory)remoteFactory);
            log.debug((Object)"Find(2) node 1");
            remoteListener.clear();
            this.getCitizenWithCriteria((SessionFactory)remoteFactory);
            log.debug((Object)"Check cache 1");
            this.assertLoadedFromCache(remoteListener, "1234");
            remoteListener.clear();
            CountDownLatch localUpdate = this.expectEvict(localNaturalIdCache.getAdvancedCache(), 1);
            this.deleteCitizenWithCriteria((SessionFactory)remoteFactory);
            Assert.assertTrue((boolean)localUpdate.await(2L, TimeUnit.SECONDS));
            CacheSet localKeys = localNaturalIdCache.keySet();
            Assert.assertEquals((long)1L, (long)localKeys.size());
            localKeys.toString().contains("000");
        }
        catch (Exception e) {
            log.error((Object)"Error", (Throwable)e);
            throw e;
        }
        finally {
            if (this.cacheMode.isInvalidation()) {
                this.removeAfterEndInvalidationHandler(remoteNaturalIdCache.getAdvancedCache());
            }
            this.withTxSession((SessionFactory)localFactory, s -> {
                s.createQuery("delete NaturalIdOnManyToOne").executeUpdate();
                s.createQuery("delete Citizen").executeUpdate();
                s.createQuery("delete State").executeUpdate();
            });
        }
    }

    private boolean await(CountDownLatch latch) {
        Assert.assertNotNull((Object)latch);
        try {
            log.debugf("Await latch: %s", (Object)latch);
            boolean await = latch.await(2L, TimeUnit.SECONDS);
            log.debugf("Finished waiting for latch, did latch reach zero? %b", (Object)await);
            return await;
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    public CountDownLatch getRemoteUpdateLatch(Cache remoteNaturalIdCache) {
        CountDownLatch latch = this.cacheMode.isInvalidation() ? (this.useTransactionalCache ? this.expectAfterEndInvalidation(remoteNaturalIdCache.getAdvancedCache(), 1) : this.expectAfterEndInvalidation(remoteNaturalIdCache.getAdvancedCache(), 2)) : this.expectAfterUpdate(remoteNaturalIdCache.getAdvancedCache(), 2);
        log.tracef("Created latch: %s", (Object)latch);
        return latch;
    }

    private void assertLoadedFromCache(MyListener localListener, String id) {
        for (String visited : localListener.visited) {
            if (!visited.contains(id)) continue;
            return;
        }
        Assert.fail((String)("Citizen (" + id + ") should have present in the cache"));
    }

    private void saveSomeCitizens(SessionFactory sf) throws Exception {
        Citizen c1 = new Citizen();
        c1.setFirstname("Emmanuel");
        c1.setLastname("Bernard");
        c1.setSsn("1234");
        State france = new State();
        france.setName("Ile de France");
        c1.setState(france);
        Citizen c2 = new Citizen();
        c2.setFirstname("Gavin");
        c2.setLastname("King");
        c2.setSsn("000");
        State australia = new State();
        australia.setName("Australia");
        c2.setState(australia);
        this.withTxSession(sf, s -> {
            s.persist((Object)australia);
            s.persist((Object)france);
            s.persist((Object)c1);
            s.persist((Object)c2);
        });
    }

    private void getCitizenWithCriteria(SessionFactory sf) throws Exception {
        this.withTxSession(sf, s -> {
            State france = this.getState((Session)s, "Ile de France");
            Criteria criteria = s.createCriteria(Citizen.class);
            criteria.add((Criterion)Restrictions.naturalId().set("ssn", (Object)"1234").set("state", (Object)france));
            criteria.setCacheable(true);
            criteria.list();
        });
    }

    private void deleteCitizenWithCriteria(SessionFactory sf) throws Exception {
        this.withTxSession(sf, s -> {
            State france = this.getState((Session)s, "Ile de France");
            Criteria criteria = s.createCriteria(Citizen.class);
            criteria.add((Criterion)Restrictions.naturalId().set("ssn", (Object)"1234").set("state", (Object)france));
            criteria.setCacheable(true);
            Citizen c = (Citizen)criteria.uniqueResult();
            s.delete((Object)c);
        });
    }

    private State getState(Session s, String name) {
        Criteria criteria = s.createCriteria(State.class);
        criteria.add((Criterion)Restrictions.eq((String)"name", (Object)name));
        criteria.setCacheable(true);
        return (State)criteria.list().get(0);
    }

    @Listener
    public static class MyListener {
        private static final InfinispanMessageLogger log = InfinispanMessageLogger.Provider.getLog(MyListener.class);
        private Set<String> visited = new ConcurrentSet();
        private final String name;

        public MyListener(String name) {
            this.name = name;
        }

        public void clear() {
            this.visited.clear();
        }

        public boolean isEmpty() {
            return this.visited.isEmpty();
        }

        @CacheEntryVisited
        public void nodeVisited(CacheEntryVisitedEvent event) {
            log.debug((Object)event.toString());
            if (!event.isPre()) {
                this.visited.add(event.getKey().toString());
            }
        }
    }
}

