/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.hibernate.cache.functional.cluster;

import java.util.List;
import java.util.Map;
import org.hibernate.SessionFactory;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.infinispan.Cache;
import org.infinispan.hibernate.cache.InfinispanRegionFactory;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.hibernate.cache.functional.cluster.AccountDAO;
import org.infinispan.test.hibernate.cache.functional.cluster.ClusterAwareRegionFactory;
import org.infinispan.test.hibernate.cache.functional.cluster.DualNodeJtaTransactionManagerImpl;
import org.infinispan.test.hibernate.cache.functional.cluster.DualNodeTest;
import org.infinispan.test.hibernate.cache.functional.entities.Account;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.junit.Test;

public class SessionRefreshTest
extends DualNodeTest {
    private static final Logger log = Logger.getLogger(SessionRefreshTest.class);
    private Cache localCache;

    @Override
    public List<Object[]> getParameters() {
        return this.getParameters(true, true, false, true);
    }

    @Override
    protected void configureSecondNode(StandardServiceRegistryBuilder ssrb) {
        super.configureSecondNode(ssrb);
        ssrb.applySetting("hibernate.cache.use_second_level_cache", (Object)"false");
    }

    @Override
    protected void applyStandardSettings(Map settings) {
        super.applyStandardSettings(settings);
        settings.put(InfinispanRegionFactory.ENTITY_CACHE_RESOURCE_PROP, this.getEntityCacheConfigName());
    }

    protected String getEntityCacheConfigName() {
        return "entity";
    }

    @Override
    protected String getBaseForMappings() {
        return "org/infinispan/test/";
    }

    @Override
    public String[] getMappings() {
        return new String[]{"hibernate/cache/functional/entities/Account.hbm.xml"};
    }

    @Override
    protected void cleanupTransactionManagement() {
        DualNodeJtaTransactionManagerImpl.cleanupTransactions();
    }

    @Test
    public void testRefreshAfterExternalChange() throws Exception {
        EmbeddedCacheManager localManager = ClusterAwareRegionFactory.getCacheManager("local");
        this.localCache = localManager.getCache(Account.class.getName());
        SessionFactoryImplementor localFactory = this.sessionFactory();
        SessionFactoryImplementor remoteFactory = this.secondNodeEnvironment().getSessionFactory();
        AccountDAO dao0 = new AccountDAO(this.useJta, (SessionFactory)localFactory);
        AccountDAO dao1 = new AccountDAO(this.useJta, (SessionFactory)remoteFactory);
        Integer id = new Integer(1);
        dao0.createAccount(dao0.getSmith(), id, new Integer(5), "local");
        Account acct1 = dao1.getAccount(id);
        Assert.assertNotNull((Object)acct1);
        Assert.assertEquals((Object)"local", (Object)acct1.getBranch());
        dao1.updateAccountBranch(id, "remote");
        Account acct0 = dao0.getAccount(id);
        Assert.assertNotNull((Object)acct0);
        Assert.assertEquals((Object)"local", (Object)acct0.getBranch());
        log.debug((Object)("Contents when re-reading from local: " + TestingUtil.printCache((Cache)this.localCache)));
        acct0 = dao0.getAccountWithRefresh(id);
        Assert.assertNotNull((Object)acct0);
        Assert.assertEquals((Object)"remote", (Object)acct0.getBranch());
        log.debug((Object)("Contents after refreshing in remote: " + TestingUtil.printCache((Cache)this.localCache)));
        AccountDAO dao0A = new AccountDAO(this.useJta, (SessionFactory)localFactory);
        Account acct0A = dao0A.getAccount(id);
        Assert.assertNotNull((Object)acct0A);
        Assert.assertEquals((Object)"remote", (Object)acct0A.getBranch());
        log.debug((Object)("Contents after creating a new session: " + TestingUtil.printCache((Cache)this.localCache)));
    }
}

