/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.hibernate.cache.util;

import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.hibernate.HibernateException;
import org.hibernate.TransactionException;
import org.hibernate.engine.transaction.internal.jta.JtaStatusHelper;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.infinispan.transaction.tm.BatchModeTransactionManager;

public class BatchModeJtaPlatform
implements JtaPlatform {
    public TransactionManager retrieveTransactionManager() {
        try {
            return BatchModeTransactionManager.getInstance();
        }
        catch (Exception e) {
            throw new HibernateException("Failed getting BatchModeTransactionManager", (Throwable)e);
        }
    }

    public UserTransaction retrieveUserTransaction() {
        throw new UnsupportedOperationException();
    }

    public Object getTransactionIdentifier(Transaction transaction) {
        return transaction;
    }

    public boolean canRegisterSynchronization() {
        return JtaStatusHelper.isActive((TransactionManager)this.retrieveTransactionManager());
    }

    public void registerSynchronization(Synchronization synchronization) {
        try {
            this.retrieveTransactionManager().getTransaction().registerSynchronization(synchronization);
        }
        catch (Exception e) {
            throw new TransactionException("Could not obtain transaction from TM");
        }
    }

    public int getCurrentStatus() throws SystemException {
        return JtaStatusHelper.getStatus((TransactionManager)this.retrieveTransactionManager());
    }
}

