/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.hibernate.cache.util;

import org.infinispan.test.fwk.TestResourceTracker;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public final class InfinispanTestingSetup
implements TestRule {
    private volatile String runningTest;

    public Statement apply(final Statement base, Description d) {
        String testName;
        String methodName = d.getMethodName();
        this.runningTest = testName = methodName == null ? d.getClassName() : d.getClassName() + "#" + d.getMethodName();
        return new Statement(){

            public void evaluate() throws Throwable {
                TestResourceTracker.testStarted((String)testName);
                try {
                    base.evaluate();
                }
                finally {
                    TestResourceTracker.testFinished((String)testName);
                }
            }
        };
    }

    public void joinContext() {
        TestResourceTracker.setThreadTestName((String)this.runningTest);
    }
}

