/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.hibernate.cache.main.util;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.GeneralDataRegion;
import org.hibernate.cache.spi.access.EntityRegionAccessStrategy;
import org.hibernate.cache.spi.access.RegionAccessStrategy;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.jdbc.connections.spi.JdbcConnectionAccess;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.transaction.internal.TransactionImpl;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.query.Query;
import org.hibernate.resource.jdbc.spi.JdbcSessionContext;
import org.hibernate.resource.jdbc.spi.JdbcSessionOwner;
import org.hibernate.resource.transaction.backend.jdbc.internal.JdbcResourceLocalTransactionCoordinatorBuilderImpl;
import org.hibernate.resource.transaction.backend.jdbc.spi.JdbcResourceTransactionAccess;
import org.hibernate.resource.transaction.spi.TransactionCoordinator;
import org.hibernate.resource.transaction.spi.TransactionCoordinatorOwner;
import org.hibernate.service.ServiceRegistry;
import org.infinispan.test.hibernate.cache.commons.util.BatchModeJtaPlatform;
import org.infinispan.test.hibernate.cache.commons.util.JdbcResourceTransactionMock;
import org.infinispan.test.hibernate.cache.commons.util.TestSessionAccess;
import org.infinispan.test.hibernate.cache.main.util.BatchModeTransactionCoordinator;
import org.infinispan.util.ControlledTimeService;
import org.mockito.Mockito;

public class TestSessionAccessImpl
implements TestSessionAccess {
    public Object mockSessionImplementor() {
        return Mockito.mock(SharedSessionContractImplementor.class);
    }

    public Object mockSession(Class<? extends JtaPlatform> jtaPlatform, ControlledTimeService timeService) {
        SessionMock session = (SessionMock)Mockito.mock(SessionMock.class);
        Mockito.when((Object)session.isClosed()).thenReturn((Object)false);
        Mockito.when((Object)session.getTimestamp()).thenReturn((Object)timeService.wallClockTime());
        if (jtaPlatform == BatchModeJtaPlatform.class) {
            BatchModeTransactionCoordinator txCoord = new BatchModeTransactionCoordinator();
            Mockito.when((Object)session.getTransactionCoordinator()).thenReturn((Object)txCoord);
            Mockito.when((Object)session.beginTransaction()).then(invocation -> {
                Transaction tx = txCoord.newTransaction();
                tx.begin();
                return tx;
            });
        } else if (jtaPlatform == null) {
            Connection connection = (Connection)Mockito.mock(Connection.class);
            JdbcConnectionAccess jdbcConnectionAccess = (JdbcConnectionAccess)Mockito.mock(JdbcConnectionAccess.class);
            try {
                Mockito.when((Object)jdbcConnectionAccess.obtainConnection()).thenReturn((Object)connection);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            JdbcSessionOwner jdbcSessionOwner = (JdbcSessionOwner)Mockito.mock(JdbcSessionOwner.class);
            Mockito.when((Object)jdbcSessionOwner.getJdbcConnectionAccess()).thenReturn((Object)jdbcConnectionAccess);
            SqlExceptionHelper sqlExceptionHelper = (SqlExceptionHelper)Mockito.mock(SqlExceptionHelper.class);
            JdbcServices jdbcServices = (JdbcServices)Mockito.mock(JdbcServices.class);
            Mockito.when((Object)jdbcServices.getSqlExceptionHelper()).thenReturn((Object)sqlExceptionHelper);
            ServiceRegistry serviceRegistry = (ServiceRegistry)Mockito.mock(ServiceRegistry.class);
            Mockito.when((Object)serviceRegistry.getService(JdbcServices.class)).thenReturn((Object)jdbcServices);
            JdbcSessionContext jdbcSessionContext = (JdbcSessionContext)Mockito.mock(JdbcSessionContext.class);
            Mockito.when((Object)jdbcSessionContext.getServiceRegistry()).thenReturn((Object)serviceRegistry);
            Mockito.when((Object)jdbcSessionOwner.getJdbcSessionContext()).thenReturn((Object)jdbcSessionContext);
            NonJtaTransactionCoordinator txOwner = (NonJtaTransactionCoordinator)Mockito.mock(NonJtaTransactionCoordinator.class);
            Mockito.when((Object)txOwner.getResourceLocalTransaction()).thenReturn((Object)new JdbcResourceTransactionMock());
            Mockito.when((Object)txOwner.getJdbcSessionOwner()).thenReturn((Object)jdbcSessionOwner);
            Mockito.when((Object)txOwner.isActive()).thenReturn((Object)true);
            TransactionCoordinator txCoord = JdbcResourceLocalTransactionCoordinatorBuilderImpl.INSTANCE.buildTransactionCoordinator((TransactionCoordinatorOwner)txOwner, null);
            Mockito.when((Object)session.getTransactionCoordinator()).thenReturn((Object)txCoord);
            Mockito.when((Object)session.beginTransaction()).then(invocation -> {
                TransactionImpl tx = new TransactionImpl(txCoord, session.getExceptionConverter());
                tx.begin();
                return tx;
            });
        } else {
            throw new IllegalStateException("Unknown JtaPlatform: " + jtaPlatform);
        }
        return session;
    }

    public Transaction beginTransaction(Object session) {
        return ((Session)session).beginTransaction();
    }

    public TestSessionAccess.TestRegionAccessStrategy fromAccessStrategy(RegionAccessStrategy strategy) {
        return new TestRegionAccessStrategyImpl(strategy);
    }

    public TestSessionAccess.TestGeneralDataRegion fromGeneralDataRegion(GeneralDataRegion region) {
        return new TestGeneralDataRegionImpl(region);
    }

    public List execQueryList(Object session, String query, String[] ... params) {
        Query q = ((Session)session).createQuery(query);
        this.setParams(q, params);
        return q.list();
    }

    public List execQueryListAutoFlush(Object session, String query, String[] ... params) {
        Query q = ((Session)session).createQuery(query).setFlushMode(FlushMode.AUTO);
        this.setParams(q, params);
        return q.list();
    }

    public List execQueryListCacheable(Object session, String query) {
        return ((Session)session).createQuery(query).setCacheable(true).list();
    }

    public int execQueryUpdateAutoFlush(Object session, String query, String[] ... params) {
        Query q = ((Session)session).createQuery(query).setFlushMode(FlushMode.AUTO);
        this.setParams(q, params);
        return q.executeUpdate();
    }

    public void setParams(Query q, String[][] params) {
        if (params.length > 0) {
            for (String[] param : params) {
                q.setParameter(param[0], (Object)param[1]);
            }
        }
    }

    public void execQueryUpdate(Object session, String query) {
        ((Session)session).createQuery(query).executeUpdate();
    }

    private static SharedSessionContractImplementor unwrap(Object session) {
        return (SharedSessionContractImplementor)session;
    }

    private static final class TestGeneralDataRegionImpl
    implements TestSessionAccess.TestGeneralDataRegion {
        private final GeneralDataRegion delegate;

        private TestGeneralDataRegionImpl(GeneralDataRegion delegate) {
            this.delegate = delegate;
        }

        public Object get(Object session, Object key) throws CacheException {
            return this.delegate.get(TestSessionAccessImpl.unwrap(session), key);
        }

        public void put(Object session, Object key, Object value) throws CacheException {
            this.delegate.put(TestSessionAccessImpl.unwrap(session), key, value);
        }
    }

    private static interface NonJtaTransactionCoordinator
    extends TransactionCoordinatorOwner,
    JdbcResourceTransactionAccess {
    }

    private static interface SessionMock
    extends Session,
    SharedSessionContractImplementor {
    }

    private static final class TestRegionAccessStrategyImpl
    implements TestSessionAccess.TestRegionAccessStrategy {
        private final RegionAccessStrategy delegate;

        public TestRegionAccessStrategyImpl(RegionAccessStrategy delegate) {
            this.delegate = delegate;
        }

        public SoftLock lockItem(Object session, Object key, Object version) throws CacheException {
            return this.delegate.lockItem(TestSessionAccessImpl.unwrap(session), key, version);
        }

        public void unlockItem(Object session, Object key, SoftLock lock) throws CacheException {
            this.delegate.unlockItem(TestSessionAccessImpl.unwrap(session), key, lock);
        }

        public boolean afterInsert(Object session, Object key, Object value, Object version) throws CacheException {
            return this.unwrapEntity().afterInsert(TestSessionAccessImpl.unwrap(session), key, value, version);
        }

        public boolean afterUpdate(Object session, Object key, Object value, Object currentVersion, Object previousVersion, SoftLock lock) throws CacheException {
            return this.unwrapEntity().afterUpdate(TestSessionAccessImpl.unwrap(session), key, value, currentVersion, previousVersion, lock);
        }

        public Object get(Object session, Object key, long txTimestamp) throws CacheException {
            return this.delegate.get(TestSessionAccessImpl.unwrap(session), key, txTimestamp);
        }

        public boolean putFromLoad(Object session, Object key, Object value, long txTimestamp, Object version, boolean minimalPutOverride) throws CacheException {
            return this.delegate.putFromLoad(TestSessionAccessImpl.unwrap(session), key, value, txTimestamp, version, minimalPutOverride);
        }

        public boolean putFromLoad(Object session, Object key, Object value, long txTimestamp, Object version) throws CacheException {
            return this.delegate.putFromLoad(TestSessionAccessImpl.unwrap(session), key, value, txTimestamp, version);
        }

        public void remove(Object session, Object key) throws CacheException {
            this.delegate.remove(TestSessionAccessImpl.unwrap(session), key);
        }

        public boolean insert(Object session, Object key, Object value, Object version) throws CacheException {
            return this.unwrapEntity().insert(TestSessionAccessImpl.unwrap(session), key, value, version);
        }

        public boolean update(Object session, Object key, Object value, Object currentVersion, Object previousVersion) throws CacheException {
            return this.unwrapEntity().update(TestSessionAccessImpl.unwrap(session), key, value, currentVersion, previousVersion);
        }

        private EntityRegionAccessStrategy unwrapEntity() {
            return (EntityRegionAccessStrategy)this.delegate;
        }
    }
}

