/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.main;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import javax.transaction.TransactionManager;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.internal.DefaultCacheKeysFactory;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cache.spi.CacheKeysFactory;
import org.hibernate.cache.spi.CollectionRegion;
import org.hibernate.cache.spi.EntityRegion;
import org.hibernate.cache.spi.NaturalIdRegion;
import org.hibernate.cache.spi.QueryResultsRegion;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.TimestampsRegion;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.service.ServiceRegistry;
import org.infinispan.AdvancedCache;
import org.infinispan.commands.module.ModuleCommandFactory;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.TransactionConfiguration;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.hibernate.cache.commons.DataType;
import org.infinispan.hibernate.cache.commons.DefaultCacheManagerProvider;
import org.infinispan.hibernate.cache.commons.InfinispanBaseRegion;
import org.infinispan.hibernate.cache.commons.TimeSource;
import org.infinispan.hibernate.cache.commons.util.CacheCommandFactory;
import org.infinispan.hibernate.cache.commons.util.Caches;
import org.infinispan.hibernate.cache.commons.util.InfinispanMessageLogger;
import org.infinispan.hibernate.cache.main.collection.CollectionRegionImpl;
import org.infinispan.hibernate.cache.main.entity.EntityRegionImpl;
import org.infinispan.hibernate.cache.main.impl.BaseRegion;
import org.infinispan.hibernate.cache.main.naturalid.NaturalIdRegionImpl;
import org.infinispan.hibernate.cache.main.query.QueryResultsRegionImpl;
import org.infinispan.hibernate.cache.main.timestamp.ClusteredTimestampsRegionImpl;
import org.infinispan.hibernate.cache.main.timestamp.TimestampsRegionImpl;
import org.infinispan.hibernate.cache.main.tm.HibernateTransactionManagerLookup;
import org.infinispan.hibernate.cache.spi.EmbeddedCacheManagerProvider;
import org.infinispan.hibernate.cache.spi.InfinispanProperties;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.transaction.lookup.GenericTransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionManagerLookup;

public class InfinispanRegionFactory
implements RegionFactory,
TimeSource,
InfinispanProperties {
    private static final InfinispanMessageLogger log = InfinispanMessageLogger.Provider.getLog(InfinispanRegionFactory.class);
    protected final Map<String, String> baseConfigurations = new HashMap<String, String>();
    protected final Map<String, ConfigurationBuilder> configOverrides = new HashMap<String, ConfigurationBuilder>();
    private CacheKeysFactory cacheKeysFactory;
    private final Map<DataType, Configuration> dataTypeConfigurations = new HashMap<DataType, Configuration>();
    private EmbeddedCacheManager manager;
    private TransactionManagerLookup transactionManagerlookup;
    private TransactionManager transactionManager;
    private List<BaseRegion> regions = new ArrayList<BaseRegion>();
    private SessionFactoryOptions settings;
    private Boolean globalStats;

    public InfinispanRegionFactory() {
    }

    public InfinispanRegionFactory(Properties props) {
        this();
    }

    public CollectionRegion buildCollectionRegion(String regionName, Properties properties, CacheDataDescription metadata) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Building collection cache region [" + regionName + "]"));
        }
        AdvancedCache cache = this.getCache(regionName, DataType.COLLECTION, metadata);
        CollectionRegionImpl region = new CollectionRegionImpl(cache, regionName, this.transactionManager, metadata, this, this.getCacheKeysFactory());
        this.startRegion(region);
        return region;
    }

    public EntityRegion buildEntityRegion(String regionName, Properties properties, CacheDataDescription metadata) {
        if (log.isDebugEnabled()) {
            log.debugf("Building entity cache region [%s] (mutable=%s, versioned=%s)", (Object)regionName, (Object)metadata.isMutable(), (Object)metadata.isVersioned());
        }
        AdvancedCache cache = this.getCache(regionName, metadata.isMutable() ? DataType.ENTITY : DataType.IMMUTABLE_ENTITY, metadata);
        EntityRegionImpl region = new EntityRegionImpl(cache, regionName, this.transactionManager, metadata, this, this.getCacheKeysFactory());
        this.startRegion(region);
        return region;
    }

    public NaturalIdRegion buildNaturalIdRegion(String regionName, Properties properties, CacheDataDescription metadata) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Building natural id cache region [" + regionName + "]"));
        }
        AdvancedCache cache = this.getCache(regionName, DataType.NATURAL_ID, metadata);
        NaturalIdRegionImpl region = new NaturalIdRegionImpl(cache, regionName, this.transactionManager, metadata, this, this.getCacheKeysFactory());
        this.startRegion(region);
        return region;
    }

    public QueryResultsRegion buildQueryResultsRegion(String regionName, Properties properties) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Building query results cache region [" + regionName + "]"));
        }
        AdvancedCache cache = this.getCache(regionName, DataType.QUERY, null);
        QueryResultsRegionImpl region = new QueryResultsRegionImpl(cache, regionName, this.transactionManager, this);
        this.startRegion(region);
        return region;
    }

    public TimestampsRegion buildTimestampsRegion(String regionName, Properties properties) {
        AdvancedCache cache;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Building timestamps cache region [" + regionName + "]"));
        }
        TimestampsRegionImpl region = Caches.isClustered((AdvancedCache)(cache = this.getCache(regionName, DataType.TIMESTAMPS, null))) ? new ClusteredTimestampsRegionImpl(cache, regionName, this) : new TimestampsRegionImpl(cache, regionName, this);
        this.startRegion(region);
        return region;
    }

    public Configuration getPendingPutsCacheConfiguration() {
        return this.dataTypeConfigurations.get(DataType.PENDING_PUTS);
    }

    protected CacheKeysFactory getCacheKeysFactory() {
        return this.cacheKeysFactory;
    }

    public boolean isMinimalPutsEnabledByDefault() {
        return true;
    }

    public AccessType getDefaultAccessType() {
        return AccessType.TRANSACTIONAL;
    }

    public long nextTimestamp() {
        return System.currentTimeMillis();
    }

    public void setCacheManager(EmbeddedCacheManager manager) {
        this.manager = manager;
    }

    public EmbeddedCacheManager getCacheManager() {
        return this.manager;
    }

    public void start(SessionFactoryOptions settings, Properties properties) throws CacheException {
        log.debug((Object)"Starting Infinispan region factory");
        this.cacheKeysFactory = this.determineCacheKeysFactory(settings, properties);
        try {
            this.settings = settings;
            this.transactionManagerlookup = this.createTransactionManagerLookup(settings, properties);
            this.transactionManager = this.transactionManagerlookup.getTransactionManager();
            Enumeration<?> keys = properties.propertyNames();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                int prefixLoc = key.indexOf("hibernate.cache.infinispan.");
                if (prefixLoc == -1) continue;
                this.parseProperty(prefixLoc, key, this.extractProperty(key, properties));
            }
            String globalStatsProperty = ConfigurationHelper.extractPropertyValue((String)"hibernate.cache.infinispan.statistics", (Properties)properties);
            Boolean bl = this.globalStats = globalStatsProperty != null ? Boolean.valueOf(globalStatsProperty) : null;
            if (properties.containsKey("hibernate.cache.infinispan.use_synchronization")) {
                log.propertyUseSynchronizationDeprecated();
            }
            StandardServiceRegistry serviceRegistry = settings.getServiceRegistry();
            this.manager = this.createCacheManager(properties, (ServiceRegistry)serviceRegistry);
            this.defineDataTypeCacheConfigurations((ServiceRegistry)serviceRegistry);
        }
        catch (CacheException ce) {
            throw ce;
        }
        catch (Throwable t) {
            throw log.unableToStart(t);
        }
    }

    private CacheKeysFactory determineCacheKeysFactory(SessionFactoryOptions settings, Properties properties) {
        return (CacheKeysFactory)((StrategySelector)settings.getServiceRegistry().getService(StrategySelector.class)).resolveDefaultableStrategy(CacheKeysFactory.class, properties.get("hibernate.cache.keys_factory"), (Object)DefaultCacheKeysFactory.INSTANCE);
    }

    protected EmbeddedCacheManager createCacheManager(Properties properties, ServiceRegistry serviceRegistry) {
        for (EmbeddedCacheManagerProvider provider : ServiceLoader.load(EmbeddedCacheManagerProvider.class, EmbeddedCacheManagerProvider.class.getClassLoader())) {
            EmbeddedCacheManager cacheManager = provider.getEmbeddedCacheManager(properties);
            if (cacheManager == null) continue;
            return cacheManager;
        }
        return new DefaultCacheManagerProvider(serviceRegistry).getEmbeddedCacheManager(properties);
    }

    protected TransactionManagerLookup createTransactionManagerLookup(SessionFactoryOptions settings, Properties properties) {
        return new HibernateTransactionManagerLookup(settings, properties);
    }

    public void stop() {
        log.debug((Object)"Stop region factory");
        this.stopCacheRegions();
        this.stopCacheManager();
    }

    protected void stopCacheRegions() {
        log.debug((Object)"Clear region references");
        this.getCacheCommandFactory().clearRegions(this.regions);
        this.regions.forEach(region -> {
            region.destroy();
            this.manager.undefineConfiguration(region.getCache().getName());
        });
        this.regions.clear();
    }

    protected void stopCacheManager() {
        log.debug((Object)"Stop cache manager");
        this.manager.stop();
    }

    private void startRegion(BaseRegion region) {
        this.regions.add(region);
        this.getCacheCommandFactory().addRegion((InfinispanBaseRegion)region);
    }

    private void parseProperty(int prefixLoc, String key, String value) {
        int suffixLoc = key.indexOf(".cfg");
        if (suffixLoc != -1 && !key.equals("hibernate.cache.infinispan.cfg")) {
            String regionName = key.substring(prefixLoc + "hibernate.cache.infinispan.".length(), suffixLoc);
            this.baseConfigurations.put(regionName, value);
        } else if (key.contains(".eviction.strategy")) {
            log.ignoringDeprecatedProperty(".eviction.strategy");
        } else {
            suffixLoc = key.indexOf(".expiration.wake_up_interval");
            if (suffixLoc != -1 || (suffixLoc = key.indexOf(".eviction.wake_up_interval")) != -1) {
                ConfigurationBuilder builder = this.getOrCreateConfig(prefixLoc, key, suffixLoc);
                builder.expiration().wakeUpInterval(Long.parseLong(value));
            } else {
                suffixLoc = key.indexOf(".memory.size");
                if (suffixLoc != -1) {
                    ConfigurationBuilder builder = this.getOrCreateConfig(prefixLoc, key, suffixLoc);
                    builder.memory().size(Long.parseLong(value));
                } else {
                    suffixLoc = key.indexOf(".eviction.max_entries");
                    if (suffixLoc != -1) {
                        log.deprecatedProperty(".eviction.max_entries", ".memory.size");
                        ConfigurationBuilder builder = this.getOrCreateConfig(prefixLoc, key, suffixLoc);
                        builder.memory().size(Long.parseLong(value));
                    } else {
                        suffixLoc = key.indexOf(".expiration.lifespan");
                        if (suffixLoc != -1) {
                            ConfigurationBuilder builder = this.getOrCreateConfig(prefixLoc, key, suffixLoc);
                            builder.expiration().lifespan(Long.parseLong(value));
                        } else {
                            suffixLoc = key.indexOf(".expiration.max_idle");
                            if (suffixLoc != -1) {
                                ConfigurationBuilder builder = this.getOrCreateConfig(prefixLoc, key, suffixLoc);
                                builder.expiration().maxIdle(Long.parseLong(value));
                            }
                        }
                    }
                }
            }
        }
    }

    private String extractProperty(String key, Properties properties) {
        String value = ConfigurationHelper.extractPropertyValue((String)key, (Properties)properties);
        log.debugf("Configuration override via property %s: %s", (Object)key, (Object)value);
        return value;
    }

    private ConfigurationBuilder getOrCreateConfig(int prefixLoc, String key, int suffixLoc) {
        String name = key.substring(prefixLoc + "hibernate.cache.infinispan.".length(), suffixLoc);
        return this.configOverrides.computeIfAbsent(name, Void -> new ConfigurationBuilder());
    }

    private void defineDataTypeCacheConfigurations(ServiceRegistry serviceRegistry) {
        String defaultResource = this.manager.getCacheManagerConfiguration().isClustered() ? "org/infinispan/hibernate/cache/commons/builder/infinispan-configs.xml" : "org/infinispan/hibernate/cache/commons/builder/infinispan-configs-local.xml";
        ConfigurationBuilderHolder defaultConfiguration = DefaultCacheManagerProvider.loadConfiguration((ServiceRegistry)serviceRegistry, (String)defaultResource);
        for (DataType type : DataType.values()) {
            ConfigurationBuilder override;
            ConfigurationBuilder builder;
            Configuration configuration;
            String cacheName = this.baseConfigurations.get(type.key);
            if (cacheName == null) {
                cacheName = type.defaultCacheName;
            }
            if ((configuration = this.manager.getCacheConfiguration(cacheName)) == null) {
                log.debugf("Cache configuration not found for %s", (Object)type);
                if (!cacheName.equals(type.defaultCacheName)) {
                    log.customConfigForTypeNotFound(cacheName, type.key);
                }
                if ((builder = (ConfigurationBuilder)defaultConfiguration.getNamedConfigurationBuilders().get(type.defaultCacheName)) == null) {
                    throw new IllegalStateException("Generic data types must have default configuration, none found for " + type);
                }
            } else {
                builder = new ConfigurationBuilder().read(configuration);
            }
            if ((override = this.configOverrides.get(type.key)) != null) {
                builder.read(override.build(false));
            }
            builder.template(true);
            this.configureTransactionManager(builder);
            this.dataTypeConfigurations.put(type, builder.build());
        }
    }

    protected AdvancedCache getCache(String regionName, DataType type, CacheDataDescription metadata) {
        AdvancedCache cache;
        if (!this.manager.cacheExists(regionName)) {
            ConfigurationBuilder override;
            String templateCacheName = this.baseConfigurations.get(regionName);
            Configuration configuration = null;
            ConfigurationBuilder builder = new ConfigurationBuilder();
            if (templateCacheName != null) {
                configuration = this.manager.getCacheConfiguration(templateCacheName);
                if (configuration == null) {
                    log.customConfigForRegionNotFound(templateCacheName, regionName, type.key);
                } else {
                    log.debugf("Region '%s' will use cache template '%s'", (Object)regionName, (Object)templateCacheName);
                    builder.read(configuration);
                    this.configureTransactionManager(builder);
                }
            }
            if (configuration == null) {
                configuration = this.dataTypeConfigurations.get(type);
                if (configuration == null) {
                    throw new IllegalStateException("Configuration not defined for type " + type.key);
                }
                builder.read(configuration);
            }
            if ((override = this.configOverrides.get(regionName)) != null) {
                log.debugf("Region '%s' has additional configuration set through properties.", (Object)regionName);
                builder.read(override.build(false));
            }
            if (this.globalStats != null) {
                builder.jmxStatistics().enabled(this.globalStats.booleanValue()).available(this.globalStats.booleanValue());
            }
            configuration = builder.build();
            type.validate(configuration);
            this.manager.defineConfiguration(regionName, configuration);
        }
        if (!(cache = this.manager.getCache(regionName).getAdvancedCache()).getStatus().allowInvocations()) {
            cache.start();
        }
        return cache;
    }

    private CacheCommandFactory getCacheCommandFactory() {
        GlobalComponentRegistry globalCr = this.manager.getGlobalComponentRegistry();
        Map factories = (Map)globalCr.getComponent("org.infinispan.modules.command.factories");
        for (ModuleCommandFactory factory : factories.values()) {
            if (!(factory instanceof CacheCommandFactory)) continue;
            return (CacheCommandFactory)factory;
        }
        throw log.cannotInstallCommandFactory();
    }

    private void configureTransactionManager(ConfigurationBuilder builder) {
        TransactionConfiguration transaction = builder.transaction().create();
        if (transaction.transactionMode().isTransactional()) {
            String ispnTmLookupClassName = transaction.transactionManagerLookup().getClass().getName();
            String hbTmLookupClassName = HibernateTransactionManagerLookup.class.getName();
            if (GenericTransactionManagerLookup.class.getName().equals(ispnTmLookupClassName)) {
                log.debug((Object)"Using default Infinispan transaction manager lookup instance (GenericTransactionManagerLookup), overriding it with Hibernate transaction manager lookup");
                builder.transaction().transactionManagerLookup(this.transactionManagerlookup);
            } else if (ispnTmLookupClassName != null && !ispnTmLookupClassName.equals(hbTmLookupClassName)) {
                log.debug((Object)("Infinispan is configured [" + ispnTmLookupClassName + "] with a different transaction manager lookup class than Hibernate [" + hbTmLookupClassName + "]"));
            } else {
                builder.transaction().transactionManagerLookup(this.transactionManagerlookup);
            }
            builder.transaction().useSynchronization(true);
        }
    }
}

