/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.hibernate.cache.main.util;

import java.util.Properties;
import org.hibernate.boot.internal.SessionFactoryBuilderImpl;
import org.hibernate.boot.internal.SessionFactoryOptionsImpl;
import org.hibernate.boot.internal.SessionFactoryOptionsState;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.internal.CacheDataDescriptionImpl;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.internal.util.compare.ComparableComparator;
import org.hibernate.service.ServiceRegistry;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.hibernate.cache.commons.InfinispanBaseRegion;
import org.infinispan.hibernate.cache.main.InfinispanRegionFactory;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.hibernate.cache.commons.util.TestRegionFactory;
import org.infinispan.test.hibernate.cache.main.util.TestInfinispanRegionFactory;

class TestRegionFactoryImpl
implements TestRegionFactory {
    private static final CacheDataDescriptionImpl MUTABLE_VERSIONED = new CacheDataDescriptionImpl(true, true, ComparableComparator.INSTANCE, null);
    private final InfinispanRegionFactory delegate;

    TestRegionFactoryImpl(InfinispanRegionFactory delegate) {
        this.delegate = delegate;
    }

    public void start(ServiceRegistry serviceRegistry, Properties p) {
        SessionFactoryOptionsImpl sessionFactoryOptions = new SessionFactoryOptionsImpl((SessionFactoryOptionsState)new SessionFactoryBuilderImpl.SessionFactoryOptionsStateStandardImpl((StandardServiceRegistry)serviceRegistry));
        this.delegate.start((SessionFactoryOptions)sessionFactoryOptions, p);
    }

    public void stop() {
        this.delegate.stop();
    }

    public void setCacheManager(EmbeddedCacheManager cm) {
        this.delegate.setCacheManager(cm);
    }

    public EmbeddedCacheManager getCacheManager() {
        return this.delegate.getCacheManager();
    }

    public String getBaseConfiguration(String regionName) {
        if (this.delegate instanceof TestInfinispanRegionFactory) {
            return ((TestInfinispanRegionFactory)this.delegate).getBaseConfiguration(regionName);
        }
        throw new UnsupportedOperationException();
    }

    public Configuration getConfigurationOverride(String regionName) {
        if (this.delegate instanceof TestInfinispanRegionFactory) {
            return ((TestInfinispanRegionFactory)this.delegate).getConfigurationOverride(regionName);
        }
        throw new UnsupportedOperationException();
    }

    public Configuration getPendingPutsCacheConfiguration() {
        return this.delegate.getPendingPutsCacheConfiguration();
    }

    public InfinispanBaseRegion buildCollectionRegion(String regionName, AccessType accessType) {
        String prefix = this.delegate.getSettings().getCacheRegionPrefix();
        if (prefix != null && !prefix.isEmpty()) {
            regionName = prefix + '.' + regionName;
        }
        return (InfinispanBaseRegion)this.delegate.buildCollectionRegion(regionName, (Properties)null, (CacheDataDescription)MUTABLE_VERSIONED);
    }

    public InfinispanBaseRegion buildEntityRegion(String regionName, AccessType accessType) {
        String prefix = this.delegate.getSettings().getCacheRegionPrefix();
        if (prefix != null && !prefix.isEmpty()) {
            regionName = prefix + '.' + regionName;
        }
        return (InfinispanBaseRegion)this.delegate.buildEntityRegion(regionName, (Properties)null, (CacheDataDescription)MUTABLE_VERSIONED);
    }

    public InfinispanBaseRegion buildTimestampsRegion(String regionName) {
        String prefix = this.delegate.getSettings().getCacheRegionPrefix();
        if (prefix != null && !prefix.isEmpty()) {
            regionName = prefix + '.' + regionName;
        }
        return (InfinispanBaseRegion)this.delegate.buildTimestampsRegion(regionName, (Properties)null);
    }

    public InfinispanBaseRegion buildQueryResultsRegion(String regionName) {
        String prefix = this.delegate.getSettings().getCacheRegionPrefix();
        if (prefix != null && !prefix.isEmpty()) {
            regionName = prefix + '.' + regionName;
        }
        return (InfinispanBaseRegion)this.delegate.buildQueryResultsRegion(regionName, (Properties)null);
    }

    public long nextTimestamp() {
        return this.delegate.nextTimestamp();
    }
}

