/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.it.marshalling.jboss;

import org.infinispan.Cache;
import org.infinispan.client.hotrod.ProtocolVersion;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheContainer;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.Search;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.impl.query.RemoteQueryFactory;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.jboss.marshalling.commons.GenericJBossMarshaller;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.embedded.QueryDslConditionsTest;
import org.infinispan.search.mapper.mapping.SearchMapping;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.query.JBMARRemoteQueryDslConditionsTest")
public class JBMARRemoteQueryDslConditionsTest
extends QueryDslConditionsTest {
    protected HotRodServer hotRodServer;
    protected RemoteCacheManager remoteCacheManager;
    protected RemoteCache<Object, Object> remoteCache;
    protected Cache<Object, Object> cache;

    protected QueryFactory getQueryFactory() {
        return Search.getQueryFactory(this.remoteCache);
    }

    protected RemoteCache<Object, Object> getCacheForQuery() {
        return this.remoteCache;
    }

    protected ProtocolVersion getProtocolVersion() {
        return ProtocolVersion.DEFAULT_PROTOCOL_VERSION;
    }

    protected Cache<Object, Object> getEmbeddedCache() {
        return this.cache;
    }

    protected void createCacheManagers() {
        GlobalConfigurationBuilder globalCfg = GlobalConfigurationBuilder.defaultClusteredBuilder();
        globalCfg.serialization().marshaller((Marshaller)new GenericJBossMarshaller());
        org.infinispan.configuration.cache.ConfigurationBuilder cfg = this.getConfigurationBuilder();
        this.createClusteredCaches(1, globalCfg, cfg, true, new String[0]);
        this.cache = this.manager(0).getCache();
        this.hotRodServer = HotRodClientTestingUtil.startHotRodServer((EmbeddedCacheManager)this.manager(0));
        ConfigurationBuilder clientBuilder = HotRodClientTestingUtil.newRemoteConfigurationBuilder();
        clientBuilder.addServer().host("127.0.0.1").port(this.hotRodServer.getPort().intValue());
        clientBuilder.version(this.getProtocolVersion());
        clientBuilder.marshaller((Marshaller)new GenericJBossMarshaller());
        this.remoteCacheManager = new RemoteCacheManager(clientBuilder.build());
        this.remoteCache = this.remoteCacheManager.getCache();
        this.cacheManagers.forEach(c -> c.getClassAllowList().addRegexps(new String[]{".*"}));
    }

    protected org.infinispan.configuration.cache.ConfigurationBuilder getConfigurationBuilder() {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = HotRodTestingUtil.hotRodCacheConfiguration();
        builder.encoding().key().mediaType("application/x-java-object");
        builder.encoding().value().mediaType("application/x-java-object");
        builder.indexing().enable().storage(IndexStorage.LOCAL_HEAP).addIndexedEntity(this.getModelFactory().getUserImplClass()).addIndexedEntity(this.getModelFactory().getAccountImplClass()).addIndexedEntity(this.getModelFactory().getTransactionImplClass());
        return builder;
    }

    @AfterClass(alwaysRun=true)
    public void release() {
        HotRodClientTestingUtil.killRemoteCacheManager((RemoteCacheContainer)this.remoteCacheManager);
        this.remoteCacheManager = null;
        HotRodClientTestingUtil.killServers((HotRodServer[])new HotRodServer[]{this.hotRodServer});
        this.hotRodServer = null;
    }

    public void testIndexPresence() {
        SearchMapping searchMapping = (SearchMapping)TestingUtil.extractComponent(this.cache, SearchMapping.class);
        this.verifyClassIsIndexed(searchMapping, this.getModelFactory().getUserImplClass());
        this.verifyClassIsIndexed(searchMapping, this.getModelFactory().getAccountImplClass());
        this.verifyClassIsIndexed(searchMapping, this.getModelFactory().getTransactionImplClass());
        this.verifyClassIsNotIndexed(searchMapping, this.getModelFactory().getAddressImplClass());
    }

    private void verifyClassIsNotIndexed(SearchMapping searchMapping, Class<?> type) {
        AssertJUnit.assertNull((Object)searchMapping.indexedEntity(type));
    }

    private void verifyClassIsIndexed(SearchMapping searchMapping, Class<?> type) {
        AssertJUnit.assertNotNull((Object)searchMapping.indexedEntity(type));
    }

    public void testQueryFactoryType() {
        AssertJUnit.assertEquals(RemoteQueryFactory.class, this.getQueryFactory().getClass());
    }

    @Test(expectedExceptions={HotRodClientException.class}, expectedExceptionsMessageRegExp=".*ISPN028503:.*")
    public void testInvalidEmbeddedAttributeQuery() {
        super.testInvalidEmbeddedAttributeQuery();
    }

    @Test(expectedExceptions={HotRodClientException.class}, expectedExceptionsMessageRegExp="org.infinispan.objectfilter.ParsingException: ISPN014027: The property path 'addresses.postCode' cannot be projected because it is multi-valued")
    public void testRejectProjectionOfRepeatedProperty() {
        super.testRejectProjectionOfRepeatedProperty();
    }

    @Test(expectedExceptions={HotRodClientException.class}, expectedExceptionsMessageRegExp="org.infinispan.objectfilter.ParsingException: ISPN014026: The expression 'surname' must be part of an aggregate function or it should be included in the GROUP BY clause")
    public void testGroupBy3() {
        super.testGroupBy3();
    }

    @Test(expectedExceptions={HotRodClientException.class}, expectedExceptionsMessageRegExp="org.infinispan.objectfilter.ParsingException: ISPN014021: Queries containing grouping and aggregation functions must use projections.")
    public void testGroupBy5() {
        super.testGroupBy5();
    }

    @Test(expectedExceptions={HotRodClientException.class}, expectedExceptionsMessageRegExp="java.lang.IllegalStateException: Aggregation SUM cannot be applied to property of type java.lang.String")
    public void testGroupBy6() {
        super.testGroupBy6();
    }

    @Test(expectedExceptions={HotRodClientException.class}, expectedExceptionsMessageRegExp="org.infinispan.objectfilter.ParsingException: ISPN028515: Cannot have aggregate functions in the WHERE clause : SUM.")
    public void testGroupBy7() {
        super.testGroupBy7();
    }

    @Test(expectedExceptions={IllegalStateException.class}, expectedExceptionsMessageRegExp="ISPN014825: Query parameter 'param2' was not set")
    public void testMissingParamWithParameterMap() {
        super.testMissingParamWithParameterMap();
    }

    @Test(expectedExceptions={IllegalStateException.class}, expectedExceptionsMessageRegExp="ISPN014825: Query parameter 'param2' was not set")
    public void testMissingParam() {
        super.testMissingParam();
    }

    @Test(expectedExceptions={HotRodClientException.class}, expectedExceptionsMessageRegExp="org.infinispan.objectfilter.ParsingException: ISPN014023: Using the multi-valued property path 'addresses.street' in the GROUP BY clause is not currently supported")
    public void testGroupByMustNotAcceptRepeatedProperty() {
        super.testGroupByMustNotAcceptRepeatedProperty();
    }

    @Test(expectedExceptions={HotRodClientException.class}, expectedExceptionsMessageRegExp="org.infinispan.objectfilter.ParsingException: ISPN014024: The property path 'addresses.street' cannot be used in the ORDER BY clause because it is multi-valued")
    public void testOrderByMustNotAcceptRepeatedProperty() {
        super.testOrderByMustNotAcceptRepeatedProperty();
    }

    @Test(expectedExceptions={HotRodClientException.class}, expectedExceptionsMessageRegExp="org.infinispan.objectfilter.ParsingException: ISPN028515: Cannot have aggregate functions in the WHERE clause : MIN.")
    public void testRejectAggregationsInWhereClause() {
        super.testRejectAggregationsInWhereClause();
    }
}

