/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jboss.marshalling.core;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.invoke.SerializedLambda;
import java.util.Arrays;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.marshall.core.GlobalMarshaller;
import org.infinispan.marshall.core.MarshallableFunctions;
import org.infinispan.marshall.persistence.PersistenceMarshaller;
import org.infinispan.util.function.SerializableFunction;
import org.jboss.marshalling.ObjectTable;
import org.jboss.marshalling.Unmarshaller;

class JbossInternalObjectTable
implements ObjectTable {
    private final GlobalMarshaller gm;
    private final PersistenceMarshaller pm;

    JbossInternalObjectTable(GlobalMarshaller gm) {
        this.gm = gm;
        this.pm = gm.getPersistenceMarshaller();
    }

    public ObjectTable.Writer getObjectWriter(Object obj) {
        Class<?> clazz = obj.getClass();
        AdvancedExternalizer internalExt = GlobalMarshaller.getInteralExternalizer((GlobalMarshaller)this.gm, clazz);
        if (internalExt != null) {
            return (out, object) -> GlobalMarshaller.writeInternalClean((Object)object, (AdvancedExternalizer)internalExt, (ObjectOutput)out);
        }
        AdvancedExternalizer externalExt = GlobalMarshaller.getExternalExternalizer((GlobalMarshaller)this.gm, clazz);
        if (externalExt != null) {
            return (out, object) -> GlobalMarshaller.writeExternalClean((Object)object, (AdvancedExternalizer)externalExt, (ObjectOutput)out);
        }
        try {
            if (!this.isFunctionOrArrayOf(obj) && this.pm.isMarshallable(obj)) {
                return this::writeUnknownClean;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private boolean isFunctionOrArrayOf(Object o) {
        Class<?> clazz = o.getClass();
        if (clazz.isArray()) {
            return Arrays.stream((Object[])o).anyMatch(this::isFunctionOrArrayOf);
        }
        if (clazz.isSynthetic() || o instanceof SerializedLambda || o instanceof SerializableFunction) {
            return true;
        }
        Class<?> enclosingClass = clazz.getEnclosingClass();
        return enclosingClass != null && enclosingClass.equals(MarshallableFunctions.class);
    }

    public Object readObject(Unmarshaller unmarshaller) throws IOException, ClassNotFoundException {
        return GlobalMarshaller.readObjectFromObjectInput((GlobalMarshaller)this.gm, (ObjectInput)unmarshaller);
    }

    private void writeUnknownClean(ObjectOutput out, Object obj) {
        try {
            GlobalMarshaller.writeUnknown((Marshaller)this.pm, (Object)obj, (ObjectOutput)out);
        }
        catch (IOException e) {
            throw new CacheException((Throwable)e);
        }
    }
}

