/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jboss.marshalling.dataconversion;

import java.io.IOException;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.dataconversion.Encoder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.jboss.marshalling.commons.GenericJBossMarshaller;
import org.infinispan.jboss.marshalling.dataconversion.GenericJbossMarshallerEncoder;
import org.infinispan.marshall.core.EncoderRegistry;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.data.Person;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="marshall.jboss.DataConversionTest")
public class DataConversionTest
extends org.infinispan.dataconversion.DataConversionTest {
    @Test
    public void testObjectEncoder() {
        final GenericJbossMarshallerEncoder encoder = new GenericJbossMarshallerEncoder(org.infinispan.dataconversion.DataConversionTest.class.getClassLoader());
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)new ConfigurationBuilder())){
            GenericJBossMarshaller marshaller;
            {
                super(cm);
                this.marshaller = new GenericJBossMarshaller();
            }

            private byte[] marshall(Object o) {
                try {
                    return this.marshaller.objectToByteBuffer(o);
                }
                catch (IOException | InterruptedException e) {
                    throw new AssertionError("Cannot marshall content", e);
                }
            }

            public void call() {
                GlobalComponentRegistry registry = this.cm.getGlobalComponentRegistry();
                EncoderRegistry encoderRegistry = (EncoderRegistry)registry.getComponent(EncoderRegistry.class);
                encoderRegistry.registerEncoder((Encoder)encoder);
                this.cm.getClassWhiteList().addClasses(new Class[]{Person.class});
                Cache cache = this.cm.getCache();
                Person key1 = new Person("key1");
                Person value1 = new Person("value1");
                byte[] encodedKey1 = this.marshall(key1);
                byte[] encodedValue1 = this.marshall(value1);
                cache.put((Object)encodedKey1, (Object)encodedValue1);
                Assert.assertEquals((byte[])((byte[])cache.get((Object)encodedKey1)), (byte[])encodedValue1);
                AdvancedCache encodingCache = cache.getAdvancedCache().withEncoding(GenericJbossMarshallerEncoder.class);
                Assert.assertEquals((Object)encodingCache.get((Object)key1), (Object)value1);
            }
        });
    }
}

