/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jboss.marshalling;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.TreeSet;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.jboss.marshalling.JBossMarshallingTest;
import org.infinispan.jboss.marshalling.PojoWithJBossExternalize;
import org.infinispan.jboss.marshalling.core.JBossUserMarshaller;
import org.infinispan.marshall.VersionAwareMarshallerTest;
import org.infinispan.test.TestingUtil;
import org.jboss.marshalling.TraceInformation;
import org.testng.AssertJUnit;

public class VersionAwareMarshallerTest
extends org.infinispan.marshall.VersionAwareMarshallerTest {
    protected GlobalConfigurationBuilder globalConfiguration() {
        GlobalConfigurationBuilder globalBuilder = super.globalConfiguration();
        globalBuilder.serialization().marshaller((Marshaller)new JBossUserMarshaller());
        return globalBuilder;
    }

    public void testPojoWithJBossMarshallingExternalizer(Method m) throws Exception {
        PojoWithJBossExternalize pojo = new PojoWithJBossExternalize(27, TestingUtil.k((Method)m));
        this.marshallAndAssertEquality(pojo);
    }

    public void testIsMarshallableJBossExternalizeAnnotation() throws Exception {
        PojoWithJBossExternalize pojo = new PojoWithJBossExternalize(34, "k2");
        AssertJUnit.assertTrue((boolean)this.marshaller.isMarshallable((Object)pojo));
    }

    public void testMarshallObjectThatContainsACustomReadObjectMethod() throws Exception {
        JBossMarshallingTest.ObjectThatContainsACustomReadObjectMethod obj = new JBossMarshallingTest.ObjectThatContainsACustomReadObjectMethod();
        obj.anObjectWithCustomReadObjectMethod = new JBossMarshallingTest.CustomReadObjectMethod();
        this.marshallAndAssertEquality(obj);
    }

    public void testMarshallingNestedSerializableSubclass() throws Exception {
        Child1 child1Obj = new Child1(1234, "1234");
        Child2 child2Obj = new Child2(2345, "2345", child1Obj);
        byte[] bytes = this.marshaller.objectToByteBuffer((Object)child2Obj);
        Child2 readChild2 = (Child2)this.marshaller.objectFromByteBuffer(bytes);
        AssertJUnit.assertEquals((int)2345, (int)readChild2.someInt);
        AssertJUnit.assertEquals((String)"2345", (String)readChild2.getId());
        AssertJUnit.assertEquals((int)1234, (int)readChild2.getChild1Obj().someInt);
        AssertJUnit.assertEquals((String)"1234", (String)readChild2.getChild1Obj().getId());
    }

    public void testMarshallingSerializableSubclass() throws Exception {
        Child1 child1Obj = new Child1(1234, "1234");
        byte[] bytes = this.marshaller.objectToByteBuffer((Object)child1Obj);
        Child1 readChild1 = (Child1)this.marshaller.objectFromByteBuffer(bytes);
        AssertJUnit.assertEquals((int)1234, (int)readChild1.someInt);
        AssertJUnit.assertEquals((String)"1234", (String)readChild1.getId());
    }

    public void testTreeSetWithComparator() throws Exception {
        TreeSet<VersionAwareMarshallerTest.Human> treeSet = new TreeSet<VersionAwareMarshallerTest.Human>((Comparator<VersionAwareMarshallerTest.Human>)new VersionAwareMarshallerTest.HumanComparator());
        for (int i = 0; i < 10; ++i) {
            treeSet.add(new VersionAwareMarshallerTest.Human().age(i));
        }
        this.marshallAndAssertEquality(treeSet);
    }

    public void testErrorUnmarshalling() throws Exception {
        block2: {
            VersionAwareMarshallerTest.PojoWhichFailsOnUnmarshalling pojo = new VersionAwareMarshallerTest.PojoWhichFailsOnUnmarshalling();
            byte[] bytes = this.marshaller.objectToByteBuffer((Object)pojo);
            try {
                this.marshaller.objectFromByteBuffer(bytes);
            }
            catch (Exception e) {
                TraceInformation inf = (TraceInformation)e.getCause();
                if ($assertionsDisabled || inf.toString().contains("in object of type org.infinispan.marshall.VersionAwareMarshallerTest$PojoWhichFailsOnUnmarshalling")) break block2;
                throw new AssertionError();
            }
        }
    }

    static class Child2
    extends Parent {
        private final int someInt;

        public Child2(int someInt, String parentStr, Child1 child1Obj) {
            super(parentStr, child1Obj);
            this.someInt = someInt;
        }
    }

    static class Child1
    extends Parent {
        private final int someInt;

        public Child1(int someInt, String parentStr) {
            super(parentStr, null);
            this.someInt = someInt;
        }
    }

    static class Parent
    implements Serializable {
        private final String id;
        private final Child1 child1Obj;

        public Parent(String id, Child1 child1Obj) {
            this.id = id;
            this.child1Obj = child1Obj;
        }

        public String getId() {
            return this.id;
        }

        public Child1 getChild1Obj() {
            return this.child1Obj;
        }
    }
}

