/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache.remote;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.spi.CachingProvider;
import org.infinispan.commons.util.FileLookupFactory;
import org.infinispan.test.AbstractInfinispanTest;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="jcache.remote.JCacheConfigurationPropertiesFileTest", groups={"functional"})
public class JCacheConfigurationPropertiesFileTest
extends AbstractInfinispanTest {
    public void testPropertiesConfiguration() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        ClassLoader cl = clazz.getClassLoader();
        CachingProvider provider = Caching.getCachingProvider((ClassLoader)cl);
        Properties testProperties = this.getProperties(cl, "hotrod-client.properties");
        try (CacheManager cm = provider.getCacheManager(URI.create(clazz.getName()), cl);){
            AssertJUnit.assertEquals((Object)testProperties, (Object)cm.getProperties());
        }
    }

    public void testPropertiesURIConfiguration() throws URISyntaxException {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        ClassLoader cl = clazz.getClassLoader();
        CachingProvider provider = Caching.getCachingProvider((ClassLoader)cl);
        Properties testProperties = this.getProperties(cl, "hotrod-client-custom.properties");
        try (CacheManager cm = provider.getCacheManager(cl.getResource("hotrod-client-custom.properties").toURI(), cl);){
            AssertJUnit.assertEquals((Object)testProperties, (Object)cm.getProperties());
        }
    }

    public Properties getProperties(ClassLoader cl, String name) {
        Properties properties;
        block8: {
            InputStream is = FileLookupFactory.newInstance().lookupFile(name, cl);
            try {
                Properties testProperties = new Properties();
                testProperties.load(is);
                properties = testProperties;
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new AssertionError((Object)e);
                }
            }
            is.close();
        }
        return properties;
    }
}

