/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache.remote;

import java.net.URI;
import java.util.Properties;
import javax.cache.CacheManager;
import javax.cache.spi.CachingProvider;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.ServerConfiguration;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.util.ReflectionUtil;
import org.infinispan.jcache.AbstractJCache;
import org.infinispan.jcache.AbstractJCacheManager;
import org.infinispan.jcache.logging.Log;
import org.infinispan.jcache.remote.ConfigurationAdapter;
import org.infinispan.jcache.remote.JCache;
import org.infinispan.jcache.remote.ServerManager;

public class JCacheManager
extends AbstractJCacheManager {
    private static final Log log = (Log)LogFactory.getLog(JCacheManager.class, Log.class);
    private RemoteCacheManager cm;
    private RemoteCacheManager cmForceReturnValue;
    private ServerManager sm;

    public JCacheManager(URI uri, ClassLoader classLoader, CachingProvider provider, Properties properties) {
        super(uri, classLoader, provider, properties, false);
        ConfigurationBuilder builder = new ConfigurationBuilder();
        if (properties != null) {
            builder.withProperties(properties);
        } else {
            builder.addServer().host("127.0.0.1").port(11222);
        }
        Configuration configuration = builder.build();
        this.cm = new RemoteCacheManager(configuration, true);
        builder.forceReturnValues(true);
        this.cmForceReturnValue = new RemoteCacheManager(builder.build(), true);
        this.sm = new ServerManager(((ServerConfiguration)configuration.servers().get(0)).host());
    }

    protected boolean supportsJmx() {
        return false;
    }

    public ClassLoader getClassLoader() {
        return this.cm.getConfiguration().classLoader();
    }

    protected <K, V, C extends javax.cache.configuration.Configuration<K, V>> AbstractJCache<K, V> create(String cacheName, C configuration) {
        ConfigurationAdapter adapter = ConfigurationAdapter.create(configuration);
        try {
            if (!this.sm.containsCache(cacheName)) {
                this.sm.addCache(cacheName);
            }
        }
        catch (ServerManager.NotAvailableException ex) {
        }
        catch (ServerManager.ManagementClientException ex) {
            throw log.cacheCreationFailed(cacheName, (Throwable)ex);
        }
        RemoteCache ispnCache = this.cm.getCache(cacheName);
        if (ispnCache == null) {
            throw log.cacheNotFound(cacheName);
        }
        RemoteCache ispnCacheForceReturnValue = this.cmForceReturnValue.getCache(cacheName);
        if (ispnCacheForceReturnValue == null) {
            throw log.cacheNotFound(cacheName);
        }
        return new JCache(ispnCache, ispnCacheForceReturnValue, (CacheManager)this, adapter);
    }

    protected <K, V, I extends BasicCache<K, V>> AbstractJCache<K, V> create(I ispnCache) {
        return null;
    }

    public <T> T unwrap(Class<T> clazz) {
        return (T)ReflectionUtil.unwrap((Object)((Object)this), clazz);
    }

    protected Iterable<String> delegateCacheNames() {
        return this.getManagedCacheNames();
    }

    protected void delegateStop() {
        this.cm.stop();
        this.cmForceReturnValue.stop();
    }

    protected boolean delegateIsClosed() {
        return false;
    }

    protected <K, V> void delegateRemoveCache(AbstractJCache<K, V> jcache) {
        try {
            this.sm.removeCache(jcache.getName());
        }
        catch (ServerManager.NotAvailableException ex) {
        }
        catch (ServerManager.ManagementClientException ex) {
            throw log.serverManagementOperationFailed((Throwable)ex);
        }
        jcache.close();
    }

    protected void delegateLogIsClosed() {
        throw log.cacheClosed();
    }
}

