/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import javax.cache.event.CacheEntryCreatedListener;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.CacheEntryExpiredListener;
import javax.cache.event.CacheEntryListenerException;
import javax.cache.event.CacheEntryRemovedListener;
import javax.cache.event.CacheEntryUpdatedListener;
import javax.cache.event.EventType;
import org.testng.Assert;

public class TrackingCacheEntryListener<K, V>
implements CacheEntryCreatedListener<K, V>,
CacheEntryUpdatedListener<K, V>,
CacheEntryExpiredListener<K, V>,
CacheEntryRemovedListener<K, V>,
Serializable,
AutoCloseable {
    final AtomicInteger created = new AtomicInteger();
    final AtomicInteger updated = new AtomicInteger();
    final AtomicInteger removed = new AtomicInteger();

    public int getCreated() {
        return this.created.get();
    }

    public int getUpdated() {
        return this.updated.get();
    }

    public int getRemoved() {
        return this.removed.get();
    }

    public void onCreated(Iterable<CacheEntryEvent<? extends K, ? extends V>> events) throws CacheEntryListenerException {
        for (CacheEntryEvent<K, V> cacheEntryEvent : events) {
            Assert.assertEquals((Object)EventType.CREATED, (Object)cacheEntryEvent.getEventType());
            this.created.incrementAndGet();
        }
    }

    public void onExpired(Iterable<CacheEntryEvent<? extends K, ? extends V>> events) throws CacheEntryListenerException {
    }

    public void onRemoved(Iterable<CacheEntryEvent<? extends K, ? extends V>> events) throws CacheEntryListenerException {
        for (CacheEntryEvent<K, V> cacheEntryEvent : events) {
            Assert.assertEquals((Object)EventType.REMOVED, (Object)cacheEntryEvent.getEventType());
            this.removed.incrementAndGet();
            if (!cacheEntryEvent.isOldValueAvailable()) continue;
            cacheEntryEvent.getOldValue();
        }
    }

    public void onUpdated(Iterable<CacheEntryEvent<? extends K, ? extends V>> events) throws CacheEntryListenerException {
        for (CacheEntryEvent<K, V> cacheEntryEvent : events) {
            Assert.assertEquals((Object)EventType.UPDATED, (Object)cacheEntryEvent.getEventType());
            this.updated.incrementAndGet();
            if (!cacheEntryEvent.isOldValueAvailable()) continue;
            cacheEntryEvent.getOldValue();
        }
    }

    @Override
    public void close() {
    }
}

