/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache;

import java.net.URI;
import java.util.Properties;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.FactoryBuilder;
import javax.cache.configuration.MutableCacheEntryListenerConfiguration;
import javax.cache.configuration.MutableConfiguration;
import org.infinispan.jcache.TrackingCacheEntryListener;
import org.infinispan.jcache.remote.JCachingProvider;
import org.jboss.arquillian.container.test.api.ContainerController;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class JCacheFailoverIT {
    private static final String CONTAINER1 = "container-1";
    private static final String CONTAINER2 = "container-2";
    @ArquillianResource
    private ContainerController controller;

    private MutableConfiguration<String, String> createConfigurationWith(TrackingCacheEntryListener<String, String> listener) {
        return new MutableConfiguration().setTypes(String.class, String.class).addCacheEntryListenerConfiguration((CacheEntryListenerConfiguration)new MutableCacheEntryListenerConfiguration(FactoryBuilder.factoryOf(listener), null, true, true));
    }

    private CacheManager createCacheManagerWithTimeoutInMillis(int timeout) {
        Properties properties = new Properties();
        properties.put("infinispan.client.hotrod.socket_timeout", String.valueOf(timeout));
        return Caching.getCachingProvider().getCacheManager(URI.create(JCachingProvider.class.getName()), this.getClass().getClassLoader(), properties);
    }

    @Test
    public void testRemoteListener() {
        this.controller.start(CONTAINER1);
        Assert.assertTrue((boolean)this.controller.isStarted(CONTAINER1));
        TrackingCacheEntryListener<String, String> listener = new TrackingCacheEntryListener<String, String>();
        MutableConfiguration<String, String> configuration = this.createConfigurationWith(listener);
        CacheManager cm = this.createCacheManagerWithTimeoutInMillis(3000);
        Cache cache = cm.createCache("namedCache", configuration);
        cache.put((Object)"1", (Object)"value1");
        Assert.assertEquals((long)1L, (long)listener.getCreated());
        this.controller.start(CONTAINER2);
        Assert.assertTrue((boolean)this.controller.isStarted(CONTAINER2));
        cache.put((Object)"2", (Object)"value2");
        Assert.assertEquals((long)2L, (long)listener.getCreated());
        int beforeFailOver = listener.getCreated();
        this.controller.kill(CONTAINER1);
        cache.put((Object)"3", (Object)"value3");
        cache.put((Object)"4", (Object)"value4");
        cache.put((Object)"5", (Object)"value5");
        Assert.assertTrue((listener.getCreated() > beforeFailOver ? 1 : 0) != 0);
    }
}

