/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache;

import java.lang.reflect.Method;
import java.util.Properties;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.spi.CachingProvider;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.jcache.AbstractTwoCachesBasicOpsTest;
import org.infinispan.jcache.util.JCacheTestingUtil;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(testName="org.infinispan.jcache.JCacheTwoCachesBasicOpsTest", groups={"functional"})
public class JCacheTwoCachesBasicOpsTest
extends AbstractTwoCachesBasicOpsTest {
    public static final String CACHE_NAME = "jcache-remote-cache";
    private HotRodServer hotRodServer1;
    private HotRodServer hotRodServer2;
    private CacheManager cm1;
    private CacheManager cm2;
    private ClassLoader testSpecificClassLoader;

    protected void createCacheManagers() throws Throwable {
        this.createClusteredCaches(2, CACHE_NAME, HotRodTestingUtil.hotRodCacheConfiguration((ConfigurationBuilder)JCacheTwoCachesBasicOpsTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC)));
        this.hotRodServer1 = HotRodClientTestingUtil.startHotRodServer((EmbeddedCacheManager)((EmbeddedCacheManager)this.cacheManagers.get(0)));
        this.hotRodServer2 = HotRodClientTestingUtil.startHotRodServer((EmbeddedCacheManager)((EmbeddedCacheManager)this.cacheManagers.get(1)));
        this.testSpecificClassLoader = new JCacheTestingUtil.TestClassLoader(JCacheTwoCachesBasicOpsTest.class.getClassLoader());
        Properties properties = new Properties();
        properties.put("infinispan.client.hotrod.server_list", this.hotRodServer1.getHost() + ":" + this.hotRodServer1.getPort());
        this.cm1 = JCacheTestingUtil.createCacheManager((CachingProvider)Caching.getCachingProvider((ClassLoader)this.testSpecificClassLoader), JCacheTwoCachesBasicOpsTest.class, (String)CACHE_NAME, (Properties)properties);
        properties = new Properties();
        properties.put("infinispan.client.hotrod.server_list", this.hotRodServer2.getHost() + ":" + this.hotRodServer2.getPort());
        this.cm2 = JCacheTestingUtil.createCacheManager((CachingProvider)Caching.getCachingProvider((ClassLoader)this.testSpecificClassLoader), JCacheTwoCachesBasicOpsTest.class, (String)CACHE_NAME, (Properties)properties);
        this.waitForClusterToForm("default");
    }

    @AfterClass
    protected void destroy() {
        super.destroy();
        HotRodClientTestingUtil.killServers((HotRodServer[])new HotRodServer[]{this.hotRodServer1, this.hotRodServer2});
        Caching.getCachingProvider((ClassLoader)this.testSpecificClassLoader).close();
    }

    public Cache getCache1(Method m) {
        return this.cm1.getCache(CACHE_NAME);
    }

    public Cache getCache2(Method m) {
        return this.cm2.getCache(CACHE_NAME);
    }
}

