/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache.remote;

import java.lang.reflect.Method;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.cache.Cache;
import javax.cache.Caching;
import javax.cache.spi.CachingProvider;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.jcache.AbstractTwoCachesExpirationTest;
import org.infinispan.jcache.util.JCacheTestingUtil;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.admin.AdminOperationsHandler;
import org.infinispan.server.core.admin.embeddedserver.EmbeddedServerAdminOperationHandler;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.util.TimeService;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(testName="org.infinispan.jcache.remote.JCacheTwoCachesExpirationTest", groups={"functional"})
@CleanupAfterMethod
public class JCacheTwoCachesExpirationTest
extends AbstractTwoCachesExpirationTest {
    private HotRodServer hotRodServer1;
    private HotRodServer hotRodServer2;
    private Cache cache1;
    private Cache cache2;
    private ClassLoader testSpecificClassLoader;

    protected void createCacheManagers() throws Throwable {
        this.createClusteredCaches(2, "expiry", JCacheTwoCachesExpirationTest.getExpiryCacheConfig());
        this.cacheManagers.forEach(cm -> {
            TimeService cfr_ignored_0 = (TimeService)TestingUtil.replaceComponent((CacheContainer)cm, TimeService.class, (Object)this.controlledTimeService, (boolean)true);
        });
        this.hotRodServer1 = HotRodClientTestingUtil.startHotRodServer((EmbeddedCacheManager)((EmbeddedCacheManager)this.cacheManagers.get(0)), (HotRodServerConfigurationBuilder)((HotRodServerConfigurationBuilder)new HotRodServerConfigurationBuilder().adminOperationsHandler((AdminOperationsHandler)new EmbeddedServerAdminOperationHandler())));
        this.hotRodServer2 = HotRodClientTestingUtil.startHotRodServer((EmbeddedCacheManager)((EmbeddedCacheManager)this.cacheManagers.get(1)), (HotRodServerConfigurationBuilder)((HotRodServerConfigurationBuilder)new HotRodServerConfigurationBuilder().adminOperationsHandler((AdminOperationsHandler)new EmbeddedServerAdminOperationHandler())));
        this.testSpecificClassLoader = new JCacheTestingUtil.TestClassLoader(JCacheTwoCachesExpirationTest.class.getClassLoader());
        Properties properties = new Properties();
        properties.put("infinispan.client.hotrod.server_list", this.hotRodServer1.getHost() + ":" + this.hotRodServer1.getPort());
        this.cache1 = JCacheTestingUtil.createCacheWithProperties((CachingProvider)Caching.getCachingProvider((ClassLoader)this.testSpecificClassLoader), JCacheTwoCachesExpirationTest.class, (String)"expiry", (Properties)properties);
        properties = new Properties();
        properties.put("infinispan.client.hotrod.server_list", this.hotRodServer2.getHost() + ":" + this.hotRodServer2.getPort());
        this.cache2 = JCacheTestingUtil.createCacheWithProperties((CachingProvider)Caching.getCachingProvider((ClassLoader)this.testSpecificClassLoader), JCacheTwoCachesExpirationTest.class, (String)"expiry", (Properties)properties);
        this.waitForClusterToForm("expiry");
    }

    protected static ConfigurationBuilder getExpiryCacheConfig() {
        ConfigurationBuilder builder = JCacheTwoCachesExpirationTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC);
        builder.expiration().lifespan(1000L).wakeUpInterval(100L, TimeUnit.MILLISECONDS);
        return HotRodTestingUtil.hotRodCacheConfiguration((ConfigurationBuilder)builder);
    }

    @AfterClass
    protected void destroy() {
        super.destroy();
        HotRodClientTestingUtil.killServers((HotRodServer[])new HotRodServer[]{this.hotRodServer1, this.hotRodServer2});
        Caching.getCachingProvider((ClassLoader)this.testSpecificClassLoader).close();
    }

    public Cache getCache1(Method m) {
        return this.cache1;
    }

    public Cache getCache2(Method m) {
        return this.cache2;
    }
}

