/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache.remote;

import java.net.URI;
import java.util.Properties;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.spi.CachingProvider;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.SingleHotRodServerTest;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.admin.AdminOperationsHandler;
import org.infinispan.server.core.admin.embeddedserver.EmbeddedServerAdminOperationHandler;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="jcache.remote.JCacheCreateCachePredefinedTest")
public class JCacheCreateCachePredefinedTest
extends SingleHotRodServerTest {
    static String CACHE_NAME_UNTOUCHED = "jcache-remote-predefined-untouched";
    static String CACHE_NAME_TOUCHED = "jcache-remote-predefined-touched";
    private CacheManager jcacheManager;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager();
        cm.defineConfiguration(CACHE_NAME_UNTOUCHED, HotRodTestingUtil.hotRodCacheConfiguration().build());
        cm.defineConfiguration(CACHE_NAME_TOUCHED, HotRodTestingUtil.hotRodCacheConfiguration().build());
        return cm;
    }

    protected HotRodServer createHotRodServer() {
        HotRodServerConfigurationBuilder serverBuilder = new HotRodServerConfigurationBuilder();
        serverBuilder.adminOperationsHandler((AdminOperationsHandler)new EmbeddedServerAdminOperationHandler());
        return HotRodClientTestingUtil.startHotRodServer((EmbeddedCacheManager)this.cacheManager, (HotRodServerConfigurationBuilder)serverBuilder);
    }

    protected void setup() throws Exception {
        super.setup();
        CachingProvider provider = Caching.getCachingProvider();
        URI name = URI.create(JCacheCreateCachePredefinedTest.class.getName());
        ClassLoader cl = JCacheCreateCachePredefinedTest.class.getClassLoader();
        Properties properties = new Properties();
        properties.put("infinispan.client.hotrod.server_list", this.hotrodServer.getHost() + ":" + this.hotrodServer.getPort());
        this.jcacheManager = provider.getCacheManager(name, cl, properties);
    }

    @Test(expectedExceptions={CacheException.class}, expectedExceptionsMessageRegExp=".*ISPN021015:.*")
    public void testCreateCachePredefinedTouched() {
        this.jcacheManager.getCache(CACHE_NAME_TOUCHED);
        this.jcacheManager.createCache(CACHE_NAME_TOUCHED, (Configuration)new MutableConfiguration());
    }

    @Test(expectedExceptions={CacheException.class}, expectedExceptionsMessageRegExp=".*ISPN021052:.*", enabled=false, description="ISPN-9237")
    public void testCreateCachePredefinedUntouched() {
        this.jcacheManager.createCache(CACHE_NAME_UNTOUCHED, (Configuration)new MutableConfiguration());
    }
}

