/*
 * Decompiled with CFR 0.152.
 */
package org.jsr107.tck.testutil;

public abstract class AssertionUtil {
    public static void assertEventually(AssertionRunnable assertionRunnable, int timeoutSeconds) {
        long deadline = System.currentTimeMillis() + (long)(timeoutSeconds * 1000);
        while (System.currentTimeMillis() < deadline) {
            try {
                AssertionUtil.runSafely(assertionRunnable);
                return;
            }
            catch (AssertionError assertionError) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        AssertionUtil.runSafely(assertionRunnable);
    }

    public static void assertAllTheTime(AssertionRunnable assertionRunnable, int timeoutSeconds) {
        long deadline = System.currentTimeMillis() + (long)(timeoutSeconds * 1000);
        while (System.currentTimeMillis() < deadline) {
            AssertionUtil.runSafely(assertionRunnable);
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {}
        }
        AssertionUtil.runSafely(assertionRunnable);
    }

    private static void runSafely(AssertionRunnable assertionRunnable) {
        try {
            assertionRunnable.run();
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException("Exception was thrown during assertion execution", e);
        }
    }

    public static interface AssertionRunnable {
        public void run() throws Exception;
    }
}

