/*
 * Decompiled with CFR 0.152.
 */
package org.jsr107.tck;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.cache.configuration.MutableConfiguration;
import org.jsr107.tck.testutil.CacheTestSupport;
import org.jsr107.tck.testutil.ExcludeListExcluder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.MethodRule;

public class PutTest
extends CacheTestSupport<Long, String> {
    @Rule
    public MethodRule rule = new ExcludeListExcluder(this.getClass());

    @Before
    public void moreSetUp() {
        this.cache = this.getCacheManager().getCache(this.getTestCacheName(), Long.class, String.class);
    }

    @Override
    protected MutableConfiguration<Long, String> newMutableConfiguration() {
        return new MutableConfiguration().setTypes(Long.class, String.class);
    }

    @Test
    public void put_Closed() {
        this.cache.close();
        try {
            this.cache.put(null, null);
            Assert.fail((String)"should have thrown an exception - cache closed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void put_NullKey() throws Exception {
        try {
            this.cache.put(null, (Object)"");
            Assert.fail((String)"should have thrown an exception - null key not allowed");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void put_NullValue() throws Exception {
        try {
            this.cache.put((Object)1L, null);
            Assert.fail((String)"should have thrown an exception - null value not allowed");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void put_Existing_NotSameKey() throws Exception {
        Long key1 = System.currentTimeMillis();
        String value1 = "value" + key1;
        this.cache.put((Object)key1, (Object)value1);
        Long key2 = new Long(key1);
        String value2 = "value" + key2;
        this.cache.put((Object)key2, (Object)value2);
        Assert.assertEquals((Object)value2, (Object)this.cache.get((Object)key2));
    }

    @Test
    public void put_Existing_DifferentKey() throws Exception {
        Long key1 = System.currentTimeMillis();
        String value1 = "value" + key1;
        this.cache.put((Object)key1, (Object)value1);
        Long key2 = key1 + 1L;
        String value2 = "value" + key2;
        this.cache.put((Object)key2, (Object)value2);
        Assert.assertEquals((Object)value2, (Object)this.cache.get((Object)key2));
    }

    @Test
    public void getAndPut_Closed() {
        this.cache.close();
        try {
            this.cache.getAndPut(null, null);
            Assert.fail((String)"should have thrown an exception - cache closed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void getAndPut_NullKey() throws Exception {
        try {
            this.cache.getAndPut(null, (Object)"");
            Assert.fail((String)"should have thrown an exception - null key not allowed");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void getAndPut_NullValue() throws Exception {
        try {
            this.cache.getAndPut((Object)1L, null);
            Assert.fail((String)"should have thrown an exception - null value not allowed");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void getAndPut_NotThere() {
        Long existingKey = System.currentTimeMillis();
        String existingValue = "value" + existingKey;
        Assert.assertNull((Object)this.cache.getAndPut((Object)existingKey, (Object)existingValue));
        Assert.assertEquals((Object)existingValue, (Object)this.cache.get((Object)existingKey));
    }

    @Test
    public void getAndPut_Existing() throws Exception {
        Long existingKey = System.currentTimeMillis();
        String value1 = "value1";
        this.cache.getAndPut((Object)existingKey, (Object)value1);
        String value2 = "value2";
        Assert.assertEquals((Object)value1, (Object)this.cache.getAndPut((Object)existingKey, (Object)value2));
        Assert.assertEquals((Object)value2, (Object)this.cache.get((Object)existingKey));
    }

    @Test
    public void getAndPut_Existing_NonSameKey() throws Exception {
        Long key1 = System.currentTimeMillis();
        String value1 = "value1";
        Assert.assertNull((Object)this.cache.getAndPut((Object)key1, (Object)value1));
        Long key2 = new Long(key1);
        String value2 = "value2";
        Assert.assertEquals((Object)value1, (Object)this.cache.getAndPut((Object)key2, (Object)value2));
        Assert.assertEquals((Object)value2, (Object)this.cache.get((Object)key1));
        Assert.assertEquals((Object)value2, (Object)this.cache.get((Object)key2));
    }

    @Test
    public void putIfAbsent_Closed() {
        this.cache.close();
        try {
            this.cache.putIfAbsent(null, null);
            Assert.fail((String)"should have thrown an exception - cache closed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void putIfAbsent_NullKey() throws Exception {
        try {
            Assert.assertFalse((boolean)this.cache.putIfAbsent(null, (Object)""));
            Assert.fail((String)"should have thrown an exception - null key not allowed");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void putIfAbsent_NullValue() {
        try {
            this.cache.putIfAbsent((Object)1L, null);
            Assert.fail((String)"should have thrown an exception - null value not allowed");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void putIfAbsent_Missing() {
        Long key = System.currentTimeMillis();
        String value = "value" + key;
        Assert.assertTrue((boolean)this.cache.putIfAbsent((Object)key, (Object)value));
        Assert.assertEquals((Object)value, (Object)this.cache.get((Object)key));
    }

    @Test
    public void putIfAbsent_Same() {
        Long key = System.currentTimeMillis();
        String value = "valueA" + key;
        String oldValue = "valueB" + key;
        this.cache.put((Object)key, (Object)oldValue);
        Assert.assertFalse((boolean)this.cache.putIfAbsent((Object)key, (Object)value));
        Assert.assertEquals((Object)oldValue, (Object)this.cache.get((Object)key));
    }

    @Test
    public void putAll_Closed() {
        this.cache.close();
        try {
            this.cache.putAll(null);
            Assert.fail((String)"should have thrown an exception - cache closed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void putAll_Null() {
        try {
            this.cache.putAll(null);
            Assert.fail((String)"should have thrown an exception - null map not allowed");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void putAll_NullKey() {
        LinkedHashMap<Long, String> data = this.createLSData(3);
        data.put(null, "");
        try {
            this.cache.putAll(data);
            Assert.fail((String)"should have thrown an exception - null key not allowed");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void putAll_NullValue() {
        LinkedHashMap<Long, String> data = this.createLSData(3);
        data.put(System.currentTimeMillis(), null);
        try {
            this.cache.putAll(data);
            Assert.fail((String)"should have thrown an exception - null value not allowed");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void putAll() {
        LinkedHashMap<Long, String> data = this.createLSData(3);
        this.cache.putAll(data);
        for (Map.Entry entry : data.entrySet()) {
            Assert.assertEquals(entry.getValue(), (Object)this.cache.get(entry.getKey()));
        }
    }
}

