/*
 * Decompiled with CFR 0.152.
 */
package org.jsr107.tck.testutil;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class TestSupport {
    protected static final Logger LOG = Logger.getLogger(TestSupport.class.getName());
    private final Map<Class<?>, Class<?>> unwrapClasses = Collections.synchronizedMap(new HashMap());
    private Properties unwrapProperties;

    public static Object lookupManagementAttribute(Cache cache, MBeanType type, String attributeName) throws Exception {
        MBeanServer mBeanServer = TestSupport.resolveMBeanServer();
        ObjectName objectName = TestSupport.calculateObjectName(cache, type);
        Object attribute = mBeanServer.getAttribute(objectName, attributeName);
        return attribute;
    }

    public static ObjectName calculateObjectName(Cache cache, MBeanType type) {
        try {
            ObjectName name = new ObjectName("javax.cache:type=" + (Object)((Object)type) + "," + "CacheManager=" + TestSupport.mbeanSafe(cache.getCacheManager().getURI().toString()) + ",Cache=" + TestSupport.mbeanSafe(cache.getName()));
            return name;
        }
        catch (MalformedObjectNameException e) {
            throw new CacheException((Throwable)e);
        }
    }

    public static String mbeanSafe(String string) {
        return string == null ? "" : string.replaceAll(":|=|\n|,", ".");
    }

    public static MBeanServer resolveMBeanServer() {
        if (System.getProperty("javax.management.builder.initial") == null) {
            throw new RuntimeException("You must set the 'javax.management.builder.initial' property so that the TCK can find your MBeanServer'");
        }
        if (System.getProperty("org.jsr107.tck.management.agentId") == null) {
            throw new RuntimeException("You must set the 'org.jsr107.tck.management.agentId'system property so that the TCK can find your MBeanServer agent by its ID.'");
        }
        String agentId = System.getProperty("org.jsr107.tck.management.agentId");
        ArrayList<MBeanServer> mBeanServers = MBeanServerFactory.findMBeanServer(agentId);
        if (mBeanServers.size() < 1) {
            throw new CacheException("The specification requires registration of MBeans in an implementation specific MBeanServer. A search for an MBeanServer did not find any.");
        }
        return mBeanServers.get(0);
    }

    protected CacheManager getCacheManager() {
        return Caching.getCachingProvider().getCacheManager();
    }

    protected String getTestCacheName() {
        return this.getClass().getName();
    }

    protected Class<?> getUnwrapClass(Class<?> unwrappableClass) {
        if (this.unwrapClasses.containsKey(unwrappableClass)) {
            return this.unwrapClasses.get(unwrappableClass);
        }
        String unwrapClassName = System.getProperty(unwrappableClass.getName().replace('$', '.'));
        if (unwrapClassName == null || unwrapClassName.trim().length() == 0) {
            this.unwrapClasses.put(unwrappableClass, null);
            return null;
        }
        try {
            Class<?> unwrapClass = Class.forName(unwrapClassName);
            this.unwrapClasses.put(unwrappableClass, unwrapClass);
            return unwrapClass;
        }
        catch (ClassNotFoundException e) {
            LOG.warning("Failed to load unwrap class " + unwrapClassName + " for unwrappable class: " + unwrappableClass);
            this.unwrapClasses.put(unwrappableClass, null);
            return null;
        }
    }

    public static enum MBeanType {
        CacheConfiguration,
        CacheStatistics;

    }
}

