/*
 * Decompiled with CFR 0.152.
 */
package org.jsr107.tck;

import javax.cache.configuration.MutableConfiguration;
import org.jsr107.tck.testutil.CacheTestSupport;
import org.jsr107.tck.testutil.ExcludeListExcluder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.MethodRule;

public class ReplaceTest
extends CacheTestSupport<Long, String> {
    @Rule
    public MethodRule rule = new ExcludeListExcluder(this.getClass());

    @Before
    public void moreSetUp() {
        this.cache = this.getCacheManager().getCache(this.getTestCacheName(), Long.class, String.class);
    }

    @Override
    protected MutableConfiguration<Long, String> newMutableConfiguration() {
        return new MutableConfiguration().setTypes(Long.class, String.class);
    }

    @Test
    public void replace_3arg_Closed() {
        this.cache.close();
        try {
            this.cache.replace(null, null, null);
            Assert.fail((String)"should have thrown an exception - cache closed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void replace_3arg_NullKey() {
        try {
            Assert.assertFalse((boolean)this.cache.replace(null, (Object)"1", (Object)"2"));
            Assert.fail((String)"should have thrown an exception - null key not allowed");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void replace_3arg_NullValue1() {
        try {
            Assert.assertFalse((boolean)this.cache.replace((Object)1L, null, (Object)"2"));
            Assert.fail((String)"should have thrown an exception - null value not allowed");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void replace_3arg_NullValue2() {
        try {
            Assert.assertFalse((boolean)this.cache.replace((Object)1L, (Object)"1", null));
            Assert.fail((String)"should have thrown an exception - null value not allowed");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void replace_3arg_Missing() {
        Long key = System.currentTimeMillis();
        Assert.assertFalse((boolean)this.cache.replace((Object)key, (Object)"1", (Object)"2"));
        Assert.assertFalse((boolean)this.cache.containsKey((Object)key));
    }

    @Test
    public void replace_3arg() throws Exception {
        Long key = System.currentTimeMillis();
        String value = "value" + key;
        this.cache.put((Object)key, (Object)value);
        String nextValue = "value" + key + 1;
        Assert.assertTrue((boolean)this.cache.replace((Object)key, (Object)value, (Object)nextValue));
        Assert.assertEquals((Object)nextValue, (Object)this.cache.get((Object)key));
    }

    @Test
    public void replace_3arg_Equal() {
        Long key = System.currentTimeMillis();
        String value = "value" + key;
        this.cache.put((Object)key, (Object)value);
        String nextValue = "value" + key + 1;
        Assert.assertTrue((boolean)this.cache.replace((Object)new Long(key), (Object)new String(value), (Object)new String(nextValue)));
        Assert.assertEquals((Object)nextValue, (Object)this.cache.get((Object)key));
    }

    @Test
    public void replace_3arg_Different() {
        Long key = System.currentTimeMillis();
        String value = "value" + key;
        this.cache.put((Object)key, (Object)value);
        String nextValue = "valueN" + key;
        String desiredOldValue = "valueB" + key;
        Assert.assertFalse((boolean)this.cache.replace((Object)key, (Object)desiredOldValue, (Object)nextValue));
        Assert.assertEquals((Object)value, (Object)this.cache.get((Object)key));
    }

    @Test
    public void replace_2arg_Closed() {
        this.cache.close();
        try {
            this.cache.replace(null, null);
            Assert.fail((String)"should have thrown an exception - cache closed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void replace_2arg_NullKey() {
        try {
            Assert.assertFalse((boolean)this.cache.replace(null, (Object)""));
            Assert.fail((String)"should have thrown an exception - null key not allowed");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void replace_2arg_NullValue() {
        try {
            Assert.assertFalse((boolean)this.cache.replace((Object)1L, null));
            Assert.fail((String)"should have thrown an exception - null value not allowed");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void replace_2arg_Missing() throws Exception {
        Long key = System.currentTimeMillis();
        Assert.assertFalse((boolean)this.cache.replace((Object)key, (Object)""));
        Assert.assertFalse((boolean)this.cache.containsKey((Object)key));
    }

    @Test
    public void replace_2arg() {
        Long key = System.currentTimeMillis();
        String value = "value" + key;
        this.cache.put((Object)key, (Object)value);
        String nextValue = "valueA" + key;
        Assert.assertTrue((boolean)this.cache.replace((Object)key, (Object)nextValue));
        Assert.assertEquals((Object)nextValue, (Object)this.cache.get((Object)key));
    }

    @Test
    public void getAndReplace_Closed() {
        this.cache.close();
        try {
            this.cache.getAndReplace(null, null);
            Assert.fail((String)"should have thrown an exception - cache closed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void getAndReplace_NullKey() {
        try {
            Assert.assertNull((Object)this.cache.getAndReplace(null, (Object)""));
            Assert.fail((String)"should have thrown an exception - null key not allowed");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void getAndReplace_NullValue() {
        try {
            Assert.assertNull((Object)this.cache.getAndReplace((Object)1L, null));
            Assert.fail((String)"should have thrown an exception - null value not allowed");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void getAndReplace_Missing() {
        Long key = System.currentTimeMillis();
        Assert.assertNull((Object)this.cache.getAndReplace((Object)key, (Object)""));
        Assert.assertFalse((boolean)this.cache.containsKey((Object)key));
    }

    @Test
    public void getAndReplace() {
        Long key = System.currentTimeMillis();
        String value = "value" + key;
        this.cache.put((Object)key, (Object)value);
        String nextValue = "valueB" + key;
        Assert.assertEquals((Object)value, (Object)this.cache.getAndReplace((Object)key, (Object)nextValue));
        Assert.assertEquals((Object)nextValue, (Object)this.cache.get((Object)key));
    }
}

